/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.xml.utils;

import com.ibm.urbancode.zos.deploy.xml.utils.PackageManifest;
import com.ibm.urbancode.zos.deploy.xml.utils.RollbackManifest;
import java.io.File;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;

public class DeploymentResultHelper {
    private static final String PACKAGE_MANIFEST_XML = "packageManifest.xml";
    private static final String DEPLOY_DIRECTORY = "deploy";
    private static final String CONTAINER_MAPPER_XML = "containerMapper.xml";
    private static final String ROLLBACK_MANIFEST_XML = "rollbackManifest.xml";

    public static PackageManifest getDeployedPackageManifest(String deployBasePath, String resourceId, String componentName, String versionName) throws IOException, XMLStreamException {
        String packageManifestFilePath = DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, resourceId, componentName, versionName, PACKAGE_MANIFEST_XML, true);
        String containerMapperFilePath = DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, resourceId, componentName, versionName, CONTAINER_MAPPER_XML, false);
        return PackageManifest.from(packageManifestFilePath, containerMapperFilePath);
    }

    public static RollbackManifest getRollbackStructure(String deployBasePath, String resourceId, String componentName, String versionName) throws IOException, XMLStreamException {
        String rollbackManifestPath = DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, resourceId, componentName, versionName, ROLLBACK_MANIFEST_XML, true);
        return RollbackManifest.from(rollbackManifestPath);
    }

    public static boolean checkVersionDeployed(String deployBasePath, String resourceId, String componentName, String versionName) {
        String packageManifestFilePath = DeploymentResultHelper.getDeployMetaFilePath(deployBasePath, resourceId, componentName, versionName, PACKAGE_MANIFEST_XML, false);
        File packageManifestFile = new File(packageManifestFilePath);
        return packageManifestFile.exists();
    }

    private static String getDeployMetaFilePath(String deployBasePath, String resourceId, String componentName, String versionName, String fileName, boolean checkExist) {
        File file;
        String metaFilePath = deployBasePath + File.separator + DEPLOY_DIRECTORY + File.separator + resourceId + File.separator + componentName + File.separator + versionName + File.separator + fileName;
        if (!(!checkExist || (file = new File(metaFilePath)).exists() && file.isFile())) {
            throw new IllegalArgumentException(metaFilePath + " not found, please make sure the version has been successfully deployed");
        }
        return metaFilePath;
    }
}

