/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.xml.utils;

import com.ibm.urbancode.zos.deploy.xml.utils.Container;
import com.ibm.urbancode.zos.deploy.xml.utils.ContainerMap;
import com.ibm.urbancode.zos.deploy.xml.utils.ContainerType;
import com.ibm.urbancode.zos.deploy.xml.utils.CopyType;
import com.ibm.urbancode.zos.deploy.xml.utils.ElementsSorter;
import com.ibm.urbancode.zos.deploy.xml.utils.Input;
import com.ibm.urbancode.zos.deploy.xml.utils.Inputs;
import com.ibm.urbancode.zos.deploy.xml.utils.OrderBy;
import com.ibm.urbancode.zos.deploy.xml.utils.Resource;
import com.ibm.urbancode.zos.deploy.xml.utils.TargetDatasetUpdater;
import com.ibm.urbancode.zos.deploy.xml.utils.XmlHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class PackageManifest {
    private static final String V_2_0 = "v2_0";
    private final List<Container> containers = new ArrayList<Container>();
    private static final Predicate<Container> IS_DELETED = Container::isDeleted;
    private static final Predicate<Container> IS_NOT_DELETED = IS_DELETED.negate();
    private Container container = null;
    private String containerDeployType = null;
    private Resource resource = null;
    private boolean isDeleted = false;
    private boolean hasDataset;
    private boolean hasHFSFile;
    private boolean hasGenericArtifact;
    private String manifestVersion;

    public static PackageManifest from(String manifestFilePath, String mvsContainerMappingsFilePath) throws XMLStreamException, IOException {
        PackageManifest manifest = PackageManifest.from(manifestFilePath);
        ContainerMap containerMap = ContainerMap.from(mvsContainerMappingsFilePath);
        TargetDatasetUpdater.update(manifest, containerMap);
        return manifest;
    }

    public static PackageManifest from(String manifestFilePath) throws XMLStreamException, IOException {
        PackageManifest packageManifest = new PackageManifest();
        try (InputStream inputStream = Files.newInputStream(Paths.get(manifestFilePath, new String[0]), new OpenOption[0]);){
            packageManifest.parse(inputStream);
        }
        return packageManifest;
    }

    public PackageManifest sort(OrderBy orderBy) {
        new ElementsSorter<Container>(this.containers, orderBy).sort();
        for (Container container : this.containers) {
            container.sortResources(orderBy);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputStream inputStream) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newFactory();
        try (XMLStreamReader xmlStreamReader = null;){
            xmlStreamReader = inputFactory.createXMLStreamReader(inputStream, XmlHelper.getFileEncoding());
            while (xmlStreamReader.hasNext()) {
                int next = xmlStreamReader.next();
                if (next == 1) {
                    this.processStartElement(xmlStreamReader);
                    continue;
                }
                if (next != 2) continue;
                this.processEndElement(xmlStreamReader);
            }
        }
    }

    private void processStartElement(XMLStreamReader xmlStreamReader) {
        String tagName = xmlStreamReader.getLocalName().trim();
        if (tagName.equalsIgnoreCase("manifest")) {
            this.manifestVersion = XmlHelper.getAttributeValue(xmlStreamReader, "version");
        } else if (tagName.equalsIgnoreCase("deleted")) {
            this.isDeleted = true;
        } else if (tagName.equalsIgnoreCase("container")) {
            this.processContainerTag(xmlStreamReader);
        } else if (tagName.equalsIgnoreCase("resource") && this.container != null) {
            this.processResourceTag(xmlStreamReader);
        } else if (tagName.equalsIgnoreCase("property")) {
            this.processPropertyTag(xmlStreamReader);
        } else if (tagName.equalsIgnoreCase("inputs")) {
            this.processInputsTag(xmlStreamReader);
        } else if (tagName.equalsIgnoreCase("input")) {
            this.processInputTag(xmlStreamReader);
        }
    }

    private void processContainerTag(XMLStreamReader xmlStreamReader) {
        String containerName = XmlHelper.getAttributeValue(xmlStreamReader, "name");
        this.containerDeployType = XmlHelper.getAttributeValue(xmlStreamReader, "deployType");
        ContainerType containerType = XmlHelper.getContainerType(xmlStreamReader, containerName);
        this.setContainerTypeFlag(containerType);
        this.container = new Container(containerName, containerType);
        this.container.setDeployType(this.containerDeployType);
        String copyType = XmlHelper.getAttributeValue(xmlStreamReader, "copyType");
        if (!this.isNullOrEmpty(copyType)) {
            this.container.setCopyType(CopyType.valueOf(copyType));
        }
        if (this.isDeleted) {
            this.container.setDeleted();
        }
    }

    private void setContainerTypeFlag(ContainerType containerType) {
        if (containerType == ContainerType.PDS || containerType == ContainerType.SEQUENTIAL) {
            this.hasDataset = true;
        } else if (containerType == ContainerType.DIRECTORY) {
            this.hasHFSFile = true;
        } else if (containerType == ContainerType.GENERIC) {
            this.hasGenericArtifact = true;
        }
    }

    private void processResourceTag(XMLStreamReader xmlStreamReader) {
        String resourceName = XmlHelper.getAttributeValue(xmlStreamReader, "name");
        String resourceType = XmlHelper.getAttributeValue(xmlStreamReader, "type");
        String resourceDeployType = XmlHelper.getAttributeValue(xmlStreamReader, "deployType");
        String lastModifiedTimestamp = XmlHelper.getAttributeValue(xmlStreamReader, "lastModifiedTimestamp");
        this.resource = new Resource(resourceName);
        this.resource.setType(resourceType);
        this.resource.setDeployType(this.isNullOrEmpty(resourceDeployType) ? this.containerDeployType : resourceDeployType);
        this.resource.setLastModifiedTimestamp(lastModifiedTimestamp);
    }

    private boolean isNullOrEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    private void processPropertyTag(XMLStreamReader xmlStreamReader) {
        String propertyName = XmlHelper.getAttributeValue(xmlStreamReader, "name");
        String propertyValue = XmlHelper.getAttributeValue(xmlStreamReader, "value");
        if (this.resource != null) {
            this.resource.addCustomerProperty(propertyName, propertyValue);
        } else if (this.container != null) {
            this.container.addCustomerProperty(propertyName, propertyValue);
        }
    }

    private void processInputsTag(XMLStreamReader xmlStreamReader) {
        String inputsUrl = XmlHelper.getAttributeValue(xmlStreamReader, "url");
        if (this.resource != null) {
            this.resource.setInputs(new Inputs(inputsUrl));
        } else if (this.container != null && this.container.isSequential()) {
            this.container.setInputs(new Inputs(inputsUrl));
        }
    }

    private void processInputTag(XMLStreamReader xmlStreamReader) {
        Input input = new Input(XmlHelper.getAttributeValue(xmlStreamReader, "name"));
        input.setVersion(XmlHelper.getAttributeValue(xmlStreamReader, "version"));
        input.setUrl(XmlHelper.getAttributeValue(xmlStreamReader, "url"));
        input.setCompileType(XmlHelper.getAttributeValue(xmlStreamReader, "compileType"));
        if (this.resource != null) {
            this.resource.getInputs().addInput(input);
        } else if (this.container != null && this.container.isSequential()) {
            this.container.getInputs().addInput(input);
        }
    }

    private void processEndElement(XMLStreamReader xmlStreamReader) {
        String tagName = xmlStreamReader.getLocalName().trim();
        if (tagName.equalsIgnoreCase("deleted")) {
            this.isDeleted = false;
        } else if (tagName.equalsIgnoreCase("container")) {
            this.containers.add(this.container);
            this.container = null;
            this.containerDeployType = null;
        } else if (tagName.equalsIgnoreCase("resource")) {
            this.container.addResource(this.resource);
            this.resource = null;
        }
    }

    public List<Container> getContainers() {
        return Collections.unmodifiableList(this.containers);
    }

    List<Container> getAddedContainers() {
        return this.containers.stream().filter(IS_NOT_DELETED).collect(Collectors.toList());
    }

    List<Container> getDeletedContainers() {
        return this.containers.stream().filter(IS_DELETED).collect(Collectors.toList());
    }

    public boolean hasDataset() {
        return this.hasDataset;
    }

    public boolean hasHFSFile() {
        return this.hasHFSFile;
    }

    public boolean hasGenericArtifact() {
        return this.hasGenericArtifact;
    }

    public boolean hasOnlyGenericArtifacts() {
        return this.hasGenericArtifact() && !this.hasDataset() && !this.hasHFSFile();
    }

    public boolean isNewPackageFormat() {
        return this.manifestVersion != null && this.manifestVersion.equals(V_2_0);
    }
}

