/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.client;

import com.urbancode.commons.fileutils.filelister.FileListerBuilder;
import com.urbancode.commons.util.IO;
import com.urbancode.vfs.common.ClientPathEntry;
import com.urbancode.vfs.common.ClientPathEntryBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;

class AddVersionFilesCommandHelper {
    String component;
    String version;
    final String prefix;
    final boolean verbose;
    private final String url;
    private final File base;
    private final HttpClient client;
    private final ClientPathEntryBuilder pathEntryBuilder;
    private final Factory factory;

    private static String sanitizePrefix(String prefix) {
        if (!StringUtils.isEmpty(prefix)) {
            prefix = prefix.trim();
            while (prefix.endsWith("/")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            while (prefix.startsWith("/")) {
                prefix = prefix.substring(1);
            }
            while (prefix.startsWith("./") || prefix.startsWith(".\\")) {
                prefix = prefix.substring(2);
            }
            if (".".equals(prefix)) {
                prefix = "";
            }
        } else {
            prefix = "";
        }
        return prefix;
    }

    private static FileListerBuilder.Permissions builderPermissions(boolean saveExecute) {
        if (saveExecute) {
            return FileListerBuilder.Permissions.FILE_EXECUTE_ONLY;
        }
        return FileListerBuilder.Permissions.NONE;
    }

    AddVersionFilesCommandHelper(String component, String version, String prefix, String url, File base, String[] includes, String[] excludes, Charset charset, String[] extensions, HttpClient client, boolean saveExecuteBits, boolean verbose) {
        this(component, version, AddVersionFilesCommandHelper.sanitizePrefix(prefix), url.replaceAll("/+$", "") + "/cli-internal/version/addVersionFilesFull", base, new ClientPathEntryBuilder().baseFile(base).includes(includes).excludes(excludes).pathPrefix(AddVersionFilesCommandHelper.sanitizePrefix(prefix)).directories(FileListerBuilder.Directories.INCLUDE_ALL).permissions(AddVersionFilesCommandHelper.builderPermissions(saveExecuteBits)).symlinks(FileListerBuilder.Symlinks.EXCLUDE).hashAlgorithms("SHA-256").charset(charset).extensions(extensions), client, new Factory(), verbose);
    }

    AddVersionFilesCommandHelper(String component, String version, String prefix, String fullUrl, File base, ClientPathEntryBuilder pathEntryBuilder, HttpClient client, Factory fileFactory, boolean verbose) {
        this.component = component;
        this.version = version;
        this.url = fullUrl;
        this.prefix = prefix;
        this.verbose = verbose;
        this.base = base;
        this.client = client;
        this.pathEntryBuilder = pathEntryBuilder;
        this.factory = fileFactory;
    }

    File getFile(String path) {
        return this.factory.newFile(this.base, this.stripPrefix(path));
    }

    void post(HttpEntity entity) throws Exception {
        HttpPost post = this.factory.newPost(this.url);
        post.setEntity(entity);
        this.execute(post);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(HttpRequestBase method) throws Exception {
        try {
            HttpResponse response = this.client.execute(method);
            int code = response.getStatusLine().getStatusCode();
            if (code < 200 || code >= 300) {
                String message = this.readResponse(response);
                throw new Exception("Request error: " + code + ": " + message);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    private String readResponse(HttpResponse response) throws IOException {
        String result = null;
        if (response.getEntity() != null) {
            try (InputStream in = response.getEntity().getContent();){
                if (in != null) {
                    result = IO.readText(in, IO.utf8());
                }
            }
        }
        return result;
    }

    private String stripPrefix(String path) {
        return path.substring(this.prefix.length());
    }

    public ClientPathEntry[] getEntries() throws NoSuchAlgorithmException, IOException {
        return this.pathEntryBuilder.buildEntries();
    }

    static class Factory {
        Factory() {
        }

        File newFile(File parent, String path) {
            return new File(parent, path);
        }

        HttpPost newPost(String url) {
            return new HttpPost(url);
        }
    }
}

