/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.ispf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.commons.lang3.StringUtils;

public final class IspfPermissionsChecker {
    private static final String CONF_DIRECTORY = "conf";
    private static final String TOOLKIT_DIRECTORY = "toolkit";
    private static final String ISPZXENV_FILE = "ISPZXENV";
    private static final String WORK_AREA_DIRECTORY = "WORKAREA";
    private static final String DOT_LAST_FILE_EXTENSION = ".last";
    private static final String USER_NAME = System.getProperty("user.name");
    private static final String EQUALS_OPERATOR = "=";
    private static final String STRIP_CHARS = " '\"";
    private static final String CGI_ISPWORK_REGEX = "CGI_ISPWORK(\\s)*(=).+";
    private static final String AGENT_HOME = "AGENT_HOME";

    private IspfPermissionsChecker() {
    }

    public static void checkDirectoryFilePermissions() {
        String ispfDirPath = null;
        File ispzxenvFile = new File(System.getenv(AGENT_HOME).trim() + File.separator + CONF_DIRECTORY + File.separator + TOOLKIT_DIRECTORY + File.separator + ISPZXENV_FILE);
        if (ispzxenvFile.isFile()) {
            ispfDirPath = IspfPermissionsChecker.determineIspfDir(ispzxenvFile);
        } else {
            System.out.println("WARNING: " + ispzxenvFile + " does not exist for ISPF Gateway");
        }
        if (ispfDirPath != null) {
            IspfPermissionsChecker.checkPermissions(ispfDirPath);
        } else {
            System.out.println("WARNING: Couldn't able to determine ISPF path from file " + ispzxenvFile + " for permissions check");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String determineIspfDir(File ispzxenvFile) {
        try (BufferedReader reader = new BufferedReader(new FileReader(ispzxenvFile));){
            String line;
            do {
                if ((line = reader.readLine()) == null) return null;
            } while (!(line = line.trim()).matches(CGI_ISPWORK_REGEX));
            String cgiIspWorkValue = line.substring(line.indexOf(EQUALS_OPERATOR) + 1);
            String string = StringUtils.strip((String)cgiIspWorkValue, (String)STRIP_CHARS);
            return string;
        }
        catch (Exception e) {
            System.out.println("WARNING: Exception while reading file " + ispzxenvFile);
        }
        return null;
    }

    private static void checkPermissions(String ispfDirPath) {
        IspfPermissionsChecker.checkIspfDirectoryPermissions(ispfDirPath);
        IspfPermissionsChecker.checkIspfWorkDirectoryPermissions(ispfDirPath);
        IspfPermissionsChecker.checkLastFilePermissions(ispfDirPath);
    }

    private static void checkIspfDirectoryPermissions(String ispfDirPath) {
        File ispfDir = new File(ispfDirPath);
        if (ispfDir.isDirectory() && !ispfDir.canWrite()) {
            System.out.println("WARNING : User '" + USER_NAME + "' do not have write permission to directory " + ispfDir);
        }
    }

    private static void checkIspfWorkDirectoryPermissions(String ispfDirPath) {
        File ispfWorkAreaDir = new File(ispfDirPath + File.separator + WORK_AREA_DIRECTORY);
        if (ispfWorkAreaDir.isDirectory() && !ispfWorkAreaDir.canWrite()) {
            System.out.println("WARNING : User '" + USER_NAME + "' do not have write permission to directory " + ispfWorkAreaDir);
        }
    }

    private static void checkLastFilePermissions(String ispfDirPath) {
        File ispfLastFile = new File(ispfDirPath + File.separator + WORK_AREA_DIRECTORY + File.separator + USER_NAME + DOT_LAST_FILE_EXTENSION);
        if (ispfLastFile.isFile() && !ispfLastFile.canWrite()) {
            System.out.println("WARNING: User '" + USER_NAME + "' do not have write permission to file " + ispfLastFile);
        }
    }
}

