/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.dataset.alloc;

import com.ibm.urbancode.zos.dataset.alloc.AllocCommandBuilder;
import com.ibm.urbancode.zos.dataset.alloc.DatasetAllocator;

public class AllocLikeCommandBuilder
implements AllocCommandBuilder {
    private String allocCommand = "";
    private final String datasetName;

    public AllocLikeCommandBuilder(String datasetName) {
        this.datasetName = datasetName;
    }

    public AllocLikeCommandBuilder withLikeDataset(String likeDatasetName) {
        this.allocCommand = this.allocCommand + " like(" + likeDatasetName + ")";
        return this;
    }

    public AllocLikeCommandBuilder withVolumeSerial(String volumeSerial) {
        this.allocCommand = this.allocCommand + (volumeSerial.isEmpty() ? "" : " vol(" + volumeSerial + ")");
        return this;
    }

    public AllocLikeCommandBuilder withSpace(String primaryQuantity, String secondaryQuantity) {
        this.allocCommand = this.allocCommand + " space(" + primaryQuantity + "," + secondaryQuantity + ")";
        return this;
    }

    public AllocLikeCommandBuilder withSpaceUnit(String spaceUnit) {
        this.allocCommand = this.allocCommand + " " + spaceUnit;
        return this;
    }

    public AllocLikeCommandBuilder withBlockSize(String blockSize) {
        this.allocCommand = this.allocCommand + (blockSize.isEmpty() ? "" : " blksize(" + blockSize + ")");
        return this;
    }

    public AllocLikeCommandBuilder withDirectoryBlocks(String directoryBlocks) {
        this.allocCommand = this.allocCommand + " dir(" + directoryBlocks + ")";
        return this;
    }

    @Override
    public DatasetAllocator build() {
        return new DatasetAllocator(this);
    }

    @Override
    public String getAllocCommand() {
        return this.allocCommand;
    }

    @Override
    public String getDatasetName() {
        return this.datasetName;
    }
}

