/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.jcl.wait;

import com.urbancode.air.plugin.command.jcl.common.jes.JESJob;
import com.urbancode.air.plugin.command.jcl.common.jes.JobUtil;
import com.urbancode.air.plugin.command.jcl.wait.WaitForJobInputs;
import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.air.plugin.exceptions.MissingInputException;
import java.util.Properties;

public class WaitForJob {
    private final Properties inputProperties;
    private final Properties outputProperties;

    public WaitForJob(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        try {
            WaitForJobInputs pluginInputs = WaitForJobInputs.getValidatedInputs(this.inputProperties);
            JobUtil jobUtil = JobUtil.from(pluginInputs.getJmonInputs(), true);
            if (jobUtil.isPassTicketAuthentication()) {
                jobUtil.setPasswordUsingPassTicket();
            }
            boolean success = jobUtil.waitForJob(pluginInputs.getJobId());
            jobUtil.printLog(pluginInputs.getJobId());
            JESJob jesJob = jobUtil.getJob(pluginInputs.getJobId(), true);
            this.setOutputProperties(pluginInputs.getJobId(), jesJob);
            jobUtil.disconnect();
            if (success) {
                return 0;
            }
        }
        catch (InvalidInputException | MissingInputException runtimeException) {
            System.out.println(" [Error] " + runtimeException.getMessage());
        }
        catch (Exception e) {
            System.out.println("Error Running Job: " + e.getMessage());
            e.printStackTrace();
        }
        return 1;
    }

    private void setOutputProperties(String jobId, JESJob jesJob) {
        this.outputProperties.setProperty("JobId", jobId);
        this.outputProperties.setProperty("JobReturnCode", jesJob.getReturnCode() == null ? "" : jesJob.getReturnCode());
        this.outputProperties.setProperty("JobReturnInfo", jesJob.getReturnInfo() == null ? "" : jesJob.getReturnInfo());
        this.outputProperties.setProperty("JobReturnStatus", jesJob.getReturnStatus() == null ? "" : jesJob.getReturnStatus());
    }
}

