/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit.manifest;

import com.ibm.urbancode.zos.common.util.Console;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class ProcessExecutor {
    private static final String ENCODING_IBM_1047 = "IBM-1047";

    public static void extractUsingPaxCommand(String workDir, String zipFileName) throws IOException, InterruptedException {
        Console.printActionTitle("Extracting Files from " + zipFileName + " :");
        File zipFile = new File(workDir + File.separator + zipFileName);
        String[] paxCommandArgs = new String[]{"pax", "-r", "-vf", zipFile.getCanonicalPath()};
        File directory = new File(workDir);
        ProcessBuilder processBuilder = new ProcessBuilder(paxCommandArgs).directory(directory);
        int exitCode = ProcessExecutor.runProcess(processBuilder);
        if (exitCode > 0) {
            throw new RuntimeException(" [Error] Extract failed for " + zipFile.getCanonicalPath() + " with exit code " + exitCode);
        }
    }

    public static void executeScript(String workDir, String scriptFileName) throws Exception {
        File directory = new File(workDir);
        File scriptFile = new File(workDir + File.separator + scriptFileName);
        ProcessBuilder processBuilder = ProcessExecutor.getProcessBuilder(directory, scriptFile);
        int exitCode = ProcessExecutor.runProcess(processBuilder);
        if (exitCode > 0) {
            throw new RuntimeException(" [Error] Script " + scriptFile.getCanonicalPath() + " failed with exit code " + exitCode);
        }
    }

    private static ProcessBuilder getProcessBuilder(File directory, File scriptFile) throws IOException {
        if (!scriptFile.canExecute()) {
            ProcessExecutor.setExecutablePermission(scriptFile);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(scriptFile.getCanonicalPath());
        processBuilder.directory(directory);
        return processBuilder;
    }

    private static void setExecutablePermission(File scriptFile) throws IOException {
        if (!scriptFile.setExecutable(true, true)) {
            throw new RuntimeException(" [Error] Failed to set execute permissions for file " + scriptFile.getCanonicalPath());
        }
    }

    private static int runProcess(ProcessBuilder processBuilder) throws IOException, InterruptedException {
        Process process = processBuilder.start();
        ProcessExecutor.printProcessStreams(process);
        return process.waitFor();
    }

    private static void printProcessStreams(Process process) throws IOException {
        try (BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream(), ENCODING_IBM_1047));){
            ProcessExecutor.printStream(stdInput);
        }
        var2_2 = null;
        try (BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream(), ENCODING_IBM_1047));){
            ProcessExecutor.printStream(stdError);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    private static void printStream(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            Console.printProcessOutput(line);
        }
    }
}

