/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.dataset.util;

import com.ibm.jzos.CatalogSearch;
import com.ibm.jzos.CatalogSearchField;
import com.ibm.jzos.DSCB;
import com.ibm.jzos.Format1DSCB;
import com.ibm.jzos.Format8DSCB;
import com.ibm.jzos.PdsDirectory;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;
import com.ibm.urbancode.zos.common.util.Console;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class DatasetHelper {
    public static final String SPACE_UNIT_BLOCKS = "BLKS";
    public static final String RECORD_FORMAT_U = "U";
    private static final String SINGLE_QUOTE = "'";
    private static final String REGULAR_EXPRESSION_FOR_GDG_DATASET = ".+\\([+-]?\\d+\\)";

    public static Map<String, String> searchNonVsamDataset(String pattern) {
        int max = -1;
        CatalogSearch catSearch = new CatalogSearch(pattern);
        catSearch.setEntryTypes("A");
        catSearch.addFieldName("ENTNAME");
        catSearch.addFieldName("VOLSER");
        catSearch.search();
        HashMap<String, String> result = new HashMap<String, String>();
        while (catSearch.hasNext()) {
            CatalogSearch.Entry entry = (CatalogSearch.Entry)catSearch.next();
            if (!entry.isDatasetEntry()) continue;
            CatalogSearchField datasetName = entry.getField("ENTNAME");
            CatalogSearchField volume = entry.getField("VOLSER");
            if (max >= 0 && (max <= 0 || result.size() > max)) break;
            result.put(datasetName.getFString().trim(), volume.getFString().trim());
        }
        return result;
    }

    public static List<String> getMembers(String datasetName, String volume, String memberPattern) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        String pattern = DatasetHelper.makeRegexPattern(memberPattern);
        DSCB[] dscb = ZFile.readDSCBChain((String)DatasetHelper.getSlashSlashQuotedDSN(datasetName), (String)volume);
        int fmtDSCB = 0;
        try {
            fmtDSCB = ((Format1DSCB)dscb[0]).getDS1DSORG();
        }
        catch (Exception e1) {
            try {
                fmtDSCB = ((Format8DSCB)dscb[0]).getDS1DSORG();
            }
            catch (Exception e2) {
                System.out.println("DSCB found was neither of Format1DSCB nor Format8DSCB");
                e2.printStackTrace();
                System.exit(1);
            }
        }
        if (fmtDSCB == 16384) {
            result.add(DatasetHelper.getSlashSlashQuotedDSN(datasetName));
        } else if (fmtDSCB == 512 && !DatasetHelper.isNullOrEmpty(memberPattern.trim())) {
            PdsDirectory pds = new PdsDirectory(DatasetHelper.getSlashSlashQuotedDSN(datasetName));
            for (PdsDirectory.MemberInfo member : pds) {
                String memberName = member.getName();
                if (!memberName.matches(pattern)) continue;
                result.add(DatasetHelper.getSlashSlashQuotedDSN(datasetName + "(" + memberName + ")"));
            }
            pds.close();
        }
        return result;
    }

    public static String getSlashSlashQuotedDSN(String datasetName) {
        return ZFile.getSlashSlashQuotedDSN((String)datasetName, (boolean)true);
    }

    public static String makeRegexPattern(String pattern) {
        pattern = pattern.replace("$", "\\$");
        pattern = pattern.replace("-", "\\-");
        pattern = pattern.replace("(", "\\(");
        pattern = pattern.replace(")", "\\)");
        pattern = pattern.replace(".", "\\.");
        pattern = pattern.replace("*", ".*");
        return pattern;
    }

    public static String getDatasetRecFM(String dsnName) {
        int INVALID_FILTER_KEY = 122;
        int CATALOG_ERROR = 100;
        int FB = 144;
        int VB = 80;
        int U = 192;
        int FBS = 136;
        int VBS = 72;
        String recFM = "";
        Integer intRecFM = 0;
        String filterKey = dsnName.toUpperCase();
        CatalogSearch catSearch = new CatalogSearch(filterKey, 64000);
        try {
            catSearch.addFieldName("ENTNAME");
            catSearch.addFieldName("VOLSER");
            catSearch.search();
            while (catSearch.hasNext()) {
                CatalogSearch.Entry entry = (CatalogSearch.Entry)catSearch.next();
                if (!entry.isDatasetEntry()) continue;
                CatalogSearchField field = entry.getField("ENTNAME");
                String dsn = field.getFString().trim();
                String qdsn = SINGLE_QUOTE + dsn + SINGLE_QUOTE;
                field = entry.getField("VOLSER");
                String volser = field.getFString().trim();
                if (volser == null || volser.length() == 0) continue;
                String resolvedName = volser;
                if (volser.indexOf(38) != -1) {
                    try {
                        resolvedName = ZUtil.substituteSystemSymbols((String)volser, (boolean)true);
                    }
                    catch (RcException rce) {
                        System.out.println("Could not resolve symbolic VOLSER '" + volser + "'.  Skipping...");
                        continue;
                    }
                }
                try {
                    DSCB[] dscb = ZFile.readDSCBChain((String)qdsn, (String)resolvedName);
                    try {
                        intRecFM = ((Format1DSCB)dscb[0]).getDS1RECFM();
                    }
                    catch (Exception e1) {
                        try {
                            intRecFM = ((Format8DSCB)dscb[0]).getDS1RECFM();
                        }
                        catch (Exception e2) {
                            System.out.println("DSCB found was neither of Format1DSCB nor Format8DSCB");
                            e2.printStackTrace();
                            System.exit(1);
                        }
                    }
                    switch (intRecFM) {
                        case 144: {
                            recFM = "F,B";
                            break;
                        }
                        case 80: {
                            recFM = "V,B";
                            break;
                        }
                        case 192: {
                            recFM = RECORD_FORMAT_U;
                            break;
                        }
                        case 136: {
                            recFM = "F,B,S";
                            break;
                        }
                        case 72: {
                            recFM = "V,B,S";
                        }
                    }
                }
                catch (RcException rce) {
                    String reason = "";
                    if (rce.getRc() == 4) {
                        reason = " Volume not mounted";
                    } else if (rce.getRc() == 8) {
                        reason = " Volume does not contain a format 1 DSCB for dataset";
                    }
                    System.out.println(qdsn + " on " + resolvedName + reason);
                }
            }
        }
        catch (RcException rce) {
            if (rce.getRc() == 4 && catSearch.getRc() == 122) {
                System.out.println("Invalid filter key provided: " + filterKey);
            }
            if (rce.getRc() == 4 && catSearch.getRc() == 100) {
                while (catSearch.hasNext()) {
                    CatalogSearch.Entry entry = (CatalogSearch.Entry)catSearch.next();
                    if (!entry.hasError()) continue;
                    System.out.println("Entry Exception: ENTRY_RC=" + entry.getRc() + ", ENTRY_Reason=" + entry.getReason());
                }
            }
            throw rce;
        }
        return recFM;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static void deleteDataset(String dataset) throws ZFileException {
        if (DatasetHelper.isNullOrEmpty(dataset)) {
            return;
        }
        String zFileDsn = ZFile.getSlashSlashQuotedDSN((String)dataset, (boolean)true);
        if (ZFile.dsExists((String)zFileDsn)) {
            ZFile.remove((String)zFileDsn);
        }
    }

    public static boolean areDatasetsExist(Collection<String> datasets) throws ZFileException {
        boolean allExists = true;
        for (String dataset : datasets) {
            if (DatasetHelper.isDatasetExist(dataset)) continue;
            Console.printProcessOutput("Dataset " + dataset + " does not exist.");
            allExists = false;
        }
        return allExists;
    }

    public static boolean isDatasetNotExist(String datasetName) throws ZFileException {
        return !DatasetHelper.isDatasetExist(datasetName);
    }

    public static boolean isDatasetExist(String datasetName) throws ZFileException {
        return ZFile.dsExists((String)ZFile.getSlashSlashQuotedDSN((String)datasetName, (boolean)true));
    }

    public static String determineFullyQualifiedDsn(String inputDsn) {
        String inputDataset = inputDsn.trim();
        if (inputDataset.isEmpty()) {
            return inputDataset;
        }
        if (inputDataset.startsWith(SINGLE_QUOTE)) {
            return inputDataset.replace(SINGLE_QUOTE, "");
        }
        return ZFile.getFullyQualifiedDSN((String)inputDataset);
    }

    public static boolean isGDGDatasetWithReference(String datasetName) {
        return Pattern.matches(REGULAR_EXPRESSION_FOR_GDG_DATASET, datasetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGDGNameAssignedToDD(String ddName) throws ZFileException {
        String slashSlashDDName = DatasetHelper.getSlashSlashDDName(ddName);
        try (ZFile zFile = null;){
            zFile = new ZFile(slashSlashDDName, "rb");
            String string = zFile.getActualFilename();
            return string;
        }
    }

    private static String getSlashSlashDDName(String ddName) {
        return "//DD:" + ddName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGDGNameFromDataset(String datasetName) throws ZFileException {
        String actualName;
        String ddName = ZFile.allocDummyDDName();
        String allocCommand = "alloc fi(" + ddName + ") da(" + datasetName + ") reuse shr msg(wtp)";
        ZFile.bpxwdyn((String)allocCommand);
        try {
            actualName = DatasetHelper.getGDGNameAssignedToDD(ddName);
        }
        finally {
            ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
        }
        return actualName;
    }
}

