/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.jcl.common.jes;

import com.ibm.urbancode.zos.jes.passticket.PassTicketGenerator;
import com.urbancode.air.plugin.command.jcl.common.JmonInputs;
import com.urbancode.air.plugin.command.jcl.common.jes.JESJob;
import com.urbancode.air.plugin.command.jcl.common.jes.JESJobDataset;
import com.urbancode.air.plugin.command.jcl.common.jes.JMConnection;
import com.urbancode.air.plugin.command.jcl.common.jes.JMException;
import com.urbancode.air.plugin.command.jcl.common.jes.Logger;
import com.urbancode.air.plugin.command.jcl.common.jes.SystemMessageException;
import com.urbancode.air.plugin.exceptions.InvalidInputException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class JobUtil {
    private static final int JMON_MAX_LINES_LIMIT = 0x7FFFFFF8;
    private static final String DEFAULT_APPL_ID_FOR_JMON = "FEKAPPL";
    int cutoff = 1000;
    int timeout = 10;
    int interval = 2;
    int maxReturnCode = 4;
    String mvsFilename = null;
    String ussFilename = null;
    String jclString = null;
    String showOutput = "ALL";
    int returnCode = -1;
    JMConnection jm = null;
    JESJob latestJob = null;
    Logger logger = Logger.getDefault();
    private String userid;
    private String password;
    private boolean useRunId;
    private boolean isPassTicketAuthentication;
    private String libPath;
    private final String host;
    private final String port;

    private JobUtil(String host, String port) {
        this.host = host;
        this.port = port;
    }

    public static JobUtil from(JmonInputs jmonInputs, boolean isWaitForJob) {
        JobUtil jobUtil = new JobUtil(jmonInputs.getHostname(), jmonInputs.getPort());
        if (jmonInputs.isUseRunId()) {
            jobUtil.useRunId = true;
        } else if (jmonInputs.isUsePassTicket()) {
            jobUtil.userid = jmonInputs.getUserid();
            jobUtil.isPassTicketAuthentication = true;
            jobUtil.libPath = jmonInputs.getIrrracfLibraryPath();
        } else {
            jobUtil.userid = jmonInputs.getUserid();
            jobUtil.password = jmonInputs.getPassword();
        }
        if (isWaitForJob) {
            jobUtil.setTimeout(jmonInputs.getTimeout());
            jobUtil.setCutoff(jmonInputs.getMaxLines());
            jobUtil.setMaxReturnCode(jmonInputs.getMaxRC());
            jobUtil.setShowOutput(jmonInputs.getShowOutput());
        }
        return jobUtil;
    }

    public String[] getShowOutput() {
        String[] split = this.showOutput.split(",");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].trim().toUpperCase();
        }
        return split;
    }

    private void setShowOutput(String showOutput) {
        this.showOutput = showOutput;
    }

    public int getTimeout() {
        return this.timeout;
    }

    private void setTimeout(String timeout) {
        try {
            this.timeout = Integer.parseInt(timeout);
        }
        catch (NumberFormatException e) {
            throw new InvalidInputException("Timeout isn't a number.");
        }
        if (this.timeout < 0) {
            throw new InvalidInputException("Timeout cannot be a negative integer");
        }
    }

    public int getCutoff() {
        return this.cutoff;
    }

    private void setCutoff(String cutoff) {
        try {
            this.cutoff = Integer.parseInt(cutoff);
        }
        catch (NumberFormatException e) {
            throw new InvalidInputException("Max Lines isn't a number.");
        }
        if (this.cutoff < 0) {
            System.out.println(" [Info] Setting Max lines to JMON limit of 2147483640 lines.");
            this.cutoff = 0x7FFFFFF8;
        }
    }

    private void setMaxReturnCode(String maxReturnCode) {
        try {
            this.maxReturnCode = Integer.parseInt(maxReturnCode);
        }
        catch (NumberFormatException e) {
            throw new InvalidInputException("Max Return Code isn't a number.");
        }
        if (this.maxReturnCode < 0) {
            throw new InvalidInputException("Max Return Code cannot be a negative integer");
        }
    }

    public void setPasswordUsingPassTicket() throws Exception {
        this.password = PassTicketGenerator.generate((String)this.userid, (String)this.libPath, (String)DEFAULT_APPL_ID_FOR_JMON);
        if (this.jm == null) {
            this.jm = new JMConnection();
            this.jm.setUseRunId(this.useRunId);
        }
        this.jm.connect(this.host, this.port, this.userid, this.password);
    }

    private JMConnection getJm() throws SystemMessageException {
        if (this.jm == null) {
            this.jm = new JMConnection();
            this.jm.setUseRunId(this.useRunId);
            this.jm.connect(this.host, this.port, this.userid, this.password);
        }
        return this.jm;
    }

    public String submitJob(String jclString) throws Exception {
        String response = this.getJm().submit(jclString);
        String jobid = response.split(" ")[1];
        return jobid;
    }

    public JESJob getJob(String jobid, boolean useCache) throws JMException, SystemMessageException {
        if (useCache && this.latestJob != null) {
            return this.latestJob;
        }
        ArrayList<String> status = this.getJm().getStatus(jobid);
        if (status != null) {
            JESJob job = new JESJob(this.getJm());
            job.setJobID(jobid);
            job.setStatus(status);
            this.latestJob = job;
            return job;
        }
        throw new JMException("Failed to get status for job " + jobid);
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    private void printOutputSDS(JESJobDataset dataset) throws Exception {
        String line;
        InputStream outputSDS = this.getJm().getOutputSDS(dataset.getJobId(), dataset.getdsName(), this.cutoff);
        String datasetDescription = dataset.getdsName() + "  DD=" + dataset.getDDName() + "  LineCnt=" + dataset.getLineCount() + "  Date=" + dataset.getDate() + "  Time=" + dataset.getTime();
        BufferedReader reader = new BufferedReader(new InputStreamReader(outputSDS));
        this.logger.writeLog("========================================================================================================================");
        this.logger.writeLog(datasetDescription);
        this.logger.writeLog("========================================================================================================================");
        while ((line = reader.readLine()) != null) {
            this.logger.writeLog(line);
        }
    }

    public boolean isJclError(String jobid) throws Exception {
        if (jobid == null) {
            throw new JMException("jobid is null");
        }
        JESJob job = this.getJob(jobid, false);
        if (job != null) {
            if (job.getJobCompleted() && "JCLERROR".equals(job.getReturnInfo())) {
                JESJobDataset[] datasets;
                this.logger.writeLog("JCL Error.");
                for (JESJobDataset dataset : datasets = job.getDatasets()) {
                    this.logger.writeDebug("printing ds=" + dataset.getdsName());
                    this.printOutputSDS(dataset);
                }
                return true;
            }
            return false;
        }
        throw new Exception("Failed to get job status.");
    }

    public void printLog(String jobid) throws Exception {
        if (jobid == null) {
            throw new JMException("jobid is null");
        }
        JESJob job = this.getJob(jobid, true);
        if (job != null) {
            JESJobDataset[] datasets = job.getDatasets();
            String[] dsNameList = this.getShowOutput();
            boolean showAll = false;
            for (String dsName : dsNameList) {
                if (!"ALL".equals(dsName)) continue;
                showAll = true;
                break;
            }
            for (JESJobDataset dataset : datasets) {
                if (showAll) {
                    this.printOutputSDS(dataset);
                    continue;
                }
                for (String dsName : dsNameList) {
                    if (!dataset.getDDName().equalsIgnoreCase(dsName)) continue;
                    this.printOutputSDS(dataset);
                }
            }
        } else {
            throw new JMException("Failed to get job status.");
        }
    }

    public boolean waitForJob(String jobid) throws Exception {
        if (jobid == null) {
            throw new Exception("jobid is null");
        }
        for (int elapse = 0; elapse < this.timeout; elapse += this.interval) {
            JESJob job = this.getJob(jobid, false);
            if (job != null) {
                if (job.getJobCompleted()) {
                    int intCode;
                    this.logger.writeLog("Job Completed");
                    this.logger.writeLog("JobID=" + job.getJobID());
                    this.logger.writeLog("JobName=" + job.getJobName());
                    this.logger.writeLog("JobReturnCode=" + job.getReturnCode());
                    this.logger.writeLog("JobReturnInfo=" + job.getReturnInfo());
                    this.logger.writeLog("JobReturnStatus=" + job.getReturnStatus());
                    String returnCode = job.getReturnCode();
                    returnCode = returnCode.substring(1);
                    this.returnCode = intCode = Integer.parseInt(returnCode);
                    if (this.maxReturnCode >= 0) {
                        if ("COMPLETION".equals(job.getReturnStatus())) {
                            return intCode <= this.maxReturnCode;
                        }
                        this.logger.writeLog("Job does not end with completion code.");
                        return false;
                    }
                    if ("COMPLETION".equals(job.getReturnStatus())) {
                        this.logger.writeLog("Job completed successfully.");
                        return true;
                    }
                    this.logger.writeLog("Job does not end with completion status..");
                    return false;
                }
            } else {
                throw new JMException("Failed to get job status.");
            }
            this.logger.writeDebug("Waiting... " + this.interval);
            Thread.sleep(this.interval * 1000);
        }
        this.logger.writeLog("Timeout waiting for job to complete. Timeout=" + this.timeout + " seconds.");
        return false;
    }

    public void disconnect() {
        if (this.jm != null) {
            try {
                this.jm.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "JobUtil [host=" + this.host + ", port=" + this.port + ", userid=" + this.userid + ", password=" + this.password + ", cutoff=" + this.cutoff + ", timeout=" + this.timeout + ", interval=" + this.interval + ", maxReturnCode=" + this.maxReturnCode + ", mvsFilename=" + this.mvsFilename + ", ussFilename=" + this.ussFilename + ", jclString=" + this.jclString + ", showOutput=" + this.showOutput + ", returnCode=" + this.returnCode + "]";
    }

    public boolean isPassTicketAuthentication() {
        return this.isPassTicketAuthentication;
    }
}

