/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.tso.ispf;

import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayExecutor;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLInput;
import com.ibm.urbancode.zos.ispf.gateway.common.IspfGatewayXMLResponse;
import com.ibm.urbancode.zos.ispf.gateway.common.ServiceType;
import com.ibm.urbancode.zos.ispf.gateway.common.Session;
import com.urbancode.air.plugin.command.tso.ispf.TsoIspfInputs;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

class TsoIspfHelper {
    private static final String PATH = "PATH";
    private static final String CGI_CEATSO = "CGI_CEATSO";
    private static final String CGI_ISPPREF = "CGI_ISPPREF";
    private static final String LEGACY_ISPF_GATEWAY = "FALSE";
    private final Session session;
    private final String ispfGatewayPath;
    private final ServiceType serviceType;
    private final String ispProf;
    private final String dsnPrefix;
    private String outputText;
    private int returnCode;
    private String reasonCode;
    private String operationsLog;

    public TsoIspfHelper(TsoIspfInputs tsoIspfInputs) {
        this.ispfGatewayPath = tsoIspfInputs.getIspfGatewayPath();
        this.session = tsoIspfInputs.isReuseSessionSet() ? Session.REUSE : Session.NONE;
        this.serviceType = ServiceType.valueOf((String)tsoIspfInputs.getServiceType());
        this.ispProf = tsoIspfInputs.getIspProf();
        this.dsnPrefix = tsoIspfInputs.getTempDsnPrefix();
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String getServiceType() {
        return this.serviceType.toString();
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public String getOutputText() {
        return this.outputText;
    }

    public String getOperationsLog() {
        return this.operationsLog;
    }

    public void runCommand(String command) throws IOException, ParserConfigurationException, InterruptedException, SAXException {
        this.initializeOutputFields();
        Map<String, String> environmentVariables = this.getEnvironmentVariables();
        IspfGatewayExecutor ispfGatewayExecutor = new IspfGatewayExecutor(this.ispfGatewayPath, this.getIspfGatewayInput(command));
        ispfGatewayExecutor.setEnvironmentVars(environmentVariables);
        this.executeCommandUsingIspfGateway(ispfGatewayExecutor);
    }

    private Map<String, String> getEnvironmentVariables() {
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        environmentVariables.put(PATH, System.getenv(PATH) + File.pathSeparator + this.ispfGatewayPath);
        environmentVariables.put(CGI_CEATSO, LEGACY_ISPF_GATEWAY);
        environmentVariables.put(CGI_ISPPREF, this.dsnPrefix);
        return environmentVariables;
    }

    private void initializeOutputFields() {
        this.outputText = "";
        this.operationsLog = "";
        this.returnCode = 0;
        this.reasonCode = "";
    }

    private IspfGatewayXMLInput getIspfGatewayInput(String command) {
        IspfGatewayXMLInput ispfGatewayXMLInput = new IspfGatewayXMLInput(this.serviceType, command);
        ispfGatewayXMLInput.setSession(this.session);
        if (this.serviceType == ServiceType.ISPF) {
            ispfGatewayXMLInput.setIspProf(this.ispProf);
        }
        return ispfGatewayXMLInput;
    }

    private void executeCommandUsingIspfGateway(IspfGatewayExecutor ispfGatewayExecutor) throws IOException, ParserConfigurationException, InterruptedException, SAXException {
        IspfGatewayXMLResponse ispfGatewayXMLResponse = ispfGatewayExecutor.execute();
        this.operationsLog = ispfGatewayXMLResponse.getOperationsLog();
        if (this.serviceType == ServiceType.TSO) {
            this.processTsoCommandOutput(ispfGatewayXMLResponse);
        } else if (this.serviceType == ServiceType.ISPF) {
            this.processIspfCommandOutput(ispfGatewayXMLResponse);
        }
    }

    private void processIspfCommandOutput(IspfGatewayXMLResponse ispfGatewayXMLResponse) {
        this.outputText = ispfGatewayXMLResponse.getOutputText();
        this.returnCode = ispfGatewayXMLResponse.getReturnCode();
        if (this.returnCode > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String reasonCode : ispfGatewayXMLResponse.getReasonCodeList()) {
                stringBuilder.append(reasonCode).append(System.lineSeparator());
            }
            this.reasonCode = stringBuilder.toString();
        }
    }

    private void processTsoCommandOutput(IspfGatewayXMLResponse ispfGatewayXMLResponse) {
        this.outputText = ispfGatewayXMLResponse.getOutputText();
    }

    public boolean isServiceTypeIspf() {
        return this.serviceType == ServiceType.ISPF;
    }
}

