/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.versions.cleanup;

import com.urbancode.air.plugin.command.versions.cleanup.CommonUtil;
import com.urbancode.air.plugin.command.versions.cleanup.PluginInputs;
import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.air.plugin.exceptions.MissingInputException;
import com.urbancode.ud.client.EnvironmentClient;
import java.util.Properties;
import org.codehaus.jettison.json.JSONArray;

public class RemoveRedundantVersions {
    private final Properties inputProperties;

    public RemoveRedundantVersions(Properties inputProperties, Properties ignoredOutputProperties) {
        this.inputProperties = inputProperties;
    }

    public int execute() throws Exception {
        try {
            PluginInputs pluginInputs = PluginInputs.getValidatedInputs(this.inputProperties);
            CommonUtil.printComponentInfo(pluginInputs);
            JSONArray versions = pluginInputs.isDryRun() ? this.getRedundantVersions(pluginInputs) : this.getDeletedRedundantVersions(pluginInputs);
            if (versions.length() == 0) {
                System.out.println(" [Info] No versions to remove.");
                return 0;
            }
            int count = pluginInputs.isDryRun() ? CommonUtil.printVersionsName(versions) : CommonUtil.deleteVersionsDirectory(versions, pluginInputs.getComponentDeployPath());
            System.out.println("\n Total number of versions - " + count);
            return 0;
        }
        catch (InvalidInputException | MissingInputException e) {
            System.out.println(" [Error] " + e.getMessage());
            return 8;
        }
    }

    private JSONArray getDeletedRedundantVersions(PluginInputs pluginInputs) throws Exception {
        EnvironmentClient envClient = CommonUtil.getEnvironmentClient();
        return envClient.deleteRedundantVersions(pluginInputs.getEnvironmentName(), pluginInputs.getApplicationName(), pluginInputs.getComponentName(), true);
    }

    private JSONArray getRedundantVersions(PluginInputs pluginInputs) throws Exception {
        EnvironmentClient envClient = CommonUtil.getEnvironmentClient();
        return envClient.deleteRedundantVersions(pluginInputs.getEnvironmentName(), pluginInputs.getApplicationName(), pluginInputs.getComponentName(), false);
    }
}

