/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.mappings;

import com.ibm.team.enterprise.deployment.mappings.InvalidMappingException;
import com.ibm.team.enterprise.deployment.mappings.Mapper;
import com.ibm.team.enterprise.deployment.mappings.MappingHelper;
import java.util.LinkedHashMap;
import java.util.Map;

public class DatasetMapper
implements Mapper {
    private final Map<String, String> srcTargetMapWithRegEx = new LinkedHashMap<String, String>();
    private final Map<String, String> srcTargetMapWithoutRegEx = new LinkedHashMap<String, String>();
    private final String datasetMapping;

    private DatasetMapper(String datasetMapping) {
        this.datasetMapping = datasetMapping;
    }

    public static DatasetMapper from(String datasetMapping) {
        DatasetMapper datasetMapper = new DatasetMapper(datasetMapping);
        datasetMapper.loadMappingIntoMaps();
        return datasetMapper;
    }

    private void loadMappingIntoMaps() {
        String[] mappingPairs;
        for (String mappingPair : mappingPairs = this.datasetMapping.split("\n")) {
            if ((mappingPair = mappingPair.trim()).isEmpty()) continue;
            this.loadPairIntoMap(mappingPair);
        }
    }

    private void loadPairIntoMap(String mappingPair) {
        String[] onePair = mappingPair.split(",");
        if (onePair.length != 2) {
            throw new InvalidMappingException("Dataset Mapping is incorrect - " + mappingPair);
        }
        String source = onePair[0].trim();
        String target = onePair[1].trim();
        if (source.isEmpty()) {
            throw new InvalidMappingException("Missing source dataset in Dataset Mapping - " + mappingPair);
        }
        if (MappingHelper.containsWildcardCharacter(source)) {
            this.loadMappingIntoMapWithWildcard(source, target);
        } else {
            this.loadMappingIntoMapWithoutWildcard(source, target);
        }
    }

    private void loadMappingIntoMapWithoutWildcard(String source, String target) {
        if (this.srcTargetMapWithoutRegEx.containsKey(source)) {
            System.out.println(" [Warning] The mapping rule " + source + "," + target + " is ignored as it is already set by " + source + "," + this.srcTargetMapWithoutRegEx.get(source));
        } else {
            this.srcTargetMapWithoutRegEx.put(source, target);
        }
    }

    private void loadMappingIntoMapWithWildcard(String source, String target) {
        String sourceWithRegularExp = MappingHelper.convertWildcardsToRegularExp(source);
        if (this.srcTargetMapWithRegEx.containsKey(sourceWithRegularExp)) {
            System.out.println(" [Warning] The mapping rule " + source + "," + target + " is ignored as it is already set by " + source + "," + this.srcTargetMapWithRegEx.get(sourceWithRegularExp));
        } else {
            this.srcTargetMapWithRegEx.put(sourceWithRegularExp, target);
        }
    }

    @Override
    public Map<String, String> getSrcTargetMapWithRegEx() {
        return this.srcTargetMapWithRegEx;
    }

    @Override
    public Map<String, String> getSrcTargetMapWithoutRegEx() {
        return this.srcTargetMapWithoutRegEx;
    }
}

