/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit.manifest;

import com.ibm.jzos.ZFileException;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.xml.utils.deploy.Container;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.ibm.urbancode.zos.xml.utils.deploy.Resource;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;

public class PDSChecker {
    private static final String OPEN_PARENTHESIS = "(";
    private static final String CLOSED_PARENTHESIS = ")";
    private final String manifestFilePath;
    private final String containerMapperFilePath;

    public PDSChecker(String componentVersionWorkingDir) {
        this.manifestFilePath = componentVersionWorkingDir + File.separator + "packageManifest_deploy.xml";
        this.containerMapperFilePath = componentVersionWorkingDir + File.separator + "containerMapper.xml";
    }

    public List<String> getListOfExistingPdsMembers() throws IOException, XMLStreamException {
        PackageManifest manifest = PackageManifest.from((String)this.manifestFilePath, (String)this.containerMapperFilePath);
        return manifest.getContainers().stream().filter(container -> !container.isDeleted()).filter(Container::isPds).flatMap(pdsContainer -> this.getExistingPDSMembers((Container)pdsContainer).stream()).collect(Collectors.toList());
    }

    private List<String> getExistingPDSMembers(Container pdsContainer) {
        return pdsContainer.getResources().stream().map(member -> this.getTargetPdsWithEnclosedMember(pdsContainer, (Resource)member)).filter(this::isPDSMemberExist).collect(Collectors.toList());
    }

    private String getTargetPdsWithEnclosedMember(Container pdsContainer, Resource member) {
        return pdsContainer.getTargetContainerName() + OPEN_PARENTHESIS + member.getName() + CLOSED_PARENTHESIS;
    }

    private boolean isPDSMemberExist(String pdsMember) {
        try {
            return DatasetHelper.isDatasetExist(pdsMember);
        }
        catch (ZFileException e) {
            throw new RuntimeException(e);
        }
    }
}

