/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.common;

import com.ibm.urbancode.zos.xml.utils.common.XmlHelper;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ContainerMapperXml {
    private static final String DIRECTORY = "Directory";
    private static final String PDS = "PDS";
    private static final String MAP_ELEMENT = "map";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String SOURCE_CONTAINER = "sourceContainer";
    private static final String TARGET_CONTAINER = "targetContainer";
    private static final String MAPS_ELEMENT = "maps";
    private static final String INDENT = "    ";
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String XML_VERSION = "1.0";
    private XMLStreamWriter xmlStreamWriter = null;
    private final Map<String, String> map;
    private final String mapType;

    private ContainerMapperXml(Map<String, String> map, String mapType) {
        this.map = map;
        this.mapType = mapType;
    }

    public static String createForHfs(Map<String, String> map) throws XMLStreamException {
        ContainerMapperXml containerMapperXml = new ContainerMapperXml(map, DIRECTORY);
        return containerMapperXml.create();
    }

    public static String createForMvs(Map<String, String> map) throws XMLStreamException {
        ContainerMapperXml containerMapperXml = new ContainerMapperXml(map, PDS);
        return containerMapperXml.create();
    }

    private String create() throws XMLStreamException {
        StringWriter stringWriter = new StringWriter();
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        try {
            this.xmlStreamWriter = outputFactory.createXMLStreamWriter(stringWriter);
            this.writeXmlElements();
        }
        finally {
            if (this.xmlStreamWriter != null) {
                this.xmlStreamWriter.close();
            }
        }
        return stringWriter.toString();
    }

    private void writeXmlElements() throws XMLStreamException {
        this.xmlStreamWriter.writeStartDocument(XmlHelper.getFileEncoding(), XML_VERSION);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        this.xmlStreamWriter.writeStartElement(MAPS_ELEMENT);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            this.writeElement(entry);
        }
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeEndDocument();
    }

    private void writeElement(Map.Entry<String, String> entry) throws XMLStreamException {
        this.writeStartElement();
        this.writeElement(entry.getKey(), SOURCE_CONTAINER);
        this.writeElement(entry.getValue(), TARGET_CONTAINER);
        this.writeEndElement();
    }

    private void writeEndElement() throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(INDENT);
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeStartElement() throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(INDENT);
        this.xmlStreamWriter.writeStartElement(MAP_ELEMENT);
        this.xmlStreamWriter.writeAttribute(TYPE_ATTRIBUTE, this.mapType);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeElement(String name, String elementName) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters("        ");
        this.xmlStreamWriter.writeEmptyElement(elementName);
        this.xmlStreamWriter.writeAttribute(NAME_ATTRIBUTE, name);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }
}

