/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.common;

import com.ibm.team.enterprise.deployment.mappings.Mapper;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class MappingResolver {
    private MappingResolver() {
    }

    public static Map<String, String> resolve(Mapper mapper, Collection<String> packageContainers) {
        return MappingResolver.resolve(mapper.getSrcTargetMapWithoutRegEx(), mapper.getSrcTargetMapWithRegEx(), packageContainers);
    }

    static Map<String, String> resolve(Map<String, String> srcTargetMapWithoutRegEx, Map<String, String> srcTargetMapWithRegEx, Collection<String> packageContainers) {
        HashMap<String, String> resolvedMap = new HashMap<String, String>();
        StringBuilder unresolvedContainers = new StringBuilder();
        for (String packageContainer : packageContainers) {
            if (srcTargetMapWithoutRegEx.containsKey(packageContainer)) {
                resolvedMap.put(packageContainer, srcTargetMapWithoutRegEx.get(packageContainer));
                continue;
            }
            Optional<String> mappedTarget = MappingResolver.getTargetContainer(packageContainer, srcTargetMapWithRegEx);
            if (mappedTarget.isPresent()) {
                resolvedMap.put(packageContainer, mappedTarget.get());
                continue;
            }
            unresolvedContainers.append(System.lineSeparator()).append(packageContainer);
        }
        String unresolvedContainersString = unresolvedContainers.toString();
        if (unresolvedContainersString.isEmpty()) {
            return resolvedMap;
        }
        String context = unresolvedContainersString.contains(File.separator) ? "HFS directories" : "MVS datasets";
        throw new IllegalArgumentException("Missing mapping rules for below " + context + ": " + unresolvedContainers);
    }

    private static Optional<String> getTargetContainer(String sourceContainer, Map<String, String> srcTargetMapWithWildcard) {
        for (String sourceWithRegEx : srcTargetMapWithWildcard.keySet()) {
            if (!sourceContainer.matches(sourceWithRegEx)) continue;
            return Optional.of(srcTargetMapWithWildcard.get(sourceWithRegEx));
        }
        return Optional.empty();
    }
}

