/* REXX */
/*%STUB CALLCMD*/
/*********************************************************************/
/* Copyright:    Licensed Materials - Property of IBM and/or HCL     */
/*                                                                   */
/*        Copyright IBM Corporation. All rights reserved             */
/*        Copyright HCL Technologies limited. All rights reserved    */
/*                                                                   */
/*        US Government Users Restricted Rights -                    */
/*        Use, duplication or disclosure restricted by               */
/*        GSA ADP Schedule Contract with IBM Corp.                   */
/*                                                                   */
/*********************************************************************/

   Call syscalls('ON')

   parse arg Module '"'manifest'"' '"'restore'"',
                '"'traceOption'"' '"'prefix'"' '"'binloc'"',
                '"'sysoutValue'"' '"'tempUnit'"' '"'tempVolSerValue'"'.

   Parse var traceOption TraceOn '(' TraceMod ')'
   TraceCmd = ''
   If Substr(TraceOn,1,5) = 'TRACE' Then
   Do
     modname = 'BUZDEPZP'
     If TraceMod = 'ALL' |,
        TraceMod = modname Then
     Do
       Say "*** Tracing activated for "modname "on "Date('N') ||,
           " at "Time()" ***"
       Select
         When (TraceOn = 'TRACE?I') Then TraceCmd = 'Trace ?i'
         When (TraceOn = 'TRACEI')  Then TraceCmd = 'Trace i'
         When (TraceOn = 'TRACEA')  Then TraceCmd = 'Trace a'
         When (TraceOn = 'TRACER')  Then TraceCmd = 'Trace r'
         When (TraceOn = 'TRACEC')  Then TraceCmd = 'Trace c'
         When (TraceOn = 'TRACEE')  Then TraceCmd = 'Trace e'
         When (TraceOn = 'TRACEF')  Then TraceCmd = 'Trace f'
         When (TraceOn = 'TRACEL')  Then TraceCmd = 'Trace l'
         When (TraceOn = 'TRACEN')  Then TraceCmd = 'Trace n'
         When (TraceOn = 'TRACE')   Then TraceCmd = 'Trace r'
         Otherwise NOP
       End
     End
   End
   Interpret TraceCmd

   /* Set Sysout class and temp volser */
   sysoutClass = ''
   tempVolser  = ''
   If sysoutValue /= "" Then
   Do
     sysoutClass = 'SYSOUT('sysoutValue')'
   End
   If tempVolSerValue /= "" Then
   Do
     tempVolser  = 'VOLUME('tempVolSerValue')'
   End

   elapsed = Time('E')

   Say 'Manifest file : 'manifest'.'

   Say 'Unpacked location : 'binloc'.'

   Say 'Restore Mapping File : ' restore '.'

   Call initialize                 /* read input files and set up */
   Call setdsnsV301
   Call deploy                     /* do the receives             */
   elapsed = Time('E')
   Say 'Elapsed time for data set package or deploy operation :'elapsed ||,
    ' seconds'

Exit

Initialize :

   /* Get z/OS release */
   Address ISPEXEC 'VGET (ZOS390RL) SHARED'
   Parse var ZOS390RL 'z/OS' ZOSREL'.'ZOSVER'.'ZOSMOD
   ZOSREL = Strip(ZOSREL)
   ZOSVER = Strip(ZOSVER)
   ZOSMOD = Strip(ZOSMOD)

   SAY "ZOS RELEASE - "ZOSREL " VERSION - "ZOSVER

   manlist.0 = 0
   Address syscall "readfile (manifest) manlist."
   If retval < 0 Then
   Do
       Say "Problem reading manifest file : "manifest". " ||,
           "Errno : "errno" Reason : "right(errnojr,8,0)"."

      Call Exitproc(8)
   End

   maplist.0 = 0
   If restore <> '' Then
   Do
      Address syscall "readfile (restore) maplist."
      If retval < 0 Then
      Do
         Say "Problem reading mapping file : "restore". " ||,
              "Errno : "errno" Reason : "right(errnojr,8,0)"."

         Call Exitproc(8)
      End
   End
   Else
   Do
      Say "No restore mapping file found, manifest location will be used."      
   End

Return

setdsnsV301 :

   /* Create a mapping list package data set to deploy      */
   /* data set.                                             */

   k = 0
   RecvMap.0 = k
   isDeleted = 0
   Do i = 1 to manlist.0
     Select
       When (Pos('<deleted>',manlist.i) > 0) Then
         isDeleted = 1

       When (Pos('</deleted>',manlist.i) > 0) Then
         isDeleted = 0

       When (Pos('<container',manlist.i) > 0) Then
       Do
         Parse var manlist.i . ' name="' DataSet '"' .

        /* Ignore directory (i.e. HFS) containers. They are handled by Ant. */
         If Pos(' type="directory"',manlist.i) > 0 Then
           Do
           /* Say "Skipping directory container "DataSet */
           i = i + 1
           Do while (Pos('<resource',manlist.i) > 0)
             i = i + 1
           End
           i = i - 1
           iterate
         End


         /* Need to see if this is a sequential file */
         If Pos(' type="sequential"',manlist.i) > 0 Then
           Sequential = 1
         Else
           Sequential = 0

          /* If dataset was missing during deployment it will be true */
         isDatasetMissing = 0
         if (isDeleted & pos(' missing="true"',manlist.i) > 0) then
            isDatasetMissing = 1

         /* Loop through restore mapping file to see if */
         /* there is an entry for the data set. If so   */
         /* replace it in the list.                     */
         DeplDSN = Strip(DataSet)
         Do rest = 1 to maplist.0
            If Pos('<?xml',maplist.rest) > 0 Then
               iterate
            If Pos('<maps>',maplist.rest) > 0  |,
               Pos('</maps>',maplist.rest) > 0 Then
               iterate
            If Pos('<map type="PDS">',maplist.rest) > 0  |,
               Pos('<map type="sequential">',maplist.rest) > 0  |,
               Pos('</map>',maplist.rest) > 0 Then
               iterate
            If Pos('<sourceContainer',maplist.rest) > 0 Then
            Do
               Parse var maplist.rest . ' name="' OrigDSN '"' .
               rest = rest + 1

            End
            If Pos('<targetContainer',maplist.rest) > 0 Then
               Parse var maplist.rest . ' name="' ToDSN '"' .
            Else
            Do
               Say 'The data set for "Deploy to" '||,
               'was not specified for 'OrigDSN'.' 
               Call Exitproc(8)
            End
            OrigDSN = Strip(OrigDSN)
            ToDSN   = Strip(ToDSN)
            If DataSet = OrigDSN Then
            Do
               DeplDSN = ToDSN
               manlist.i = 'DataSet='ToDSN
               Leave
            End
         End

         i = i + 1
         j = 0
         FirstMem = 1
         memberlist.0 = 0
         memberindex = 0
        Do while Pos('<resource',manlist.i) > 0 |,
                 Pos('<property',manlist.i) > 0 |,
                 Pos('</resource',manlist.i) > 0
           if  Pos('<property',manlist.i) > 0 |,
               Pos('</resource',manlist.i) > 0 then
           do
             i = i + 1
             iterate
           end
           Parse var manlist.i . '<resource' . ' name="' member '"' .
          /* Need to change the XML format chars to real chars */
           member = chkmem3(member)
            If isDeleted Then
            Do
               /* If there is a member delete there may be more */
               /* than one. Do the LMINIT once, then process    */
               /* all the member deletes. Then the LMFREE after */
               If FirstMem = 1 Then
               Do
                  FirstMem = 0
                  Address ISPEXEC "LMINIT DATAID(DID) "         ||,
                                     " DATASET('"Strip(DeplDSN)"')" ||,
                                     " ENQ(SHRW)"
                  If (rc = 8) then
                  Do
                    Say 'Deploy to data set 'DeplDSN' does not exist.'||,
                    'Member 'member
                    FirstMem = 1
                    i = i + 1
                    Iterate
                  End
                  Else
                    If (rc > 0) then
                    Do
                      message = 'The LMINIT function failed for data'||,
                      'set 'DeplDSN'. Return code 'rc
                      Call ISPFerr (message' rc='rc)
                    End

                  Address ISPEXEC "LMOPEN DATAID(&DID) OPTION(OUTPUT)"
                  If (rc > 0) then
                  Do
                     message= 'The LMOPEN function failed for '||,
                     'data set 'DeplDSN' Return code:' rc
                     Call ISPFerr (message' rc='rc)
                  End
               End

               Say 'Deleting the member 'member' from 'DeplDSN'.'

               Address ISPEXEC "LMMDEL DATAID(&DID) MEMBER("member")"
               Select
                  When (rc = 0) Then
                     Nop
                  When (rc = 8) Then
                  Do
                     Say 'The deletion of the member 'member' failed ' ||,
                     'because member did not exist in the dataset' DeplDSN
                  End
                  Otherwise
                  Do
                    message = 'The deletion of the member 'member' failed.' ||,
                    'Return code : 'rc
                    Call ISPFerr (message' rc='rc)
                  End
               End
            End
            Else
            do
               memberindex = memberindex + 1
               /* change characters to wildcards for IEBCOPY           */
               member = chkmem2(member)
               memberlist.memberindex = member
               memberlist.0 = memberindex
            end
            i = i + 1
        End

         If FirstMem = 0 Then
         Do
            Address ISPEXEC "LMCLOSE DATAID(&DID)"
            If (rc <> 0) then
            Do
               message='The LMCLOSE function failed with Return Code : 'rc
               Call ISPFerr (message' rc='rc)
            End

            Address ISPEXEC "LMFREE DATAID(&DID)"
            If (rc <> 0) then
            Do
               message = 'The LMFREE function failed with Return Code:'rc
               Call ISPFerr (message' rc='rc)
            End
         End
         Call Proc_Action
         i = i - 1
       End
       Otherwise
         Nop
     End
   End
   RecvMap.0 = k

Return

Deploy :

   /* There should be a zip file to deploy based on the contents */
   /* of the manifest.                                           */
   If RecvMap.0 > 0 Then
   Do
      LongTime = TIME('L')
      Parse var longTime hh':'mm':'ss'.'uuuuuu
      DSNSuf  = 'T'||hh||mm||ss'.M'uuuuuu
      TempDSN = prefix'.RTCRECV.'DSNSuf
      x = msg('off')
      Address TSO "DELETE '"TempDSN"'"
      x = msg('on')

      /* One by one transfer xmit files from HFS to temp data set  */
      /* Receive into the target dataset based on the new manifest */
      Do i = 1 to RecvMap.0
         Parse var RecvMap.i 'RecvDSN='RecvDSN' DeployTo='DeplDSN ' Type='Type
         If Type = 'sequential' Then
           sequential = 1
         Else
           sequential = 0

         /* Now copy sequential from HFS to sequential data set  */
         x = msg('off')
         Address TSO "FREE F(HFSFILE)"
         Address TSO "FREE F(SEQFILE)"
         Address TSO "FREE F(SYSPRINT)"
         x = msg('on')

         /* Need to work out how much space to allocate  */
         /* the .bin file in the HFS will have a size in */
         /* bytes. Convert that to tracks based on the   */
         /* calculation that there are 56664 bytes/track */
         stdout.0 = 0
         stderr.0 = 0

         shellcmd="ls -REgoa '"binloc"/"RecvDSN".bin'"

         sh_rc = bpxwunix(shellcmd,,stdout.,stderr.)
         If stderr.0 > 0 Then
         Do
            Say '---STDERR---'
            Do e = 1 to stderr.0
               Say stderr.e
            End
         End
         If stdout.0 > 0 Then
         Do
           parse var stdout.1 stuff 21 size .
           dstype = "BASIC"
           select
             when (size <= 56664) Then
               Do
                 trk = 1
               End
             /* when size is lesser than 1.5GB, still alloc BASIC */
             when (size > 56664 & size <= 1500000000  ) Then
               Do
                 trk =  Format(size/56664,,0)
               End
             /* when size IS GREATER THAN 1.5GB alloc LARGE */
             otherwise
               Do
                 trk =  Format(size/56664,,0)
                 dstype = "LARGE"
               End
           End
         End

         Address TSO "ALLOC F(SYSPRINT) DUMMY"
         Address TSO "ALLOC F(SEQFILE) NEW" ||,
                 " TRACKS UNIT("tempUnit") "tempVolser" DSORG(PS)" ||,
                 " BLKSIZE(3120) LRECL(80) RECFM(F B)" ||,
                 " SPACE("trk" "trk") DSNTYPE("dstype")"
         Address TSO "ALLOC F(HFSFILE) PATH('"binloc"/"RecvDSN".bin')"
         Address TSO "OCOPY INDD(HFSFILE) OUTDD(SEQFILE) BINARY"

         Address TSO "FREE F(HFSFILE)"

         /* Now receive the file and replace what was there     */

         x = PROMPT("ON")

         If sequential Then
           Say 'Deploying sequential data set to 'DeplDSN'.'
         Else
           Say 'Deploying members to 'DeplDSN'.'
         
         /* Allocate a temporary throw away log so we don't */
         /* fill up LOG.MISC                                */

         Address TSO "ALLOC F(LOGFILE) NEW" ||,
              " CYLINDERS UNIT("tempUnit") "tempVolser" DSORG(PS)" ||,
              " BLKSIZE(3120) LRECL(255) RECFM(V B)" ||,
              " SPACE(1 1)"
       Address TSO "ALLOC F(SYSUT4) NEW" ||,
                 " CYLINDERS UNIT("tempUnit") "tempVolser" SPACE(5 10)"
       Address ISPEXEC "QBASELIB LOGFILE ID(LOGFILE)"

         XX=OUTTRAP('STEM.')
         If sequential Then
           Queue " DATASET('"DeplDSN"')" sysoutClass
         Else
           Queue " DATASET('"TempDSN"')" sysoutClass
         Address TSO "RECEIVE INFILE(SEQFILE) NONAMES LOGDS("LOGFILE")"
         if rc <> 0 Then
         Do
            Do xmit = 1 to stem.0
               Say stem.xmit
            End
            Address TSO "FREE F(LOGFILE)"
            Address TSO "FREE F(SEQFILE)"
            Address TSO "FREE F(SYSPRINT)"
            Address TSO "FREE F(SYSUT4)"
            Call ExitProc(8)
         End
         XX=OUTTRAP('OFF')
         Address TSO "FREE F(SYSPRINT)"
         Address TSO "FREE F(LOGFILE)"

         x = msg('off')
         Address TSO "FREE F(SYSIN)"
         Address TSO "FREE F(SYSPRINT)"
         Address TSO "FREE F(SYSUT4)"
         Address TSO "FREE F(OUTDD)"
         Address TSO "FREE F(INDD)"
         x = msg('on')

         /* Now copy from tempdsn to deploy to data set */

         If sequential Then
           Nop
         Else
         Do
           Address ISPEXEC "DSINFO DATASET('"DeplDSN"')"
           If (rc > 0) then
           Do
             If (rc = 8) Then  /* Data set does not exist */
             Do
               Say ZERRLM'. Allocating data set like 'RecvDSN'.'
               Address ISPEXEC "DSINFO DATASET('"TempDSN"')"
               If (rc > 0) then
               Do
                 message = 'DSINFO failed on ' TempDSN 'Return Code :'rc
                 Call ISPFerr (message ||' rc='||rc)
               End

               blksize = Strip(zdsblk)
               Address TSO "ALLOC DA('"Strip(DeplDSN)"') " ||,
                             "LIKE('"Strip(TempDSN)"') BLKSIZE("blksize")"
               If (rc > 0) then
               Do
                  message = 'Problem allocating data set 'DeplDSN ||,
                           '. Return Code='rc
                  Call ISPFerr (message ||' rc='||rc)
               End
             End
             Else
             Do
               message = 'DSINFO failed on ' DeplDSN' Return Code :' rc
               Call ISPFerr (message || ' rc='||rc)
             End
           End

            Address ISPEXEC "DSINFO DATASET('"DeplDSN"')"
          
            x = msg('off')
            Address TSO "FREE F(TEMPPDS)"
            x = msg('on')

            Address TSO "ALLOC F(SYSPRINT) NEW REUSE" sysoutClass

            Address TSO "ALLOC F(INDD)  DA('"TempDSN"') SHR REUSE"
            If (rc > 0) then
            Do
              message = 'Problem allocating data set 'TempDSN ||,
                  ' Return Code :'rc'.'  
              Call ISPFerr (message || ' rc='||rc)
            End
            Address TSO "ALLOC F(OUTDD) DA('"DeplDSN"') SHR REUSE"
            If (rc > 0) then
            Do
              message = 'Problem allocating data set 'DeplDSN ||,
                  ' Return Code :'rc'.'  
              Call ISPFerr (message || ' rc='||rc)
            End

            Address TSO "ALLOC F(SYSIN) NEW REUSE"
            Address TSO "ALLOC F(SYSUT4) NEW" ||,
                    " CYLINDERS UNIT("tempUnit") SPACE(5 10) " ||,
                    tempVolser

            DROP SYSLINE.
            
          SYSLINE.1 = " COPYGROUP OUTDD=OUTDD,INDD=((INDD,R))"
          
            /* support deploying part of a package */
            Do memberindex = 1 to RecvMap.i.MemList.0
              sysIndex = memberindex + 1
              SYSLINE.sysIndex = "         SELECT MEMBER="||,
                            RecvMap.i.MemList.memberindex
            end
            SYSLINE.0 = RecvMap.i.MemList.0 + 1
            say 'IEBCOPY control statement'
            do x = 1 to SYSLINE.0
              say SYSLINE.x
            end
            Address TSO "EXECIO * DISKW SYSIN (STEM SYSLINE. FINIS)"

            Address ISPEXEC "ISPEXEC SELECT PGM(IEBCOPY)"
            Copy_rc = rc
           

           If Copy_rc /= 0 Then
           Do
             "EXECIO * DISKR SYSPRINT (FINIS STEM sysprint."
             Do xmit = 1 to sysprint.0
               Say Strip(sysprint.xmit)
             End
             x = Msg('off')
             Address TSO "FREE F(SYSIN)"
             Address TSO "FREE F(SYSPRINT)"
             Address TSO "FREE F(SYSUT4)"
             Address TSO "FREE F(OUTDD)"
             Address TSO "FREE F(INDD)"
             Address TSO "FREE F(SEQFILE)"
             x = Msg('on')
             Call ExitProc(8)
           End

           x = Msg('off')
           Address TSO "FREE F(SYSIN)"
           Address TSO "FREE F(SYSPRINT)"
           Address TSO "FREE F(SYSUT4)"
           Address TSO "FREE F(OUTDD)"
           Address TSO "FREE F(INDD)"
           Address TSO "FREE F(SEQFILE)"
           Address TSO "DELETE '"TempDSN"'"
           x = msg('on')
        End
      End
   End

Return

Proc_Action:

  if isDeleted Then
  Do
    var = "'"DeplDSN"'"
    ListdsiRC = Listdsi(var directory)
    If ListdsiRC <= 4 Then
    Do
      If (sequential) Then
      Do
          Say 'Deleting data set 'DeplDSN
          Address TSO "DELETE '"DeplDSN"'"
      End
      else do
        If (isDatasetMissing & SYSMEMBERS = 0) Then
        Do
          Say 'Deleting data set 'DeplDSN' because it did not exist before'||,
              ' deployment and it is now empty.'
          Address TSO "DELETE '"DeplDSN"'"
        End
      end
    End
    else
    do
      if (sequential) then
        say 'The data set 'DeplDSN' was not deleted because it did not exist.'
    end
  End
  else
  Do
    /* There should be a XMI file to receive if the dataset is    */
    /* not already in the map.                                    */
    found = 0
    If sequential then
      Type = 'Type=sequential'
    Else
      Type = 'Type=PDS'

    RecvMapValue = 'RecvDSN='Strip(DataSet)' DeployTo='Strip(DeplDSN) Type
    Do z = 1 to RecvMap.0
      If RecvMap.z = RecvMapValue Then
      Do
        found = 1
      End
    End
    If found = 0 Then
    Do
      k = k + 1
      RecvMap.k = RecvMapValue
      RecvMap.k.MemList.0 = memberlist.0
      do l = 1 to memberlist.0
          RecvMap.k.MemList.l = memberlist.l
      end
      RecvMap.0 = k
    End
  End

Return

ISPFErr :

   Parse arg msg 'rc='ISPFrc

   /* If the message contains a data set name  */
   /* then parse it out and read it to display */
   /* the contents                             */

   /* Say msg || ' Return code : 'ISPFrc */
   Say msg
   Say ZERRMSG ':' ZERRSM
   If Length(msg) > 70 Then
   Do
     Parse var ZERRLM msgpart 70 msg
     Say msgpart
   End
   Say msg
   Say ' '

   Parse var ZERRLM . 'data set ' msgdsn .
   msgdsn = strip(msgdsn,'t','.')
   Address ISPEXEC "DSINFO DATASET('"msgdsn"')"
   If (rc = 0) then
   Do
     Address TSO "ALLOC F(MSGDSN) DA('"msgdsn"') SHR"
     Address TSO "EXECIO * DISKR MSGDSN (STEM msgline. FINIS "
     Address TSO "FREE  F(MSGDSN)"
     If rc = 0 Then
     Do
       Do i = 1 to msgline.0
         Say msgline.i
       End
     End
   End

   Call Exitproc(ISPFrc)

Return

chkmem1: Procedure

  /* change characters that may cause problems in the xml */

  Parse arg member
  Validchars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ@#$'
  newMemb = ''

  Do mm = 1 to Length(member)
    char = Substr(member,mm,1)
    If Pos(char,Validchars) = 0 Then
    Do
      newMemb = newMemb||'HexValueIs'||right(C2D(char),3,0)
    End
    Else
      newMemb = newMemb||char
  End

Return newMemb

chkmem2: Procedure

  /* change characters to wildcards for IEBCOPY           */

  Parse arg member
  Validchars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ@#$'
  newMemb = ''

  Do mm = 1 to Length(member)
    char = Substr(member,mm,1)
    If Pos(char,Validchars) = 0 Then
      newMemb = newMemb||'%'
    Else
      newMemb = newMemb||char
  End

Return newMemb

chkmem3: Procedure

  /* change characters that may cause problems in the xml */

  Parse arg member
  nonValid = 'HexValueIs'
  newMemb = ''

  Do mm = 1 to Length(member)
    char = Substr(member,mm,10)
    If char = nonValid Then
    Do
       newMemb = newMemb || D2C(Substr(member,mm+10,03))
       mm = mm + 12
    End
    Else
      newMemb = newMemb||Substr(member,mm,1)
  End

Return newMemb

ExitProc :

   Parse arg exit_rc

   ZISPFRC = exit_rc
   Address ISPEXEC "VPUT (ZISPFRC) SHARED"

Exit exit_rc