/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.deployment;

import com.ibm.urbancode.zos.common.util.FileHelper;
import java.io.File;
import java.util.Set;

public class HfsDirectoryValidator {
    private HfsDirectoryValidator() {
    }

    public static void validateTargetDirectories(Set<String> targetDirs, boolean allowCreateDirectory) {
        for (String targetDir : targetDirs) {
            HfsDirectoryValidator.validateTargetDirectory(targetDir, allowCreateDirectory);
        }
    }

    private static void validateTargetDirectory(String toDir, boolean allowCreateDirectory) {
        if (FileHelper.isDirectoryExist(toDir)) {
            HfsDirectoryValidator.checkWritePermission(toDir);
        } else if (allowCreateDirectory) {
            HfsDirectoryValidator.createDirectory(toDir);
        } else {
            throw new IllegalArgumentException("Deploy failed because HFS target directory(" + toDir + ") does not exist and Allow Creating Directory is set to false.");
        }
    }

    private static void checkWritePermission(String toDir) {
        if (!new File(toDir).canWrite()) {
            throw new IllegalArgumentException("User does not have WRITE permission HFS target directory(" + toDir + ")");
        }
    }

    private static void createDirectory(String toDir) {
        if (!new File(toDir).mkdirs()) {
            throw new IllegalArgumentException(" [Error] Failed to create HFS target directory(" + toDir + ")");
        }
    }
}

