/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.mappings;

import com.ibm.urbancode.zos.common.util.StringHelper;
import com.urbancode.air.plugin.command.version.mappings.InvalidMappingException;
import com.urbancode.air.plugin.command.version.mappings.Mapper;
import com.urbancode.air.plugin.command.version.mappings.MappingHelper;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HfsMapper
implements Mapper {
    private final Map<String, String> srcTargetMapWithoutRegEx = new HashMap<String, String>();
    private final Map<String, String> srcTargetMapWithRegEx = new HashMap<String, String>();
    private final String hfsMapping;

    private HfsMapper(String hfsMapping) {
        this.hfsMapping = hfsMapping;
    }

    public static HfsMapper from(String hfsMapping) {
        HfsMapper hfsMapper = new HfsMapper(hfsMapping);
        hfsMapper.loadMappingIntoMaps();
        return hfsMapper;
    }

    private void loadMappingIntoMaps() {
        List<String> hfsMappingPairs = StringHelper.getLines(this.hfsMapping);
        for (String pair : hfsMappingPairs) {
            if ((pair = pair.trim()).isEmpty()) continue;
            this.loadPairIntoMap(pair);
        }
    }

    private void loadPairIntoMap(String pair) {
        String toDir;
        String[] onePair = pair.split(",");
        if (onePair.length != 2) {
            throw new InvalidMappingException("The format of " + pair + " HFS mapping field is incorrect!");
        }
        String src = onePair[0].trim();
        String target = onePair[1].trim();
        if (src.isEmpty()) {
            throw new InvalidMappingException("Missing source directory in HFS mapping - " + pair);
        }
        String fromDir = src.startsWith(File.separator) ? src : File.separator + src;
        String string = toDir = target.startsWith(File.separator) ? target : File.separator + target;
        if (MappingHelper.containsWildcardCharacter(fromDir)) {
            this.loadIntoMapWithWildcard(fromDir, toDir);
        } else {
            this.loadIntoMapWithoutWildcard(fromDir, toDir);
        }
    }

    private void loadIntoMapWithWildcard(String fromDir, String toDir) {
        String wildcardExpressKey = MappingHelper.convertWildcardsToRegularExp(fromDir);
        if (this.srcTargetMapWithRegEx.containsKey(wildcardExpressKey)) {
            throw new InvalidMappingException("Found more than one mapping for '" + fromDir.substring(1) + "' container in HFS mappings");
        }
        this.srcTargetMapWithRegEx.put(wildcardExpressKey, toDir);
    }

    private void loadIntoMapWithoutWildcard(String fromDir, String toDir) {
        if (this.srcTargetMapWithoutRegEx.containsKey(fromDir)) {
            throw new InvalidMappingException("Found more than one mapping for '" + fromDir.substring(1) + "' container in HFS mappings");
        }
        this.srcTargetMapWithoutRegEx.put(fromDir, toDir);
    }

    @Override
    public Map<String, String> getSrcTargetMapWithoutRegEx() {
        return this.srcTargetMapWithoutRegEx;
    }

    @Override
    public Map<String, String> getSrcTargetMapWithRegEx() {
        return this.srcTargetMapWithRegEx;
    }
}

