/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.common;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.team.enterprise.deployment.toolkit.manifest.ProcessExecutor;
import com.ibm.urbancode.zos.common.util.AgentFilesHelper;
import com.ibm.urbancode.zos.common.util.Console;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.urbancode.air.plugin.command.version.common.CheckAccessException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;

public final class CheckAccessExecutor {
    private static final String CHECK_ACCESS_OPTION = "-d";
    private static final String SINGLE_QUOTE = "'";
    private static final String SPACE = " ";
    private static final String UNAVAILABLE_VOLUME = "******";

    private CheckAccessExecutor() {
    }

    public static void executeForBackup(Collection<String> datasets, String versionDirPath) throws IOException, InterruptedException {
        Console.printActionTitle("Check access for backup action:");
        String datasetsFilePath = versionDirPath + File.separator + "dataSetListFile4BackUp";
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(datasetsFilePath));){
            for (String dataset : datasets) {
                if (DatasetHelper.isDatasetExist(dataset)) {
                    writer.write(CheckAccessExecutor.getInputRecord(dataset) + System.lineSeparator());
                    continue;
                }
                Console.printProcessOutput("[Warning] Skipping access check for dataset " + dataset + " as it does not exist.");
            }
        }
        CheckAccessExecutor.executeForDatasetsFile(datasetsFilePath);
    }

    private static String getInputRecord(String dataset) {
        String[] datasetVolume = ZFile.locateDSN((String)(SINGLE_QUOTE + dataset + SINGLE_QUOTE));
        return "INPUT " + dataset + SPACE + datasetVolume[0];
    }

    public static void executeForDeploy(Collection<String> datasets, String versionDirPath) throws IOException, InterruptedException {
        Console.printActionTitle("Check access for deployment action:");
        String datasetsFilePath = versionDirPath + File.separator + "dataSetListFile";
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(datasetsFilePath));){
            for (String dataset : datasets) {
                writer.write(CheckAccessExecutor.getOutputRecord(dataset) + System.lineSeparator());
            }
        }
        CheckAccessExecutor.executeForDatasetsFile(datasetsFilePath);
    }

    private static String getOutputRecord(String dataset) throws ZFileException {
        if (DatasetHelper.isDatasetExist(dataset)) {
            String[] datasetVolume = ZFile.locateDSN((String)(SINGLE_QUOTE + dataset + SINGLE_QUOTE));
            return "OUTPUT " + dataset + SPACE + datasetVolume[0];
        }
        return "OUTPUT " + dataset + SPACE + UNAVAILABLE_VOLUME;
    }

    public static void executeForDatasetsFile(String datasetsFilePath) throws IOException, InterruptedException {
        String checkAccessExecPath = AgentFilesHelper.getCheckAccessExecPath();
        if (FileHelper.isFileNotExist(checkAccessExecPath)) {
            throw new IllegalArgumentException("Cannot find the check access executable: " + checkAccessExecPath);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(checkAccessExecPath, CHECK_ACCESS_OPTION, datasetsFilePath);
        int exitCode = ProcessExecutor.runProcess(processBuilder);
        if (exitCode != 0) {
            CheckAccessExecutor.throwCheckAccessException(exitCode, checkAccessExecPath);
        }
    }

    private static void throwCheckAccessException(int exitCode, String checkAccessExecPath) {
        if (137 == exitCode) {
            throw new CheckAccessException("checkaccess utility failed. To check required access levels, checkaccess utility " + checkAccessExecPath + " needs to be APF authorized.\nFix:\nRun below extattr command with an authorized user to change attributes of checkaccess file and make it APF authorized.\n          extattr +a " + checkAccessExecPath + "\n\nWorkaround:\nUncheck the \"Check Access\" checkbox in the plugin step to skip checking for required access on target datasets.\nPlease note that this might result in failure, if the required access to all target datasets is not there.");
        }
        throw new CheckAccessException("checkaccess:rc=" + exitCode);
    }
}

