/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.deployment;

import com.ibm.jzos.ZFileException;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.xml.utils.deploy.Container;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.ibm.urbancode.zos.xml.utils.deploy.Resource;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;

public class PDSChecker {
    private static final String OPEN_PARENTHESIS = "(";
    private static final String CLOSED_PARENTHESIS = ")";

    private PDSChecker() {
    }

    public static List<String> getListOfExistingPdsMembers(String manifestFilePath, String containerMapperFilePath) throws IOException, XMLStreamException {
        PackageManifest manifest = PackageManifest.from((String)manifestFilePath, (String)containerMapperFilePath);
        return manifest.getContainers().stream().filter(container -> !container.isDeleted()).filter(Container::isPds).flatMap(PDSChecker::getExistingPDSMembers).collect(Collectors.toList());
    }

    private static Stream<String> getExistingPDSMembers(Container pdsContainer) {
        return pdsContainer.getResources().stream().flatMap(member -> PDSChecker.getTargetPdsDatasetsWithEnclosedMember(pdsContainer, member)).filter(PDSChecker::isPDSMemberExist);
    }

    private static Stream<String> getTargetPdsDatasetsWithEnclosedMember(Container pdsContainer, Resource member) {
        return pdsContainer.getTargetContainers().stream().map(targetContainer -> targetContainer + OPEN_PARENTHESIS + member.getName() + CLOSED_PARENTHESIS);
    }

    private static boolean isPDSMemberExist(String pdsMember) {
        try {
            return DatasetHelper.isDatasetExist(pdsMember);
        }
        catch (ZFileException e) {
            throw new RuntimeException(e);
        }
    }
}

