/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.hfs;

import com.ibm.team.enterprise.automation.hfs.HFSUtil;
import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestReader;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.urbancode.zos.xml.utils.deploy.ContainerMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Echo;
import org.apache.tools.ant.types.FileSet;

public class BackupFilesTask
extends Task {
    private String versionWorkDir;
    private boolean oldVersionIdentifier;

    public void execute() throws BuildException {
        try {
            String hfsTargetOutputsDir;
            File targetOutputsDirPathFile;
            PrintWriter includesFileOutput;
            File includesFile;
            boolean addedIncludes;
            String targetOutputsDirPath;
            File targetOutputsDir;
            String containerName;
            ContainerMap containerMap = ContainerMap.from((String)(this.versionWorkDir + File.separator + "containerMapperHFS.xml"));
            File manifestFile = new File(this.versionWorkDir + File.separator + "packageManifest_deploy.xml");
            Manifest packageManifest = ManifestReader.getInstance().getManifest(manifestFile);
            File deltaManifestFile = new File(this.versionWorkDir + File.separator + "deltaDeployed.xml");
            Manifest deltaManifest = this.getDeltaManifest(deltaManifestFile);
            List deployContainers = HFSUtil.getHFSContainers((List)packageManifest.getContainers());
            List deletedContainers = HFSUtil.getHFSContainers((List)packageManifest.getDeletedContainers());
            for (Container container : deployContainers) {
                containerName = File.separator + container.getName();
                targetOutputsDir = new File((String)containerMap.getTargets(containerName).get(0));
                targetOutputsDirPath = this.oldVersionIdentifier ? targetOutputsDir.getCanonicalPath() + containerName : targetOutputsDir.getCanonicalPath();
                addedIncludes = false;
                includesFile = new File(this.versionWorkDir + File.separator + "deltaDeployed.asHFSFileSet");
                includesFileOutput = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(includesFile), "UTF-8")));
                if (this.processFilesToCreateOrUpdate(container, targetOutputsDirPath, includesFileOutput, deltaManifest)) {
                    addedIncludes = true;
                }
                includesFileOutput.flush();
                includesFileOutput.close();
                if (addedIncludes) {
                    targetOutputsDirPathFile = new File(targetOutputsDirPath);
                    FileSet updatesFileSet = new FileSet();
                    updatesFileSet.setProject(this.getProject());
                    updatesFileSet.setDir(targetOutputsDirPathFile);
                    updatesFileSet.setIncludesfile(includesFile);
                    hfsTargetOutputsDir = "HFS" + File.separator + container.getName();
                    this.printFilesLog(targetOutputsDirPath, updatesFileSet);
                    HFSUtil.createTar(Arrays.asList(updatesFileSet), (File)new File(this.versionWorkDir, "backup.zip"), (String)hfsTargetOutputsDir, (Project)this.getProject());
                }
                includesFile.delete();
                HFSUtil.serializeManifest((Manifest)deltaManifest, (File)deltaManifestFile);
            }
            for (Container container : deletedContainers) {
                containerName = File.separator + container.getName();
                targetOutputsDir = new File((String)containerMap.getTargets(containerName).get(0));
                targetOutputsDirPath = this.oldVersionIdentifier ? targetOutputsDir.getCanonicalPath() + containerName : targetOutputsDir.getCanonicalPath();
                addedIncludes = false;
                includesFile = new File(this.versionWorkDir + File.separator + "deltaDeployed.asHFSFileSet");
                includesFileOutput = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(includesFile))));
                if (this.processDeltaManifestForDeletes(container, targetOutputsDirPath, includesFileOutput, deltaManifest, this.getProject())) {
                    addedIncludes = true;
                }
                includesFileOutput.flush();
                includesFileOutput.close();
                if (addedIncludes) {
                    targetOutputsDirPathFile = new File(targetOutputsDirPath);
                    FileSet deletesFileSet = new FileSet();
                    deletesFileSet.setProject(this.getProject());
                    deletesFileSet.setDir(targetOutputsDirPathFile);
                    deletesFileSet.setIncludesfile(includesFile);
                    hfsTargetOutputsDir = "HFS" + File.separator + container.getName();
                    this.printFilesLog(targetOutputsDirPath, deletesFileSet);
                    HFSUtil.createTar(Arrays.asList(deletesFileSet), (File)new File(this.versionWorkDir, "backup.zip"), (String)hfsTargetOutputsDir, (Project)this.getProject());
                }
                includesFile.delete();
                HFSUtil.serializeManifest((Manifest)deltaManifest, (File)deltaManifestFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    private void printFilesLog(String targetOutputsDirPath, FileSet fileSet) {
        this.printLine("\tAdding following files from " + targetOutputsDirPath + " to backup");
        fileSet.stream().forEach(resource -> this.printLine("\t\t" + resource.getName()));
    }

    private void printLine(String s) {
        Echo echo = new Echo();
        echo.setMessage(s);
        echo.execute();
    }

    private Manifest getDeltaManifest(File deltaManifestFile) throws Exception {
        if (deltaManifestFile.exists()) {
            return ManifestReader.getInstance().getManifest(deltaManifestFile);
        }
        Manifest deltaManifest = new Manifest();
        deltaManifest.setType("MANIFEST_REPORT");
        return deltaManifest;
    }

    private boolean processDeltaManifestForDeletes(Container container, String outputsDirPath, PrintWriter includesFileOutput, Manifest deltaManifest, Project project) {
        HashMap<String, Container> deltaContainerMapping = new HashMap<String, Container>();
        for (Container deltaContainer : HFSUtil.getHFSContainers((List)deltaManifest.getDeletedContainers(), (boolean)true)) {
            deltaContainerMapping.put(deltaContainer.getName(), deltaContainer);
        }
        boolean addedIncludes = false;
        Iterator resources = container.getResourcesIterator();
        ArrayList<String> deletedFiles = new ArrayList<String>();
        while (resources.hasNext()) {
            Resource resource = (Resource)resources.next();
            String relativePath = resource.getName();
            FileSet fileSet = new FileSet();
            fileSet.setProject(project);
            fileSet.setDir(new File(outputsDirPath));
            fileSet.createInclude().setName(relativePath);
            HashMap<String, HashSet<Resource>> directoryToResourceMapping = new HashMap<String, HashSet<Resource>>();
            this.scanFiles(fileSet, outputsDirPath, directoryToResourceMapping, project, resource);
            if (directoryToResourceMapping.isEmpty()) continue;
            Set<String> containerNames = directoryToResourceMapping.keySet();
            for (String containerName : containerNames) {
                Container deltaContainer;
                if (!containerName.equals(outputsDirPath)) continue;
                String deltaContainerName = container.getName();
                boolean isNewContainer = false;
                if (!deltaContainerMapping.containsKey(deltaContainerName)) {
                    isNewContainer = true;
                    deltaContainer = new Container();
                    deltaContainer.setType("directory");
                    deltaContainer.setChangeType("DELETE");
                    deltaContainer.setName(deltaContainerName);
                } else {
                    deltaContainer = (Container)deltaContainerMapping.get(deltaContainerName);
                }
                for (Resource newResource : directoryToResourceMapping.get(containerName)) {
                    deltaContainer.addResource(newResource);
                    String includePath = newResource.getName();
                    deletedFiles.add(container.getName() + File.separator + includePath);
                    includesFileOutput.println(includePath);
                    addedIncludes = true;
                }
                if (!isNewContainer || !deltaContainer.getResourcesIterator().hasNext()) continue;
                deltaManifest.addDeletedContainer(deltaContainer);
                deltaContainerMapping.put(deltaContainer.getName(), deltaContainer);
            }
        }
        boolean isNewContainer = false;
        Container deltaContainer = (Container)deltaContainerMapping.get(container.getName());
        if (deltaContainer == null) {
            isNewContainer = true;
            deltaContainer = new Container();
            deltaContainer.setType("directory");
            deltaContainer.setChangeType("DELETE");
            deltaContainer.setName(container.getName());
        }
        Iterator pkgResources = container.getResourcesIterator();
        while (pkgResources.hasNext()) {
            String path;
            Resource pkgResource = (Resource)pkgResources.next();
            if (pkgResource.getName().contains("*") || pkgResource.getName().contains("?") || deletedFiles.contains(path = HFSUtil.getNormalizedPath((Container)container, (Resource)pkgResource))) continue;
            Resource newResource = new Resource(pkgResource);
            newResource.setMissing("true");
            deltaContainer.addResource(newResource);
        }
        if (isNewContainer && deltaContainer.getResourcesIterator().hasNext()) {
            deltaManifest.addDeletedContainer(deltaContainer);
            deltaContainerMapping.put(deltaContainer.getName(), deltaContainer);
        }
        return addedIncludes;
    }

    private boolean processFilesToCreateOrUpdate(Container container, String outputsDirPath, PrintWriter includesFileOutput, Manifest deltaManifest) {
        boolean addedIncludes = false;
        HashMap<String, Container> createdContainers = new HashMap<String, Container>();
        HashMap<String, Container> updatedContainers = new HashMap<String, Container>();
        Iterator resources = container.getResourcesIterator();
        while (resources.hasNext()) {
            Container newContainer;
            Resource resource = (Resource)resources.next();
            String relativePath = resource.getName();
            File file = new File(outputsDirPath + File.separator + relativePath);
            if (file.exists()) {
                newContainer = (Container)updatedContainers.get(container.getName());
                if (newContainer == null) {
                    newContainer = new Container();
                    newContainer.setName(container.getName());
                    newContainer.setType("directory");
                    newContainer.setChangeType("UPDATE");
                    updatedContainers.put(newContainer.getName(), newContainer);
                }
                includesFileOutput.println(relativePath);
                addedIncludes = true;
            } else {
                newContainer = (Container)createdContainers.get(container.getName());
                if (newContainer == null) {
                    newContainer = new Container();
                    newContainer.setName(container.getName());
                    newContainer.setType("directory");
                    newContainer.setChangeType("ADD");
                    createdContainers.put(newContainer.getName(), newContainer);
                }
            }
            Resource newResource = new Resource(resource);
            newContainer.addResource(newResource);
        }
        deltaManifest.getCreatedContainers().addAll(createdContainers.values());
        deltaManifest.getUpdatedContainers().addAll(updatedContainers.values());
        return addedIncludes;
    }

    private void scanFiles(FileSet fileSet, String outputsDirPath, HashMap<String, HashSet<Resource>> directoryToResourceMapping, Project project, Resource originalResource) {
        String[] resolvedFiles;
        DirectoryScanner scanner = fileSet.getDirectoryScanner(project);
        for (String resolvedFile : resolvedFiles = scanner.getIncludedFiles()) {
            int lastIndexOfSlash = resolvedFile.lastIndexOf(File.separator);
            if (lastIndexOfSlash != -1) {
                HFSUtil.collectFileInformation((String)(outputsDirPath + File.separator + resolvedFile.substring(0, lastIndexOfSlash)), (String)resolvedFile.substring(lastIndexOfSlash + 1), null, directoryToResourceMapping, (Project)project, (Resource)originalResource);
                continue;
            }
            HFSUtil.collectFileInformation((String)outputsDirPath, (String)resolvedFile, null, directoryToResourceMapping, (Project)project, (Resource)originalResource);
        }
    }

    public void setVersionWorkDir(String versionWorkDir) {
        this.versionWorkDir = versionWorkDir;
    }

    public boolean isoldVersionIdentifier() {
        return this.oldVersionIdentifier;
    }

    public void setoldVersionIdentifier(boolean oldVersionIdentifier) {
        this.oldVersionIdentifier = oldVersionIdentifier;
    }
}

