/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit.manifest;

import com.ibm.team.enterprise.deployment.dataset.record.DatasetRecord;
import com.ibm.team.enterprise.deployment.dataset.record.DatasetRecordsWriter;
import com.ibm.team.enterprise.deployment.dataset.record.DeploymentRecordsGenerator;
import com.ibm.team.enterprise.deployment.dataset.record.MemberStatsRecord;
import com.ibm.team.enterprise.deployment.toolkit.manifest.CpCommand;
import com.ibm.team.enterprise.deployment.toolkit.manifest.CpScriptFile;
import com.ibm.team.enterprise.deployment.toolkit.manifest.CpTempDatasetCreator;
import com.ibm.team.enterprise.deployment.toolkit.manifest.ProcessExecutor;
import com.ibm.team.enterprise.deployment.toolkit.manifest.SourceTempDsnMap;
import com.ibm.urbancode.zos.common.util.Console;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.common.util.PluginFilesHelper;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.dataset.util.TempDsnNameHelper;
import com.ibm.urbancode.zos.rexx.RexxExecutor;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class NewFormatPackageDeployer {
    private final String manifestDeployFilePath;
    private final String containerMapperFilePath;
    private final String tempDsnPrefix;
    private final String componentVersionWorkingDir;
    private final String ispfGatewayBinPath;

    public NewFormatPackageDeployer(String componentVersionWorkingDir, String tempDsnPrefix, String ispfGatewayBinPath) {
        this.componentVersionWorkingDir = componentVersionWorkingDir;
        this.tempDsnPrefix = tempDsnPrefix;
        this.ispfGatewayBinPath = ispfGatewayBinPath;
        this.manifestDeployFilePath = componentVersionWorkingDir + File.separator + "packageManifest_deploy.xml";
        this.containerMapperFilePath = componentVersionWorkingDir + File.separator + "containerMapper.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy() throws Exception {
        this.extractPackageZip();
        PackageManifest packageManifestDeploy = PackageManifest.from((String)this.manifestDeployFilePath, (String)this.containerMapperFilePath);
        Map<String, String> sourceTempDsnMap = SourceTempDsnMap.from(packageManifestDeploy, this.tempDsnPrefix);
        this.createTemporaryDatasets(packageManifestDeploy, sourceTempDsnMap);
        String statsUpdaterRexxInput = null;
        String deploymentRexxInputDsn = null;
        try {
            this.copyFilesToDatasets(packageManifestDeploy, sourceTempDsnMap);
            RexxExecutor rexxExecutor = new RexxExecutor(this.tempDsnPrefix, this.ispfGatewayBinPath);
            statsUpdaterRexxInput = this.getStatsUpdaterRexxInput(packageManifestDeploy, sourceTempDsnMap);
            rexxExecutor.execute(PluginFilesHelper.getPdsMemberStatsUpdaterRexxFilePath(), statsUpdaterRexxInput);
            deploymentRexxInputDsn = this.createDeploymentRexxInputDsn(packageManifestDeploy, sourceTempDsnMap);
            rexxExecutor.execute(PluginFilesHelper.getDeploymentRexxFilePath(), deploymentRexxInputDsn);
        }
        catch (Throwable throwable) {
            DatasetHelper.deleteDataset(deploymentRexxInputDsn);
            DatasetHelper.deleteDataset(statsUpdaterRexxInput);
            Collection<String> tempDatasets = sourceTempDsnMap.values();
            for (String tempDataset : tempDatasets) {
                DatasetHelper.deleteDataset(tempDataset);
            }
            throw throwable;
        }
        DatasetHelper.deleteDataset(deploymentRexxInputDsn);
        DatasetHelper.deleteDataset(statsUpdaterRexxInput);
        Collection<String> tempDatasets = sourceTempDsnMap.values();
        for (String tempDataset : tempDatasets) {
            DatasetHelper.deleteDataset(tempDataset);
        }
    }

    private String createDeploymentRexxInputDsn(PackageManifest packageManifestDeploy, Map<String, String> sourceTempDsnMap) throws IOException {
        List<DatasetRecord> deploymentRecords = DeploymentRecordsGenerator.generateRecordsFrom(packageManifestDeploy, sourceTempDsnMap);
        String deploymentRexxInputDsn = TempDsnNameHelper.getActionDsnName(this.tempDsnPrefix);
        DatasetRecordsWriter.write(deploymentRecords, deploymentRexxInputDsn);
        return deploymentRexxInputDsn;
    }

    private String getStatsUpdaterRexxInput(PackageManifest packageManifestDeploy, Map<String, String> sourceTempDsnMap) throws IOException {
        String statsDataset = TempDsnNameHelper.getStatsDsnName(this.tempDsnPrefix);
        List<DatasetRecord> statsRecords = MemberStatsRecord.generateRecords(packageManifestDeploy, sourceTempDsnMap);
        DatasetRecordsWriter.write(statsRecords, statsDataset);
        return statsDataset;
    }

    private void createTemporaryDatasets(PackageManifest packageManifestDeploy, Map<String, String> sourceTempDsnMap) {
        Console.printActionTitle("Creating Temporary Datasets");
        CpTempDatasetCreator.create(packageManifestDeploy, this.componentVersionWorkingDir, sourceTempDsnMap);
        System.out.println();
    }

    private void extractPackageZip() throws IOException, InterruptedException {
        String packageZipFilePath = this.componentVersionWorkingDir + File.separator + "package.zip";
        if (FileHelper.isFileExist(packageZipFilePath)) {
            ProcessExecutor.extractUsingPaxCommand(this.componentVersionWorkingDir, "package.zip");
        }
    }

    private void copyFilesToDatasets(PackageManifest packageManifestDeploy, Map<String, String> sourceTempDsnMap) throws Exception {
        List<String> cpCommands = CpCommand.generateCommands(packageManifestDeploy, sourceTempDsnMap);
        String cpScriptFilePath = this.componentVersionWorkingDir + File.separator + "temp_copy_file_to_dataset.sh";
        CpScriptFile.create(cpScriptFilePath, cpCommands);
        ProcessExecutor.executeScript(this.componentVersionWorkingDir, "temp_copy_file_to_dataset.sh");
    }
}

