/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.rollback;

import com.ibm.team.enterprise.automation.ispf.IspfPermissionsChecker;
import com.ibm.team.enterprise.deployment.common.PackageManifestUtil;
import com.ibm.team.enterprise.deployment.hfs.DeployFilesTask;
import com.ibm.team.enterprise.deployment.toolkit.manifest.OldPackageFormatDeployer;
import com.ibm.urbancode.zos.common.util.Console;
import com.ibm.urbancode.zos.common.util.DeploymentFilesHelper;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.common.util.InstalledAgentVersion;
import com.ibm.urbancode.zos.common.util.UdClientHelper;
import com.ibm.urbancode.zos.xml.utils.common.DeployedVersion;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.ibm.urbancode.zos.zinventory.ZInventoryTable;
import com.urbancode.air.plugin.command.version.common.AntHelper;
import com.urbancode.air.plugin.command.version.common.CheckAccessExecutor;
import com.urbancode.air.plugin.command.version.mappings.ContainerMapperXml;
import com.urbancode.air.plugin.command.version.mappings.HfsMapper;
import com.urbancode.air.plugin.command.version.mappings.MappingResolver;
import com.urbancode.air.plugin.command.version.rollback.RollbackManifestGenerator;
import com.urbancode.air.plugin.command.version.rollback.RollbackPackageInputs;
import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.commons.util.ssl.XTrustProvider;
import com.urbancode.ud.client.EnvironmentClient;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class RollbackPackage {
    private static final String ERROR_INFO = " does not exist or is not a file. Error rolling back because one of the files needed for rollback is not found. Please make sure you have deployed the version successfully and haven't rolled back it already.";
    private static final String VERSION_7_3_1 = "7.3.1";
    private final Properties inputProperties;
    private final Properties outputProperties;

    public RollbackPackage(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        try {
            RollbackPackageInputs pluginInputs = RollbackPackageInputs.getValidatedInputs(this.inputProperties);
            DeployedVersion deployedVersion = pluginInputs.getDeployedVersion();
            String deployBasePathForVersion = deployedVersion.getVersionDirPath();
            if (!deployedVersion.exist()) {
                throw new InvalidInputException("Please make sure you have deployed the version successfully and haven't rolled back it already.");
            }
            String packageManifestFilePath = deployBasePathForVersion + File.separator + "packageManifest.xml";
            PackageManifest packageManifestXml = PackageManifest.from((String)packageManifestFilePath);
            if (packageManifestXml.hasOnlyGenericArtifacts()) {
                Console.printActionTitle("No artifacts to rollback. Version contains only generic artifacts.");
                return 0;
            }
            if (pluginInputs.isPreventRiskyRollbackEnabled()) {
                this.checkRiskForRollback(pluginInputs);
            } else {
                Console.printProcessOutput(" [INFO] Prevent risky rollback is disabled. Risk checking is skipped.");
            }
            if (pluginInputs.isDryRunEnabled()) {
                Console.printProcessOutput("Dry run completed. Nothing is deployed.");
                return 0;
            }
            String currentVersionWorkingDir = DeploymentFilesHelper.getVersionDirPathInWorkingDir(pluginInputs.getVersionName(), pluginInputs.getResourceId());
            FileHelper.cleanDirectory(currentVersionWorkingDir);
            FileHelper.createDirectory(currentVersionWorkingDir);
            Console.printActionTitle("Copy backup into working directory:");
            String rollbackManifestFilePath = deployBasePathForVersion + File.separator + "rollbackManifest.xml";
            if (FileHelper.isFileNotExist(rollbackManifestFilePath)) {
                throw new IllegalArgumentException(rollbackManifestFilePath + ERROR_INFO);
            }
            String toDeployDeltaFilePath = currentVersionWorkingDir + File.separator + "deltaDeployed.xml";
            FileHelper.copyFile(rollbackManifestFilePath, toDeployDeltaFilePath);
            String backupZipFilePath = deployBasePathForVersion + File.separator + "backup.zip";
            if (FileHelper.isFileExist(backupZipFilePath)) {
                String toBackupZipFilePath = currentVersionWorkingDir + File.separator + "backup.zip";
                FileHelper.copyFile(backupZipFilePath, toBackupZipFilePath);
            }
            String containerHFSFilePath = deployBasePathForVersion + File.separator + "containerMapperHFS.xml";
            if (packageManifestXml.hasHFSFile()) {
                String toContainerHFSFilePath = currentVersionWorkingDir + File.separator + "containerMapperHFS.xml";
                if (FileHelper.isFileExist(containerHFSFilePath)) {
                    FileHelper.copyFile(containerHFSFilePath, toContainerHFSFilePath);
                } else {
                    this.createContainerMapperHfsFile(pluginInputs.getHfsMapping(), packageManifestXml, toContainerHFSFilePath);
                }
            }
            String containerFilePath = deployBasePathForVersion + File.separator + "containerMapper.xml";
            if (packageManifestXml.hasDataset()) {
                if (FileHelper.isFileNotExist(containerFilePath)) {
                    throw new IllegalArgumentException(containerFilePath + ERROR_INFO);
                }
                String toContainerFilePath = currentVersionWorkingDir + File.separator + "containerMapper.xml";
                FileHelper.copyFile(containerFilePath, toContainerFilePath);
                System.out.println();
            }
            if (packageManifestXml.hasDataset() && pluginInputs.isCheckAccessEnabled()) {
                RollbackPackage.checkAccessForDatasets(deployBasePathForVersion, currentVersionWorkingDir);
            }
            IspfPermissionsChecker.checkDirectoryFilePermissions();
            String invertedRollbackManifestXml = RollbackManifestGenerator.generateInvertedActionsXml(toDeployDeltaFilePath);
            Console.printActionTitle("Inverted manifest generated for rollback:");
            System.out.println(invertedRollbackManifestXml + "\n");
            String toRollbackMfFilePath = currentVersionWorkingDir + File.separator + "rollbackManifest.xml";
            FileHelper.writeStringToFile(invertedRollbackManifestXml, toRollbackMfFilePath);
            Console.printActionTitle("Rollback:");
            if (packageManifestXml.hasDataset()) {
                this.rollbackMVSArtifacts(pluginInputs, currentVersionWorkingDir);
            }
            if (packageManifestXml.hasHFSFile()) {
                boolean isHfsMappingInOldFormat = this.isHfsMappingInOldFormat(deployBasePathForVersion);
                this.rollbackHFSArtifacts(currentVersionWorkingDir, isHfsMappingInOldFormat);
            }
            RollbackPackage.updateRollbackDataInZInventoryTable(pluginInputs.getVersionId(), pluginInputs.getEnvironmentId());
            if (pluginInputs.isDeleteBackupFilesEnabled()) {
                Console.printActionTitle("Deleting version backup files:");
                FileHelper.cleanDirectory(deployBasePathForVersion);
                System.out.println();
            }
            FileHelper.cleanDirectory(currentVersionWorkingDir);
            return 0;
        }
        catch (InvalidInputException invalidInputException) {
            System.out.println(" [Error] " + invalidInputException.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    private static void checkAccessForDatasets(String deployBasePathForVersion, String currentVersionWorkingDir) throws IOException, InterruptedException {
        Console.printActionTitle("Check access for Rollback action:");
        String dsListFilePath = deployBasePathForVersion + File.separator + "dataSetListFile";
        if (FileHelper.isFileNotExist(dsListFilePath)) {
            Console.printProcessOutput(" [Warning] The target dataset list file " + dsListFilePath + " is not found, access check is skipped.");
            return;
        }
        String toDsListFilePath = currentVersionWorkingDir + File.separator + "dataSetListFile";
        FileHelper.copyFile(dsListFilePath, toDsListFilePath);
        CheckAccessExecutor.executeForDatasetsFile(toDsListFilePath);
        System.out.println();
    }

    private static void updateRollbackDataInZInventoryTable(String versionId, String environmentId) throws IOException, URISyntaxException {
        boolean isAgentVersionLessThan731;
        boolean bl = isAgentVersionLessThan731 = !InstalledAgentVersion.isGreaterThanOrEqualTo(VERSION_7_3_1);
        if (isAgentVersionLessThan731) {
            return;
        }
        System.out.println("Adding data to zInventory");
        ZInventoryTable zInventoryTable = new ZInventoryTable(versionId, environmentId);
        zInventoryTable.updateForRollback();
    }

    private void checkRiskForRollback(RollbackPackageInputs pluginInputs) throws JSONException, URISyntaxException, IOException {
        Console.printActionTitle("Checking risk for rollback.");
        JSONArray overlappingArtifacts = this.getOverlappingArtifacts(pluginInputs);
        if (overlappingArtifacts.length() == 0) {
            Console.printProcessOutput("Risk checking passed.");
            return;
        }
        Console.printProcessOutput("Risk checking failed for artifacts:");
        for (int jsonLoopIndex = 0; jsonLoopIndex < overlappingArtifacts.length(); ++jsonLoopIndex) {
            JSONObject riskyArtifact = overlappingArtifacts.getJSONObject(jsonLoopIndex);
            Console.printProcessOutput("  [" + riskyArtifact.getString("action") + "] " + riskyArtifact.getString("name") + " is replaced by subsequent version:" + riskyArtifact.getString("versionName"));
        }
        this.outputProperties.put("reason", "2");
        this.outputProperties.put("reasonMessage", "Risk found.");
        throw new InvalidInputException("Rollback failed because risk is detected. A risky rollback tries to rollback modules which have been replaced by a subsequent version.");
    }

    private JSONArray getOverlappingArtifacts(RollbackPackageInputs pluginInputs) throws JSONException, URISyntaxException, IOException {
        try {
            EnvironmentClient environmentClient = UdClientHelper.getEnvironmentClient();
            XTrustProvider.install();
            return environmentClient.getOverlappingArtifacts(pluginInputs.getEnvironmentId(), pluginInputs.getComponentId(), pluginInputs.getResourceId(), pluginInputs.getVersionId());
        }
        catch (IOException ioException) {
            if (ioException.getMessage().contains("400 Bad Request") && ioException.getMessage().contains("not deployed")) {
                this.outputProperties.put("reason", "1");
                this.outputProperties.put("reasonMessage", "Version not deployed.");
                throw new InvalidInputException(pluginInputs.getVersionName() + " not deployed");
            }
            throw ioException;
        }
    }

    private void createContainerMapperHfsFile(String hfsMapping, PackageManifest packageManifestXml, String toContainerHFSFilePath) throws IOException, XMLStreamException {
        if (hfsMapping.isEmpty()) {
            throw new IllegalArgumentException("Version contains HFS files. HFS target directory is required.");
        }
        Set<String> hfsNeedToDeploy = PackageManifestUtil.getAllDeployHFSFiles(packageManifestXml);
        HfsMapper hfsMapper = HfsMapper.from(hfsMapping);
        Map<String, String> srcTargetMap = MappingResolver.resolve(hfsMapper, hfsNeedToDeploy);
        String containerMapperHFSXml = ContainerMapperXml.createForHfs(srcTargetMap);
        Console.printActionTitle("The containerMapperHFS.xml contents:");
        Console.printProcessOutput(containerMapperHFSXml);
        FileHelper.writeStringToFile(containerMapperHFSXml, toContainerHFSFilePath);
    }

    private void rollbackMVSArtifacts(RollbackPackageInputs pluginInputs, String componentVersionWorkingDir) throws Exception {
        Console.printActionTitle("Rollback data sets:");
        String containerMapperFilePath = componentVersionWorkingDir + File.separator + "containerMapper.xml";
        String rollbackManifestFilePath = componentVersionWorkingDir + File.separator + "rollbackManifest.xml";
        OldPackageFormatDeployer oldPackageFormatDeployer = new OldPackageFormatDeployer(pluginInputs.isPrintLogsEnabled(), pluginInputs.getTempDsnPrefix(), pluginInputs.getIspfGatewayBinPath());
        oldPackageFormatDeployer.deployFromBackup(rollbackManifestFilePath, containerMapperFilePath, componentVersionWorkingDir);
    }

    private void rollbackHFSArtifacts(String componentVersionWorkingDir, boolean isHfsMappingInOldFormat) throws Exception {
        Console.printActionTitle("Rollback HFS files:");
        String unpackDir = componentVersionWorkingDir + File.separator + "unpacked";
        String backupZipFilePath = componentVersionWorkingDir + File.separator + "backup.zip";
        if (FileHelper.isFileExist(backupZipFilePath)) {
            AntHelper.untar(unpackDir, backupZipFilePath);
        }
        String containerMapperHFSFilePath = componentVersionWorkingDir + File.separator + "containerMapperHFS.xml";
        String artifactsDir = unpackDir + File.separator + "HFS";
        String rollbackManifestFilePath = componentVersionWorkingDir + File.separator + "rollbackManifest.xml";
        DeployFilesTask deployFilesTask = new DeployFilesTask(artifactsDir, isHfsMappingInOldFormat);
        deployFilesTask.execute(rollbackManifestFilePath, containerMapperHFSFilePath, false);
        FileHelper.cleanDirectory(unpackDir);
        System.out.println();
    }

    private boolean isHfsMappingInOldFormat(String deployBasePathForVersion) {
        return FileHelper.isFileNotExist(deployBasePathForVersion + File.separator + "tempFileNewVersion.xml");
    }
}

