/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.generate.artifact.info;

import com.ibm.urbancode.zos.generate.artifact.info.Console;
import com.ibm.urbancode.zos.generate.artifact.info.DeploymentAction;
import com.ibm.urbancode.zos.generate.artifact.info.Filters;
import com.ibm.urbancode.zos.generate.artifact.info.LoopType;
import com.ibm.urbancode.zos.xml.utils.common.ContainerType;
import com.ibm.urbancode.zos.xml.utils.deploy.Container;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.ibm.urbancode.zos.xml.utils.deploy.Resource;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackContainer;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackManifest;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArtifactInfo {
    private static final String REGEX_FOR_PROPERTY = "\\$\\{.+}";
    private static final String BLANK = "";
    private static final String EMPTY_MEMBER_NAME = "";
    private static final String REGEX_FORMAT = "^/.+/$";
    private static final Map<LoopType, ContainerType> loopTypeToContainerTypeMap = new HashMap<LoopType, ContainerType>(){
        {
            this.put(LoopType.Member, ContainerType.PDS);
            this.put(LoopType.PDS, ContainerType.PDS);
            this.put(LoopType.Sequential, ContainerType.SEQUENTIAL);
            this.put(LoopType.Directory, ContainerType.DIRECTORY);
            this.put(LoopType.File, ContainerType.DIRECTORY);
            this.put(LoopType.GenericArtifactGroup, ContainerType.GENERIC);
            this.put(LoopType.GenericArtifact, ContainerType.GENERIC);
        }
    };
    private static final Map<LoopType, ContainerType> deletedLoopTypeToContainerTypeMap = new HashMap<LoopType, ContainerType>(){
        {
            this.put(LoopType.DeletedMember, ContainerType.PDS);
            this.put(LoopType.DeletedPDS, ContainerType.PDS);
            this.put(LoopType.DeletedMemberExcludingMissingMembers, ContainerType.PDS);
            this.put(LoopType.DeletedSequential, ContainerType.SEQUENTIAL);
            this.put(LoopType.DeletedFile, ContainerType.DIRECTORY);
        }
    };
    private final Filters filterInputs;
    private final StringBuilder templateBuilder = new StringBuilder();
    private final List<RollbackContainer> rollbackContainers;
    private final PackageManifest packageManifest;
    private long count = 0L;

    private ArtifactInfo(Filters filterInputs, PackageManifest packageManifest, List<RollbackContainer> rollbackContainers) {
        this.filterInputs = filterInputs;
        this.packageManifest = packageManifest;
        this.rollbackContainers = rollbackContainers;
    }

    public static ArtifactInfo generate(Filters filterInputs, PackageManifest packageManifest) {
        return ArtifactInfo.generateInfo(filterInputs, packageManifest, new ArrayList<RollbackContainer>());
    }

    public static ArtifactInfo generate(Filters filterInputs, PackageManifest packageManifest, RollbackManifest rollbackManifest) {
        List<RollbackContainer> rollbackContainers = ArtifactInfo.getContainersBasedOnAction(filterInputs.getDeploymentAction(), rollbackManifest);
        return ArtifactInfo.generateInfo(filterInputs, packageManifest, rollbackContainers);
    }

    private static List<RollbackContainer> getContainersBasedOnAction(DeploymentAction deploymentAction, RollbackManifest rollbackManifest) {
        if (deploymentAction == DeploymentAction.CREATED) {
            return rollbackManifest.getCreatedContainers();
        }
        if (deploymentAction == DeploymentAction.UPDATED) {
            return rollbackManifest.getUpdatedContainers();
        }
        return rollbackManifest.getDeletedContainers();
    }

    private static ArtifactInfo generateInfo(Filters filterInputs, PackageManifest packageManifest, List<RollbackContainer> rollbackContainers) {
        Console.printFilters(filterInputs);
        ArtifactInfo artifactInfo = new ArtifactInfo(filterInputs, packageManifest, rollbackContainers);
        if (LoopType.isContainerLevel(filterInputs.getLoopType())) {
            artifactInfo.generateTextForContainers();
        } else {
            artifactInfo.generateTextForContainerResources();
        }
        return artifactInfo;
    }

    private void generateTextForContainers() {
        this.packageManifest.getContainers().forEach(this::processTargetsForContainers);
    }

    private void processTargetsForContainers(Container container) {
        List<String> targets = ArtifactInfo.getTargets(container);
        targets.stream().peek(targetName -> Console.printContainerInfo(container, targetName)).filter(targetName -> this.isLoopTypeMatched(container)).filter(targetName -> this.isSourceMatched(container)).filter(targetName -> this.isContainerDeployTypeMatched(container)).filter(this::isTargetMatched).filter(targetName -> this.areContainerCustomPropertiesMatched(container)).filter(targetName -> this.isDeployActionMatched(container, (String)targetName)).map(targetName -> this.getTemplateTokens(container, (String)targetName)).map(this::replaceTokensInTemplate).map(this::checkForUnresolvedTemplateProperties).forEach(this::appendTemplate);
    }

    private void generateTextForContainerResources() {
        this.packageManifest.getContainers().forEach(container -> this.generateTextForResources((Container)container, container.getResources()));
    }

    private void generateTextForResources(Container container, List<Resource> resources) {
        List<String> targets = ArtifactInfo.getTargets(container);
        for (String targetName : targets) {
            resources.stream().peek(resource -> Console.printContainerResourceInfo(container, targetName, resource)).filter(resource -> this.isLoopTypeMatched(container)).filter(resource -> this.isSourceMatched(container)).filter(resource -> this.isTargetMatched(targetName)).filter(this::isResourceDeployTypeMatched).filter(this::isMemberMatched).filter(resource -> this.areResourceCustomPropertiesMatched(container, (Resource)resource)).filter(resource -> this.isResourceDeployActionMatched(container, targetName, (Resource)resource)).filter(resource -> this.isDeletedMissingMemberToBeIncluded(container, targetName, (Resource)resource)).map(resource -> this.getTemplateTokens(container, targetName, (Resource)resource)).map(this::replaceTokensInTemplate).map(this::checkForUnresolvedTemplateProperties).forEach(this::appendTemplate);
        }
    }

    private static List<String> getTargets(Container container) {
        ArrayList<String> targets = new ArrayList<String>();
        if (container.getTargetContainers().isEmpty()) {
            targets.add("");
        } else {
            targets.addAll(container.getTargetContainers());
        }
        return targets;
    }

    private Map<String, String> getTemplateTokens(Container container, String targetName) {
        HashMap<String, String> replaceTokens = new HashMap<String, String>(container.getCustomerProperties());
        if (container.isGeneric()) {
            replaceTokens.putAll(this.getGenericTokens(container.getSourceContainerName(), ""));
        } else if (container.isDirectory()) {
            replaceTokens.putAll(this.getHfsTokens(container.getSourceContainerName(), ""));
        } else {
            replaceTokens.putAll(this.getMvsTokens(container, targetName, ""));
        }
        if (container.getDeployType() != null) {
            replaceTokens.put("deployType", container.getDeployType());
        }
        if (container.getInputs() != null) {
            replaceTokens.put("inputsUrl", container.getInputs().getUrl());
        }
        return replaceTokens;
    }

    private Map<String, String> getTemplateTokens(Container container, String targetName, Resource resource) {
        HashMap<String, String> replaceTokens = new HashMap<String, String>();
        replaceTokens.putAll(resource.getCustomerProperties());
        replaceTokens.putAll(container.getCustomerProperties());
        if (container.isGeneric()) {
            replaceTokens.putAll(this.getGenericTokens(container.getSourceContainerName(), resource.getName()));
        } else if (container.isDirectory()) {
            replaceTokens.putAll(this.getHfsTokens(container.getSourceContainerName(), resource.getName()));
        } else {
            replaceTokens.putAll(this.getMvsTokens(container, targetName, resource.getName()));
        }
        if (resource.getDeployType() != null) {
            replaceTokens.put("deployType", resource.getDeployType());
        }
        if (resource.getInputs() != null) {
            replaceTokens.put("inputsUrl", resource.getInputs().getUrl());
        }
        return replaceTokens;
    }

    private Map<String, String> getMvsTokens(Container container, String targetName, String resourceName) {
        HashMap<String, String> tokens = new HashMap<String, String>();
        tokens.put("sourceDataset", container.getSourceContainerName());
        tokens.put("dataset", this.getTargetDataset(container, targetName));
        tokens.put("member", resourceName);
        return tokens;
    }

    private String getTargetDataset(Container container, String targetName) {
        return targetName.isEmpty() ? container.getSourceContainerName() : targetName;
    }

    private Map<String, String> getGenericTokens(String containerSrcName, String resourceName) {
        HashMap<String, String> tokens = new HashMap<String, String>();
        tokens.put("artifactGroup", containerSrcName);
        tokens.put("artifact", resourceName);
        return tokens;
    }

    private Map<String, String> getHfsTokens(String containerSrcName, String resourceName) {
        HashMap<String, String> tokens = new HashMap<String, String>();
        tokens.put("directory", containerSrcName);
        tokens.put("file", resourceName);
        return tokens;
    }

    private String replaceTokensInTemplate(Map<String, String> tokens) {
        String str = this.filterInputs.getTemplate();
        for (String key : tokens.keySet()) {
            str = str.replace("${" + key + "}", tokens.get(key));
        }
        return str;
    }

    private String checkForUnresolvedTemplateProperties(String templateText) {
        if (this.filterInputs.isIgnoreUnresolved()) {
            return templateText;
        }
        if (this.unresolvedPropertyExist(templateText)) {
            throw new IllegalArgumentException("Found unresolved property in template:" + templateText);
        }
        return templateText;
    }

    private boolean unresolvedPropertyExist(String text) {
        Pattern pattern = Pattern.compile(REGEX_FOR_PROPERTY);
        Matcher matcher = pattern.matcher(text);
        return matcher.find();
    }

    private boolean isLoopTypeMatched(Container container) {
        if (this.isContainerTypeCompatibleWithLoopType(container, this.filterInputs.getLoopType())) {
            return true;
        }
        System.out.println("  Not selected because LoopType=" + (Object)((Object)this.filterInputs.getLoopType()) + " is not applicable for container type");
        return false;
    }

    private boolean isDeletedMissingMemberToBeIncluded(Container container, String targetName, Resource resource) {
        if (this.filterInputs.getLoopType() != LoopType.DeletedMemberExcludingMissingMembers) {
            return true;
        }
        String resourceName = resource.getName();
        Optional<RollbackContainer> rollbackContainer = this.getRollbackContainer(container, targetName);
        if (!rollbackContainer.isPresent()) {
            System.out.println("  Not selected because " + targetName + "(" + resourceName + ") was  not a deleted member during version deployment");
            return false;
        }
        Map<String, RollbackResource> resourceMap = rollbackContainer.get().getResourceMap();
        RollbackResource rollbackResource = resourceMap.get(resourceName);
        if (rollbackResource.isMissing()) {
            System.out.println("  Not selected because " + targetName + "(" + resourceName + ") was a deleted missing member during version deployment");
            return false;
        }
        return true;
    }

    private boolean isResourceDeployActionMatched(Container container, String targetName, Resource resource) {
        if (this.filterInputs.getDeploymentAction() == null) {
            return true;
        }
        String resourceName = resource.getName();
        Optional<RollbackContainer> rollbackContainer = this.getRollbackContainer(container, targetName);
        if (!rollbackContainer.isPresent()) {
            System.out.println(" Not selected because " + targetName + "(" + resourceName + ") was not " + (Object)((Object)this.filterInputs.getDeploymentAction()) + " during version deployment");
            return false;
        }
        Map<String, RollbackResource> resourceMap = rollbackContainer.get().getResourceMap();
        if (!resourceMap.containsKey(resourceName)) {
            System.out.println(" Not selected because " + targetName + "(" + resourceName + ") was not " + (Object)((Object)this.filterInputs.getDeploymentAction()) + " during version deployment");
            return false;
        }
        return true;
    }

    private boolean isDeployActionMatched(Container container, String targetName) {
        if (this.filterInputs.getDeploymentAction() == null) {
            return true;
        }
        Optional<RollbackContainer> rollbackContainer = this.getRollbackContainer(container, targetName);
        if (!rollbackContainer.isPresent()) {
            System.out.println(" Not selected because container " + targetName + " is not " + (Object)((Object)this.filterInputs.getDeploymentAction()));
            return false;
        }
        return true;
    }

    private boolean isContainerDeployTypeMatched(Container container) {
        if (this.isMatched(this.filterInputs.getDeployType(), container.getDeployType())) {
            return true;
        }
        System.out.println("  Not selected because DeployType=" + this.filterInputs.getDeployType() + " does not match");
        return false;
    }

    private boolean isSourceMatched(Container container) {
        if (this.isMatched(this.filterInputs.getSourceContainer(), container.getSourceContainerName())) {
            return true;
        }
        System.out.println("  Not selected because SourceContainer=" + this.filterInputs.getSourceContainer() + " does not match");
        return false;
    }

    private boolean isTargetMatched(String targetName) {
        if (this.isMatched(this.filterInputs.getTargetDataset(), targetName)) {
            return true;
        }
        System.out.println("  Not selected because TargetContainer=" + this.filterInputs.getTargetDataset() + " does not match");
        return false;
    }

    private boolean isMemberMatched(Resource resource) {
        if (this.isMatched(this.filterInputs.getResource(), resource.getName())) {
            return true;
        }
        System.out.println("  Not selected because Resource=" + this.filterInputs.getResource() + " does not match");
        return false;
    }

    private boolean isResourceDeployTypeMatched(Resource resource) {
        if (this.isMatched(this.filterInputs.getDeployType(), resource.getDeployType())) {
            return true;
        }
        System.out.println("  Not selected because DeployType=" + this.filterInputs.getDeployType() + " does not match");
        return false;
    }

    private boolean areContainerCustomPropertiesMatched(Container container) {
        Map<String, String> customPropertiesFilter = this.filterInputs.getCustomProperties();
        for (Map.Entry<String, String> filterProperty : customPropertiesFilter.entrySet()) {
            if (this.isPropertyMatched(filterProperty, container.getCustomerProperties())) continue;
            System.out.println("  Not selected because CustomProperty " + filterProperty.getKey() + "=" + filterProperty.getValue() + " does not match");
            return false;
        }
        return true;
    }

    private boolean areResourceCustomPropertiesMatched(Container container, Resource resource) {
        HashMap<String, String> containerResourceProperties = new HashMap<String, String>();
        containerResourceProperties.putAll(resource.getCustomerProperties());
        containerResourceProperties.putAll(container.getCustomerProperties());
        Map<String, String> customPropertiesFilter = this.filterInputs.getCustomProperties();
        for (Map.Entry<String, String> filterProperty : customPropertiesFilter.entrySet()) {
            if (this.isPropertyMatched(filterProperty, containerResourceProperties)) continue;
            System.out.println("  Not selected because CustomProperty " + filterProperty.getKey() + "=" + filterProperty.getValue() + " does not match");
            return false;
        }
        return true;
    }

    private boolean isPropertyMatched(Map.Entry<String, String> filterProperty, Map<String, String> customProperties) {
        return customProperties.containsKey(filterProperty.getKey()) && this.isMatched(filterProperty.getValue(), customProperties.get(filterProperty.getKey()));
    }

    private boolean isContainerTypeCompatibleWithLoopType(Container container, LoopType loopType) {
        return container.isDeleted() && container.getType() == deletedLoopTypeToContainerTypeMap.get((Object)loopType) || !container.isDeleted() && container.getType() == loopTypeToContainerTypeMap.get((Object)loopType);
    }

    private boolean isMatched(String filter, String value) {
        if (filter.isEmpty()) {
            return true;
        }
        if (value == null) {
            return false;
        }
        return this.isFilterValueMatched(filter, value);
    }

    private boolean isFilterValueMatched(String filter, String value) {
        if (this.isFilterARegularExpression(filter)) {
            String pattern = this.extractPatternFromRegEx(filter);
            return value.matches(pattern);
        }
        return value.equals(filter);
    }

    private boolean isFilterARegularExpression(String inputFilter) {
        return inputFilter.matches(REGEX_FORMAT);
    }

    private String extractPatternFromRegEx(String regEx) {
        return regEx.substring(1, regEx.length() - 1);
    }

    private void appendTemplate(String template) {
        this.templateBuilder.append(template);
        ++this.count;
    }

    private Optional<RollbackContainer> getRollbackContainer(Container container, String targetName) {
        Predicate<RollbackContainer> isTargetMatchedWithRollbackContainer = rollbackContainer -> rollbackContainer.getName().equals(targetName) && rollbackContainer.getType() == container.getType();
        return this.rollbackContainers.stream().filter(isTargetMatchedWithRollbackContainer).findFirst();
    }

    public String getText() {
        return this.templateBuilder.toString();
    }

    public long getCount() {
        return this.count;
    }
}

