/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.xml.utils.deploy;

import com.ibm.urbancode.zos.xml.utils.common.XmlHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class ContainerMap {
    private static final String MAP_NODE_NAME = "map";
    private static final String SOURCE_CONTAINER_NODE_NAME = "sourceContainer";
    private static final String TARGET_CONTAINER_NODE_NAME = "targetContainer";
    private static final String NAME_ATTRIBUTE = "name";
    private final Map<String, List<String>> sourceTargetMap = new HashMap<String, List<String>>();
    private String sourceName;
    private List<String> targets = new ArrayList<String>();

    private ContainerMap() {
    }

    public static ContainerMap from(String filePath) throws IOException, XMLStreamException {
        ContainerMap containerMap = new ContainerMap();
        try (InputStream inputStream = Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);){
            containerMap.parse(inputStream);
        }
        return containerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputStream inputStream) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newFactory();
        try (XMLStreamReader xmlStreamReader = null;){
            xmlStreamReader = inputFactory.createXMLStreamReader(inputStream, XmlHelper.getFileEncoding());
            while (xmlStreamReader.hasNext()) {
                int next = xmlStreamReader.next();
                if (next == 1) {
                    this.processStartElement(xmlStreamReader);
                    continue;
                }
                if (next != 2) continue;
                this.processEndElement(xmlStreamReader);
            }
        }
    }

    private void processStartElement(XMLStreamReader xmlStreamReader) {
        String tagName = xmlStreamReader.getLocalName().trim();
        if (tagName.equalsIgnoreCase(SOURCE_CONTAINER_NODE_NAME)) {
            this.sourceName = XmlHelper.getAttributeValue(xmlStreamReader, NAME_ATTRIBUTE);
        } else if (tagName.equalsIgnoreCase(TARGET_CONTAINER_NODE_NAME)) {
            this.targets.add(XmlHelper.getAttributeValue(xmlStreamReader, NAME_ATTRIBUTE));
        }
    }

    private void processEndElement(XMLStreamReader xmlStreamReader) {
        String tagName = xmlStreamReader.getLocalName().trim();
        if (tagName.equalsIgnoreCase(MAP_NODE_NAME)) {
            this.sourceTargetMap.put(this.sourceName, this.targets);
            this.sourceName = null;
            this.targets = new ArrayList<String>();
        }
    }

    public int size() {
        return this.sourceTargetMap.size();
    }

    public List<String> getTargets(String source) {
        if (!this.sourceTargetMap.containsKey(source)) {
            throw new IllegalArgumentException(source + " not found in Container Mapping.");
        }
        return this.sourceTargetMap.get(source);
    }
}

