/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit.manifest;

import com.ibm.urbancode.zos.xml.utils.common.CopyType;
import com.ibm.urbancode.zos.xml.utils.deploy.Container;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class CpCommand {
    private static final String LOAD = "LOAD";
    private static final String DBRM = "DBRM";
    private static final String OBJ = "OBJ";
    private static final String ASTERISK = "*";
    private static final Map<CopyType, String> copyTypeToCpFlagMap = new HashMap<CopyType, String>(){
        {
            this.put(CopyType.EXEC, "-XI");
            this.put(CopyType.BINARY, "-B");
            this.put(CopyType.TEXT, "-T");
        }
    };

    private CpCommand() {
    }

    public static List<String> generateCommands(PackageManifest manifest, Map<String, String> sourceTempDsnMap) {
        return manifest.getContainers().stream().filter(container -> !container.isDeleted()).filter(Container::isDataset).map(container -> CpCommand.getCpCommand(container, sourceTempDsnMap)).collect(Collectors.toList());
    }

    private static String getCpCommand(Container container, Map<String, String> sourceTempDsnMap) {
        CopyType copyType = CpCommand.determineCopyType(container);
        String cpFlag = copyTypeToCpFlagMap.get(copyType);
        String sourceFile = CpCommand.getSourceFile(container);
        String targetDataset = sourceTempDsnMap.get(container.getSourceContainerName());
        return String.format("cp %s %s \"//'%s'\"", cpFlag, sourceFile, targetDataset);
    }

    private static CopyType determineCopyType(Container container) {
        CopyType copyType = container.getCopyType();
        if (copyType != null) {
            return copyType;
        }
        String deployType = container.getDeployType();
        if (deployType == null) {
            throw new RuntimeException(" Attributes copyType (or) deployType not found for container " + container.getSourceContainerName());
        }
        copyType = CpCommand.determineCopyTypeFromDeployType(deployType);
        return copyType;
    }

    private static CopyType determineCopyTypeFromDeployType(String deployType) {
        if ((deployType = deployType.toUpperCase()).contains(LOAD)) {
            return CopyType.EXEC;
        }
        if (deployType.contains(DBRM) || deployType.contains(OBJ)) {
            return CopyType.BINARY;
        }
        return CopyType.TEXT;
    }

    private static String getSourceFile(Container container) {
        if (container.isSequential()) {
            return container.getSourceContainerName();
        }
        return container.getSourceContainerName() + File.separator + ASTERISK;
    }
}

