/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.restore.backup;

import com.ibm.jzos.ZFileException;
import com.ibm.team.enterprise.deployment.dataset.record.DatasetRecord;
import com.ibm.team.enterprise.deployment.dataset.record.DatasetRecordsWriter;
import com.ibm.team.enterprise.deployment.dataset.record.DeploymentRecord;
import com.ibm.team.enterprise.deployment.dataset.record.PdsUpdateRecordBuilder;
import com.ibm.team.enterprise.deployment.dataset.record.SeqUpdateRecordBuilder;
import com.ibm.team.enterprise.deployment.dataset.record.XmitReceiveRecord;
import com.ibm.team.enterprise.deployment.toolkit.manifest.ProcessExecutor;
import com.ibm.urbancode.zos.common.util.AgentInstalledProperties;
import com.ibm.urbancode.zos.common.util.Console;
import com.ibm.urbancode.zos.common.util.DeploymentFilesHelper;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.common.util.PluginFilesHelper;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.dataset.util.TempDsnNameHelper;
import com.ibm.urbancode.zos.rexx.RexxExecutor;
import com.ibm.urbancode.zos.xml.utils.common.ContainerType;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackContainer;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackManifest;
import com.urbancode.air.plugin.command.restore.backup.DatasetMapping;
import com.urbancode.air.plugin.command.restore.backup.RestoreBackupDatasetsInputs;
import com.urbancode.air.plugin.command.restore.backup.RestoreDatasetMapper;
import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.air.plugin.exceptions.MissingInputException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;

public class RestoreBackupDatasets {
    private static final String COMMA = ",";
    private static final String BIN_EXTENSION = ".bin";
    private final Properties inputProperties;
    private RestoreBackupDatasetsInputs pluginInputs;
    private String versionWorkDirectory = null;

    public RestoreBackupDatasets(Properties inputProperties, Properties ignoredOutputProperties) {
        this.inputProperties = inputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws Exception {
        int exitCode = 0;
        try {
            this.pluginInputs = RestoreBackupDatasetsInputs.getValidatedInputs(this.inputProperties);
            this.versionWorkDirectory = DeploymentFilesHelper.getVersionDirPathInWorkingDir(this.pluginInputs.getVersionName(), this.pluginInputs.getResourceId());
            this.setupVersionWorkDirectory();
            List<RollbackContainer> backupDatasets = this.getBackupDatasetsFromRollbackManifest();
            if (backupDatasets.isEmpty()) {
                System.out.println(" [Warning] No backup of datasets found. This might be due to artifacts being created during deployment. No artifacts are restored.");
                int n = exitCode;
                return n;
            }
            this.copyBackupZipToVersionWorkDirectory();
            RestoreBackupDatasets.printBackupDatasetsToConsole(backupDatasets);
            List<DatasetMapping> datasetMappings = this.getDatasetMapping(backupDatasets);
            if (datasetMappings.isEmpty()) {
                throw new InvalidInputException("No mapping found for the backup datasets");
            }
            if (!this.pluginInputs.isCreateDatasetAllowed()) {
                this.checkIfTargetDatasetsExist(datasetMappings);
            }
            ProcessExecutor.extractUsingPaxCommand(this.versionWorkDirectory, "backup.zip");
            this.printRestoreDatasetInfoToConsole(datasetMappings);
            this.xmitSourceBinFilesToTempDatasets(datasetMappings);
            this.copyTempDatasetsToTargetDatasets(datasetMappings);
        }
        catch (InvalidInputException | MissingInputException exception) {
            System.out.println(" [Error] " + exception.getMessage());
            exitCode = 1;
        }
        finally {
            if (this.versionWorkDirectory != null) {
                FileHelper.cleanDirectory(this.versionWorkDirectory);
            }
        }
        return exitCode;
    }

    private void setupVersionWorkDirectory() throws IOException {
        if (FileHelper.isDirectoryExist(this.versionWorkDirectory)) {
            this.deleteWorkDirectory();
        }
        FileHelper.createDirectory(this.versionWorkDirectory);
    }

    private void deleteWorkDirectory() throws IOException {
        Console.printActionTitle("Deleting version working directory - " + this.versionWorkDirectory);
        FileHelper.cleanDirectory(this.versionWorkDirectory);
    }

    private void copyBackupZipToVersionWorkDirectory() throws IOException {
        String versionDeployBasePath = this.getVersionDeployBasePath();
        String backupZipFilePath = this.getBackupZipFilePath(versionDeployBasePath);
        String backupFilePathInWorkDir = this.versionWorkDirectory + File.separator + "backup.zip";
        FileHelper.copyFile(backupZipFilePath, backupFilePathInWorkDir);
    }

    private String getVersionDeployBasePath() {
        String versionDeployBasePath = DeploymentFilesHelper.getVersionDeployBasePath(this.pluginInputs.getDeployBasePath(), this.pluginInputs.getResourceId(), this.pluginInputs.getComponentName(), this.pluginInputs.getVersionName());
        if (FileHelper.isDirectoryNotExist(versionDeployBasePath)) {
            throw new MissingInputException("Version deploy base path " + versionDeployBasePath + " does not exist. Restore step runs for only deployed component version.");
        }
        return versionDeployBasePath;
    }

    private String getBackupZipFilePath(String versionDeployBasePath) {
        String backupZipFilePath = versionDeployBasePath + File.separator + "backup.zip";
        if (FileHelper.isFileNotExist(backupZipFilePath)) {
            throw new MissingInputException("Backup File " + backupZipFilePath + " does not exist. Restore step runs for only deployed component version with backup enabled during deployment.");
        }
        return backupZipFilePath;
    }

    private List<RollbackContainer> getBackupDatasetsFromRollbackManifest() throws XMLStreamException, IOException {
        ArrayList<RollbackContainer> backupDatasets = new ArrayList<RollbackContainer>();
        String rollbackManifestPath = this.getVersionDeployBasePath() + File.separator + "rollbackManifest.xml";
        RollbackManifest rollbackManifest = RollbackManifest.from((String)rollbackManifestPath);
        List<RollbackContainer> deletedDatasetContainers = this.getDatasetContainers(rollbackManifest.getDeletedContainers());
        List<RollbackContainer> updatedDatasetContainers = this.getDatasetContainers(rollbackManifest.getUpdatedContainers());
        backupDatasets.addAll(deletedDatasetContainers);
        backupDatasets.addAll(updatedDatasetContainers);
        return backupDatasets;
    }

    private List<RollbackContainer> getDatasetContainers(List<RollbackContainer> containers) {
        return containers.stream().filter(container -> container.getType() == ContainerType.PDS || container.getType() == ContainerType.SEQUENTIAL).filter(container -> !container.isMissing()).collect(Collectors.toList());
    }

    private static void printBackupDatasetsToConsole(List<RollbackContainer> backupDatasets) {
        Console.printActionTitle("Datasets present in backup - ");
        for (RollbackContainer container : backupDatasets) {
            Console.printProcessOutput(container.getName());
        }
        System.out.println();
    }

    private List<DatasetMapping> getDatasetMapping(List<RollbackContainer> backupDatasets) {
        RestoreDatasetMapper datasetMapper = RestoreDatasetMapper.from(this.pluginInputs.getDatasetMapping());
        Map<String, String> mappingWithoutWildCard = datasetMapper.getSrcTargetMapWithoutRegEx();
        Map<String, String> mappingWithWildcard = datasetMapper.getSrcTargetMapWithRegEx();
        ArrayList<DatasetMapping> datasetMappings = new ArrayList<DatasetMapping>();
        for (RollbackContainer source : backupDatasets) {
            String tempXmitDsn = TempDsnNameHelper.getXmitDsnName(this.pluginInputs.getTempDsnPrefix());
            String dataset = source.getName();
            if (mappingWithoutWildCard.containsKey(dataset)) {
                datasetMappings.add(new DatasetMapping(source, mappingWithoutWildCard.get(dataset), tempXmitDsn));
                continue;
            }
            Optional<String> target = this.getMappedTarget(dataset, mappingWithWildcard);
            if (target.isPresent()) {
                datasetMappings.add(new DatasetMapping(source, target.get(), tempXmitDsn));
                continue;
            }
            Console.printProcessOutput("Skipping restore for dataset " + dataset + " as target mapping not found.");
        }
        return datasetMappings;
    }

    private void checkIfTargetDatasetsExist(List<DatasetMapping> datasetMappings) throws ZFileException {
        List<String> targetDatasets = datasetMappings.stream().map(DatasetMapping::getTargetDataset).collect(Collectors.toList());
        List<String> missingDatasets = DatasetHelper.getMissingDatasets(targetDatasets);
        if (!missingDatasets.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder("Restore failed because below target datasets are not found and Allow Creating Data Set is set to false.");
            for (String dataset : missingDatasets) {
                errorMessage.append(System.lineSeparator()).append(dataset);
            }
            throw new InvalidInputException(errorMessage.toString());
        }
    }

    private void printRestoreDatasetInfoToConsole(List<DatasetMapping> datasetMappings) {
        System.out.println();
        for (DatasetMapping datasetMapping : datasetMappings) {
            Console.printProcessOutput("Restoring dataset " + datasetMapping.getSource().getName() + " to " + datasetMapping.getTargetDataset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void xmitSourceBinFilesToTempDatasets(List<DatasetMapping> datasetMappings) throws Exception {
        String xmitInputDataset = this.createInputDatasetForXmitProgram(datasetMappings);
        String rexxArguments = this.getXmitReceiverRexxArguments(xmitInputDataset);
        try {
            RexxExecutor rexxExecutor = new RexxExecutor(this.pluginInputs.getTempDsnPrefix(), this.pluginInputs.getIspfGatewayBinariesPath());
            rexxExecutor.execute(PluginFilesHelper.getXmitReceiverRexxFilePath(), rexxArguments);
        }
        finally {
            DatasetHelper.deleteDataset(xmitInputDataset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTempDatasetsToTargetDatasets(List<DatasetMapping> datasetMappings) throws Exception {
        String tempActionDataset = TempDsnNameHelper.getActionDsnName(this.pluginInputs.getTempDsnPrefix());
        try {
            List<DatasetRecord> actionRecords = this.createActionRecords(datasetMappings);
            DatasetRecordsWriter.write(actionRecords, tempActionDataset);
            RexxExecutor rexxExecutor = new RexxExecutor(this.pluginInputs.getTempDsnPrefix(), this.pluginInputs.getIspfGatewayBinariesPath());
            rexxExecutor.execute(PluginFilesHelper.getDeploymentV2RexxFilePath(), tempActionDataset);
        }
        finally {
            DatasetHelper.deleteDataset(tempActionDataset);
            for (DatasetMapping datasetMapping : datasetMappings) {
                DatasetHelper.deleteDataset(datasetMapping.getTempXmitDataset());
            }
        }
    }

    private List<DatasetRecord> createActionRecords(List<DatasetMapping> datasetMappings) {
        ArrayList<DatasetRecord> datasetRecords = new ArrayList<DatasetRecord>();
        for (DatasetMapping datasetMapping : datasetMappings) {
            DeploymentRecord datasetRecord;
            if (datasetMapping.getSource().getType() == ContainerType.PDS) {
                datasetRecord = new PdsUpdateRecordBuilder().withSourceDsn(datasetMapping.getTempXmitDataset()).withTargetDsn(datasetMapping.getTargetDataset()).build();
                datasetRecords.add(datasetRecord);
                continue;
            }
            if (datasetMapping.getSource().getType() != ContainerType.SEQUENTIAL) continue;
            datasetRecord = new SeqUpdateRecordBuilder().withSourceDsn(datasetMapping.getTempXmitDataset()).withTargetDsn(datasetMapping.getTargetDataset()).build();
            datasetRecords.add(datasetRecord);
        }
        return datasetRecords;
    }

    private Optional<String> getMappedTarget(String dataset, Map<String, String> mappingWithWildcard) {
        for (String sourceWithRegEx : mappingWithWildcard.keySet()) {
            if (!dataset.matches(sourceWithRegEx)) continue;
            return Optional.of(mappingWithWildcard.get(sourceWithRegEx));
        }
        return Optional.empty();
    }

    private String createInputDatasetForXmitProgram(List<DatasetMapping> datasetMappings) throws IOException {
        ArrayList<DatasetRecord> datasetRecords = new ArrayList<DatasetRecord>();
        for (DatasetMapping datasetMapping : datasetMappings) {
            String xmitBinFileName = datasetMapping.getSource().getName() + BIN_EXTENSION;
            String xmitBinFilePath = this.versionWorkDirectory + File.separator + xmitBinFileName;
            long fileSizeInBytes = FileHelper.getFileSizeInBytes(xmitBinFilePath);
            XmitReceiveRecord xmitReceiveRecord = new XmitReceiveRecord(xmitBinFileName, fileSizeInBytes, datasetMapping.getTempXmitDataset());
            datasetRecords.add(xmitReceiveRecord);
        }
        String xmitInputDataset = TempDsnNameHelper.getXmitProgramInputDsnName(this.pluginInputs.getTempDsnPrefix());
        DatasetRecordsWriter.write(datasetRecords, xmitInputDataset);
        return xmitInputDataset;
    }

    private String getXmitReceiverRexxArguments(String xmitInputFile) {
        AgentInstalledProperties agentInstalledProperties = new AgentInstalledProperties();
        return this.versionWorkDirectory + COMMA + xmitInputFile + COMMA + agentInstalledProperties.getSysoutClass() + COMMA + agentInstalledProperties.getTempUnit() + COMMA + agentInstalledProperties.getTempVolser();
    }
}

