/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.versions.cleanup;

import com.ibm.urbancode.zos.common.util.DeploymentFilesHelper;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.air.plugin.inputs.InputsValidator;
import java.util.Properties;

class PluginInputs {
    public static final String IS_DRY_RUN = "isDryRun";
    public static final String RESOURCE_ID = "resourceId";
    public static final String APPLICATION_NAME = "applicationName";
    public static final String ENVIRONMENT_NAME = "environmentName";
    public static final String COMPONENT_NAME = "componentName";
    public static final String DEPLOY_BASE_PATH = "deployBasePath";
    private final boolean isDryRun;
    private final String resourceId;
    private final String applicationName;
    private final String environmentName;
    private final String componentName;
    private final String deployBasePath;
    private final String componentDeployPath;

    private PluginInputs(Properties inputProperties) {
        this.isDryRun = Boolean.parseBoolean(inputProperties.getProperty(IS_DRY_RUN));
        this.resourceId = inputProperties.getProperty(RESOURCE_ID);
        this.applicationName = inputProperties.getProperty(APPLICATION_NAME);
        this.environmentName = inputProperties.getProperty(ENVIRONMENT_NAME);
        this.componentName = inputProperties.getProperty(COMPONENT_NAME);
        this.deployBasePath = inputProperties.getProperty(DEPLOY_BASE_PATH);
        this.componentDeployPath = DeploymentFilesHelper.getComponentPathInDeployBasePath(this.deployBasePath, this.resourceId, this.componentName);
    }

    public static PluginInputs getValidatedInputs(Properties inputProperties) {
        PluginInputs pluginInputs = new PluginInputs(inputProperties);
        pluginInputs.validateInputs();
        return pluginInputs;
    }

    private void validateInputs() {
        InputsValidator.checkIfEmpty(this.applicationName, "Application name");
        InputsValidator.checkIfEmpty(this.environmentName, "Environment name");
        InputsValidator.checkIfEmpty(this.componentName, "Component name");
        InputsValidator.checkIfEmpty(this.deployBasePath, "Deploy base path");
        if (FileHelper.isDirectoryNotExist(this.componentDeployPath)) {
            throw new InvalidInputException("Component directory " + this.componentDeployPath + " does not exist.");
        }
    }

    public boolean isDryRun() {
        return this.isDryRun;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getDeployBasePath() {
        return this.deployBasePath;
    }

    public String getComponentDeployPath() {
        return this.componentDeployPath;
    }
}

