/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.common.util;

import com.ibm.urbancode.zos.common.util.SystemEnvironmentVariableNotFoundException;
import java.util.Map;

public class SystemEnv {
    private static final Map<String, String> systemEnvironmentVariables = System.getenv();
    private static final String PLUGIN_HOME = "PLUGIN_HOME";
    private static final String BUZ_TOOLKIT_HOME = "BUZ_TOOLKIT_HOME";
    private static final String AGENT_BIN_HOME = "AGENT_BIN_HOME";
    private static final String AGENT_HOME = "AGENT_HOME";

    public static String getPluginHome() {
        return SystemEnv.getEnvironmentVariable(PLUGIN_HOME);
    }

    public static String getBuzToolkitHome() {
        return SystemEnv.getEnvironmentVariable(BUZ_TOOLKIT_HOME);
    }

    public static String getAgentBinHome() {
        return SystemEnv.getEnvironmentVariable(AGENT_BIN_HOME);
    }

    public static String getAgentHome() {
        return SystemEnv.getEnvironmentVariable(AGENT_HOME);
    }

    private static String getEnvironmentVariable(String variableName) {
        if (!systemEnvironmentVariables.containsKey(variableName)) {
            throw new SystemEnvironmentVariableNotFoundException("Environment Variable " + variableName + " not found.");
        }
        return systemEnvironmentVariables.get(variableName).trim();
    }
}

