/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.rexx;

import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;
import com.ibm.urbancode.zos.common.util.FileHelper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

final class RexxFileToDatasetConvertor {
    private static final int DATASET_LRECL = 144;

    private RexxFileToDatasetConvertor() {
    }

    public static void convert(String filePath, String dataset) throws IOException {
        int spaceInTracks = FileHelper.getFileSizeInTracks(filePath);
        RexxFileToDatasetConvertor.createDataset(dataset, spaceInTracks);
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(filePath));){
            RexxFileToDatasetConvertor.writeRexxLinesToDataset(bufferedReader, dataset);
        }
    }

    private static void createDataset(String dataset, int spaceInTracks) {
        String fullyQualifiedDsn = ZFile.getFullyQualifiedDSN((String)dataset, (boolean)true);
        String tempDD = ZFile.allocDummyDDName();
        ZFile.bpxwdyn((String)("alloc fi(" + tempDD + ") da(" + fullyQualifiedDsn + ") dsorg(ps) lrecl(" + 144 + ") recfm(v,b) tracks space(" + spaceInTracks + "," + spaceInTracks + ") blksize(" + 1440 + ") reuse new catalog msg(wtp)"));
        ZFile.bpxwdyn((String)("free fi(" + tempDD + ") msg(wtp)"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRexxLinesToDataset(BufferedReader bufferedReader, String dataset) throws IOException {
        try (RecordWriter recordWriter = RecordWriter.newWriter((String)ZFile.getSlashSlashQuotedDSN((String)dataset, (boolean)true), (int)1);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                byte[] bytes = line.getBytes(ZUtil.getDefaultPlatformEncoding());
                recordWriter.write(bytes, 0, bytes.length);
            }
        }
    }
}

