/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.delete.datasets;

import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFileException;
import com.ibm.team.enterprise.deployment.dataset.record.DatasetRecord;
import com.ibm.team.enterprise.deployment.dataset.record.DatasetRecordsWriter;
import com.ibm.urbancode.zos.common.util.PluginFilesHelper;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.dataset.util.TempDsnNameHelper;
import com.ibm.urbancode.zos.rexx.RexxExecutor;
import com.urbancode.air.plugin.command.delete.datasets.DeleteDatasetInputs;
import com.urbancode.air.plugin.command.delete.datasets.DeleteRecordsGenerator;
import java.util.List;
import java.util.Properties;

public class DeleteDataset {
    private int exitCode = 0;
    private final Properties inputProperties;

    public DeleteDataset(Properties inputProperties, Properties ignoredOutputProperties) {
        this.inputProperties = inputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int execute() {
        block7: {
            String tempActionDsn = null;
            try {
                DeleteDatasetInputs pluginInput = new DeleteDatasetInputs(this.inputProperties);
                pluginInput.validateInputs();
                List<DatasetRecord> deleteRecords = DeleteRecordsGenerator.generate(pluginInput);
                tempActionDsn = TempDsnNameHelper.getActionDsnName(pluginInput.getDsnPrefix());
                DatasetRecordsWriter.write(deleteRecords, tempActionDsn);
                RexxExecutor rexxExecutor = new RexxExecutor(pluginInput.getDsnPrefix(), pluginInput.getIspfGatewayBinariesPath());
                rexxExecutor.execute(PluginFilesHelper.getDeploymentV2RexxFilePath(), tempActionDsn);
                this.deleteDataset(tempActionDsn);
            }
            catch (RuntimeException runtimeException) {
                this.handleRuntimeExceptions(runtimeException);
                this.exitCode = 1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.exitCode = 1;
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.deleteDataset(tempActionDsn);
            }
        }
        return this.exitCode;
    }

    private void handleRuntimeExceptions(Exception exception) {
        if (exception instanceof RcException) {
            exception.printStackTrace();
        } else {
            System.out.println(" [Error] " + exception.getMessage());
        }
    }

    private void deleteDataset(String dataset) {
        try {
            DatasetHelper.deleteDataset(dataset);
        }
        catch (ZFileException e) {
            e.printStackTrace();
            this.exitCode = 1;
        }
    }
}

