/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.delete.datasets;

import com.ibm.jzos.ZFile;
import com.ibm.team.enterprise.deployment.dataset.record.DatasetRecord;
import com.ibm.team.enterprise.deployment.dataset.record.DeploymentRecord;
import com.ibm.team.enterprise.deployment.dataset.record.PdsDeleteRecordBuilder;
import com.ibm.team.enterprise.deployment.dataset.record.SeqDeleteRecordBuilder;
import com.urbancode.air.plugin.command.delete.datasets.DeleteDatasetInputs;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

class DeleteRecordsGenerator {
    private static final String SINGLE_QUOTE = "'";
    private final List<DatasetRecord> deleteRecords = new ArrayList<DatasetRecord>();
    private final String datasets;
    private final String members;

    private DeleteRecordsGenerator(DeleteDatasetInputs inputs) {
        this.datasets = inputs.getDatasets();
        this.members = inputs.getMembers();
    }

    public static List<DatasetRecord> generate(DeleteDatasetInputs inputs) throws Exception {
        DeleteRecordsGenerator generator = new DeleteRecordsGenerator(inputs);
        generator.load();
        return generator.deleteRecords;
    }

    private void load() throws Exception {
        if (this.members.isEmpty()) {
            this.loadRecordsForEachDataset(this.datasets);
        } else {
            this.loadRecordsForDatasetForEachMember(this.datasets, this.members);
        }
    }

    private void loadRecordsForEachDataset(String datasets) throws Exception {
        try (BufferedReader reader = new BufferedReader(new StringReader(datasets));){
            String datasetLine;
            while ((datasetLine = reader.readLine()) != null) {
                if (datasetLine.trim().isEmpty()) continue;
                String qualifiedDataset = this.getFullyQualifiedDataset(datasetLine.trim());
                this.loadRecord(qualifiedDataset);
            }
        }
    }

    private void loadRecord(String qualifiedDataset) {
        if (this.isPdsWithMember(qualifiedDataset)) {
            int indexOfOpenParentheses = qualifiedDataset.indexOf("(");
            String dataset = qualifiedDataset.substring(0, indexOfOpenParentheses);
            String member = qualifiedDataset.substring(indexOfOpenParentheses + 1, qualifiedDataset.length() - 1);
            DeploymentRecord record = new PdsDeleteRecordBuilder().withTargetDsn(dataset).withMember(member.trim()).build();
            this.deleteRecords.add(record);
        } else {
            DeploymentRecord record = new SeqDeleteRecordBuilder().withTargetDsn(qualifiedDataset).build();
            this.deleteRecords.add(record);
        }
    }

    private boolean isPdsWithMember(String dataset) {
        return Pattern.matches(".+\\(.+\\)$", dataset);
    }

    private String getFullyQualifiedDataset(String inputDataset) {
        String datasetName = inputDataset.contains(SINGLE_QUOTE) ? this.removeSingleQuotes(inputDataset) : ZFile.getFullyQualifiedDSN((String)inputDataset);
        return datasetName;
    }

    private String removeSingleQuotes(String dataset) {
        return dataset.replace(SINGLE_QUOTE, "");
    }

    private void loadRecordsForDatasetForEachMember(String dataset, String membersList) throws Exception {
        String qualifiedDataset = this.getFullyQualifiedDataset(dataset);
        try (BufferedReader reader = new BufferedReader(new StringReader(membersList));){
            String member;
            while ((member = reader.readLine()) != null) {
                if (member.trim().isEmpty()) continue;
                DeploymentRecord pdsMemberDeleteRecord = new PdsDeleteRecordBuilder().withTargetDsn(qualifiedDataset).withMember(member.trim()).build();
                this.deleteRecords.add(pdsMemberDeleteRecord);
            }
        }
    }
}

