/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.jcl.submit;

import com.ibm.jzos.ZUtil;
import com.ibm.urbancode.zos.common.util.EmptyFileException;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.dataset.util.DataSetReader;
import com.urbancode.air.plugin.command.jcl.common.jes.JESJob;
import com.urbancode.air.plugin.command.jcl.common.jes.JobUtil;
import com.urbancode.air.plugin.command.jcl.submit.InputJcl;
import com.urbancode.air.plugin.command.jcl.submit.JclFormatter;
import com.urbancode.air.plugin.command.jcl.submit.JclTokenReplacer;
import com.urbancode.air.plugin.command.jcl.submit.JobCard;
import com.urbancode.air.plugin.command.jcl.submit.JobFailureException;
import com.urbancode.air.plugin.command.jcl.submit.PaginationPrintStream;
import com.urbancode.air.plugin.command.jcl.submit.SubmitJobInputs;
import com.urbancode.air.plugin.command.jcl.submit.TokensUtil;
import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.air.plugin.exceptions.MissingInputException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class SubmitJob {
    private final Properties inputProperties;
    private final Properties outputProperties;

    public SubmitJob(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        try {
            SubmitJobInputs pluginInputs = SubmitJobInputs.getValidatedInputs(this.inputProperties);
            if (pluginInputs.isOutputPaginationEnabled()) {
                System.setOut(new PaginationPrintStream(pluginInputs.getStdOutFileDirectory()));
            }
            JobUtil jobUtil = JobUtil.from(pluginInputs.getJmonInputs(), pluginInputs.isWaitForJob());
            List<InputJcl> jcls = this.getJcls(pluginInputs);
            List<String> explicitTokenGroups = TokensUtil.loadTokenGroupsIntoList(pluginInputs.getJclTokenGroups());
            if (explicitTokenGroups.isEmpty()) {
                explicitTokenGroups.add("");
            }
            if (jcls.size() > 1 && explicitTokenGroups.size() > 1) {
                throw new InvalidInputException("Replace Token Sets For Each Job must be used with a single JCL.");
            }
            if (jcls.size() > 1) {
                System.out.println("=================================== Total " + jcls.size() + " jobs to submit ============================================================");
            } else if (explicitTokenGroups.size() > 1) {
                System.out.println("=================================== Total " + explicitTokenGroups.size() + " jobs to submit ============================================================");
            }
            if (pluginInputs.isOutputPaginationEnabled()) {
                System.out.println("                    [ Please look at next page for job outputs. You can switch off pagination in this plugin step. ]  ");
            }
            int jobCount = 0;
            int failedJobCount = 0;
            for (String tokenGroup : explicitTokenGroups) {
                String mergedTokens = pluginInputs.getExplicitTokens() + "\n" + tokenGroup;
                mergedTokens = mergedTokens.trim();
                for (InputJcl inputJcl : jcls) {
                    boolean success;
                    String jcl = inputJcl.getValue();
                    ++jobCount;
                    if (explicitTokenGroups.size() > 1 || jcls.size() > 1) {
                        System.out.println("=================================== Submitting job" + jobCount + " : " + inputJcl.getSource() + " ==================================================================");
                    } else {
                        System.out.println("=================================== Submitting job : " + inputJcl.getSource() + " ==================================================================");
                    }
                    if (!mergedTokens.isEmpty()) {
                        jcl = this.replaceTokensInJcl(jcl, mergedTokens);
                    }
                    if (JobCard.hasNoJobStatement(jcl)) {
                        System.out.println(" [Info] No JOB statement found in the JCL.");
                        jcl = JobCard.update(jcl, pluginInputs.getJobCard());
                    }
                    if (jobUtil.isPassTicketAuthentication()) {
                        jobUtil.setPasswordUsingPassTicket();
                    }
                    if (success = this.submitOneJob(jobUtil, inputJcl.getSource(), jcl, pluginInputs.isWaitForJob(), jobCount)) continue;
                    ++failedJobCount;
                    if (!pluginInputs.isStopOnFail()) continue;
                    throw new JobFailureException("Step failed because Stop On Fail is turned on and job" + jobCount + " : " + inputJcl.getSource() + " failed.");
                }
            }
            System.out.println(jobCount + " job(s) completed. ");
            this.outputProperties.setProperty("jobCount", Integer.toString(jobCount));
            if (failedJobCount > 0) {
                throw new JobFailureException(failedJobCount + " job(s) failed. ");
            }
            return 0;
        }
        catch (EmptyFileException | JobFailureException | InvalidInputException | MissingInputException | FileNotFoundException runtimeException) {
            System.out.println(" [Error] " + runtimeException.getMessage());
        }
        catch (Exception e) {
            System.out.println("Error Running Job: " + e.getMessage());
            e.printStackTrace();
        }
        return 1;
    }

    private List<InputJcl> getJcls(SubmitJobInputs pluginInputs) throws IOException {
        ArrayList<InputJcl> jcls = new ArrayList<InputJcl>();
        if (!pluginInputs.getMvsFilename().isEmpty()) {
            DataSetReader dsr = new DataSetReader(pluginInputs.getMvsFilename());
            for (Map.Entry<String, String> jclEntry : dsr.getDataSets().entrySet()) {
                jcls.add(new InputJcl(jclEntry.getKey(), jclEntry.getValue()));
            }
        } else if (!pluginInputs.getUssFilename().isEmpty()) {
            String fileData = FileHelper.getFileContent(pluginInputs.getUssFilename());
            if (fileData.trim().isEmpty()) {
                throw new EmptyFileException(" File " + pluginInputs.getUssFilename() + " is empty");
            }
            jcls.add(new InputJcl(pluginInputs.getUssFilename(), fileData));
        } else if (!pluginInputs.getJclString().isEmpty()) {
            jcls.add(new InputJcl("Step JCL", pluginInputs.getJclString()));
        }
        return jcls;
    }

    private boolean submitOneJob(JobUtil jobUtil, String sourceOfJcl, String jcl, boolean waitForJob, int jobCount) throws Exception {
        String jobId = jobUtil.submitJob(jcl);
        this.outputProperties.setProperty("JobId" + jobCount, jobId);
        this.outputProperties.setProperty("JobJCL" + jobCount, sourceOfJcl);
        this.outputProperties.setProperty("JobId", jobId);
        this.outputProperties.setProperty("JobJCL", sourceOfJcl);
        Thread.sleep(500L);
        if (jobUtil.isJclError(jobId)) {
            JESJob jesJob = jobUtil.getJob(jobId, true);
            this.outputProperties.setProperty("JobReturnCode", jesJob.getReturnCode() == null ? "" : jesJob.getReturnCode());
            this.outputProperties.setProperty("JobReturnInfo", jesJob.getReturnInfo() == null ? "" : jesJob.getReturnInfo());
            this.outputProperties.setProperty("JobReturnStatus", jesJob.getReturnStatus() == null ? "" : jesJob.getReturnStatus());
            jobUtil.disconnect();
            return false;
        }
        if (waitForJob) {
            boolean success = jobUtil.waitForJob(jobId);
            jobUtil.printLog(jobId);
            JESJob jesJob = jobUtil.getJob(jobId, true);
            this.outputProperties.setProperty("JobReturnCode" + jobCount, jesJob.getReturnCode() == null ? "" : jesJob.getReturnCode());
            this.outputProperties.setProperty("JobReturnInfo" + jobCount, jesJob.getReturnInfo() == null ? "" : jesJob.getReturnInfo());
            this.outputProperties.setProperty("JobReturnStatus" + jobCount, jesJob.getReturnStatus() == null ? "" : jesJob.getReturnStatus());
            this.outputProperties.setProperty("JobReturnCode", jesJob.getReturnCode() == null ? "" : jesJob.getReturnCode());
            this.outputProperties.setProperty("JobReturnInfo", jesJob.getReturnInfo() == null ? "" : jesJob.getReturnInfo());
            this.outputProperties.setProperty("JobReturnStatus", jesJob.getReturnStatus() == null ? "" : jesJob.getReturnStatus());
            jobUtil.disconnect();
            return success;
        }
        return true;
    }

    private String replaceTokensInJcl(String jcl, String tokensToBeReplaced) throws Exception {
        JclTokenReplacer tokenReplacer = new JclTokenReplacer(tokensToBeReplaced);
        String jclWithTokensReplaced = tokenReplacer.getJclWithTokensReplaced(jcl);
        System.out.println("  [replace] Replaced " + tokenReplacer.getNoOfReplaceOccurrences() + " occurrences in 1 files.");
        JclFormatter jclFormatter = new JclFormatter(ZUtil.getDefaultPlatformEncoding());
        String formattedJcl = jclFormatter.getFormattedJcl(jcl, jclWithTokensReplaced);
        System.out.println("========================================================================================================================");
        System.out.println("JCL after replacing token.");
        System.out.println("========================================================================================================================");
        System.out.println(formattedJcl);
        return formattedJcl;
    }
}

