/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.mvs.command;

import com.ibm.zos.sdsf.core.ISFRequestResults;
import com.ibm.zos.sdsf.core.ISFRequestSettings;
import com.ibm.zos.sdsf.core.ISFRunner;
import com.urbancode.air.plugin.command.mvs.command.MvsCommandOutput;
import com.urbancode.air.plugin.command.mvs.command.NotAuthorizedException;

class MvsCommandExecutor {
    private static final String ULOG_MESSAGE = "ISF444I ULOG";
    private static final int MAX_USER_NAME_LENGTH = 8;
    private static final String USER_NAME = "user.name";
    private final ISFRunner isfRunner;

    private MvsCommandExecutor(ISFRunner isfRunner) {
        this.isfRunner = isfRunner;
    }

    public static MvsCommandExecutor createInstance() {
        ISFRequestSettings isfRequestSettings = MvsCommandExecutor.getIsfRequestSettings();
        ISFRunner isfRunner = new ISFRunner(isfRequestSettings);
        MvsCommandExecutor.checkAccessToRunCommands(isfRunner);
        return new MvsCommandExecutor(isfRunner);
    }

    public MvsCommandOutput runCommand(String mvsCommand) {
        System.out.println("===============================");
        System.out.println(mvsCommand);
        int returnCode = this.isfRunner.system(mvsCommand);
        System.out.println("ReturnCode = " + returnCode);
        ISFRequestResults isfRequestResults = this.isfRunner.getRequestResults();
        if (returnCode > 0) {
            System.out.println("ReasonCode = " + isfRequestResults.getReasonCode());
        }
        isfRequestResults.printResponseList();
        return new MvsCommandOutput(returnCode, isfRequestResults.getResponseList());
    }

    private static ISFRequestSettings getIsfRequestSettings() {
        ISFRequestSettings isfRequestSettings = new ISFRequestSettings();
        String userName = System.getProperty(USER_NAME);
        if (userName.length() < 8) {
            userName = userName + "x";
        }
        isfRequestSettings.addISFCons(userName);
        return isfRequestSettings;
    }

    private static void checkAccessToRunCommands(ISFRunner isfRunner) {
        if (isfRunner.queryAuth() != 0) {
            throw new NotAuthorizedException("Failed to run QUERY AUTH in SDSF. You must be authorized to use SDSF from Java and you must be authorized to the SDSF functions that you invoke from Java.");
        }
        ISFRequestResults isfRequestResults = isfRunner.getRequestResults();
        boolean canUseLog = isfRequestResults.getMessageList().contains(ULOG_MESSAGE);
        if (!canUseLog) {
            MvsCommandExecutor.printWarningMessage();
        }
    }

    private static void printWarningMessage() {
        System.out.println("Warning: User " + System.getProperty(USER_NAME) + " is not authorized to use ULOG command from SDSF Java interface. ");
        System.out.println("Warning: You may issue MVS commands but may not see the response of the commands.");
        System.out.println("Warning: RACF resource ISFCMD.ODSP.ULOG.jesx CL(SDSF) gives user authority to issue the ULOG command.");
    }
}

