/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.deployment;

import com.ibm.urbancode.zos.xml.utils.common.XmlHelper;
import com.ibm.urbancode.zos.xml.utils.deploy.Container;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.ibm.urbancode.zos.xml.utils.deploy.Resource;
import com.urbancode.air.plugin.command.version.common.XmlIndentHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class DeployManifestMvsGenerator {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String XML_VERSION = "1.0";
    private static final String CONTAINER_TYPE_SEQUENTIAL = "sequential";
    private static final String CONTAINER_TYPE_PDS = "PDS";
    private final XmlIndentHandler xmlIndentHandler = new XmlIndentHandler();
    private XMLStreamWriter xmlStreamWriter = null;

    private DeployManifestMvsGenerator() {
    }

    public static String generate(String packageManifestPath) throws XMLStreamException, IOException {
        PackageManifest packageManifest = PackageManifest.from((String)packageManifestPath);
        DeployManifestMvsGenerator deployManifestMvsGenerator = new DeployManifestMvsGenerator();
        return deployManifestMvsGenerator.generateXML(packageManifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateXML(PackageManifest packageManifest) throws XMLStreamException {
        StringWriter stringWriter = new StringWriter();
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        try {
            this.xmlStreamWriter = outputFactory.createXMLStreamWriter(stringWriter);
            this.writeXmlElements(packageManifest);
        }
        finally {
            if (this.xmlStreamWriter != null) {
                this.xmlStreamWriter.close();
            }
        }
        return stringWriter.toString();
    }

    private void writeXmlElements(PackageManifest packageManifest) throws XMLStreamException {
        this.createXmlHeaderTag();
        this.createStartingManifestTag();
        this.writeContainers(packageManifest.getAddedContainers());
        this.writeDeletedContainers(packageManifest.getDeletedContainers());
        this.writeEndingManifestTag();
        this.xmlStreamWriter.writeEndDocument();
    }

    private void writeEndingManifestTag() throws XMLStreamException {
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void createStartingManifestTag() throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement("manifest");
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void createXmlHeaderTag() throws XMLStreamException {
        this.xmlStreamWriter.writeStartDocument(XmlHelper.getFileEncoding(), XML_VERSION);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeDeletedContainers(List<Container> deletedContainers) throws XMLStreamException {
        if (deletedContainers.isEmpty()) {
            return;
        }
        this.writeStartingDeletedTag();
        this.writeContainers(deletedContainers);
        this.writeEndElement();
    }

    private void writeStartingDeletedTag() throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement("deleted");
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeEndElement() throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getEndingTagIndent());
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeContainers(List<Container> containers) throws XMLStreamException {
        for (Container container : containers) {
            if (container.isPds()) {
                this.writePDSContainer(container.getSourceContainerName(), container.getResources());
                continue;
            }
            if (!container.isSequential()) continue;
            this.writeSequentialContainer(container.getSourceContainerName());
        }
    }

    private void writePDSContainer(String sourceDataset, List<Resource> members) throws XMLStreamException {
        this.writeStartingContainerTag(sourceDataset, CONTAINER_TYPE_PDS);
        this.writeContainerResources(members);
        this.writeEndElement();
    }

    private void writeStartingContainerTag(String sourceDataset, String containerType) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement("container");
        this.xmlStreamWriter.writeAttribute("name", sourceDataset);
        this.xmlStreamWriter.writeAttribute("type", containerType);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeSequentialContainer(String sourceDataset) throws XMLStreamException {
        this.writeStartingContainerTag(sourceDataset, CONTAINER_TYPE_SEQUENTIAL);
        this.writeEndElement();
    }

    private void writeContainerResources(List<Resource> members) throws XMLStreamException {
        for (Resource resource : members) {
            this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getSelfClosingTagIndent());
            this.xmlStreamWriter.writeEmptyElement("resource");
            this.xmlStreamWriter.writeAttribute("name", resource.getName());
            this.xmlStreamWriter.writeAttribute("type", resource.getType());
            this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        }
    }
}

