/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.deployment;

import com.ibm.jzos.ZFileException;
import com.ibm.urbancode.zos.dataset.util.DatasetHelper;
import com.ibm.urbancode.zos.xml.utils.deploy.Container;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.ibm.urbancode.zos.xml.utils.deploy.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;

public class PDSChecker {
    private static final String OPEN_PARENTHESIS = "(";
    private static final String CLOSED_PARENTHESIS = ")";
    private static final String DUMMY = "DUMMY";

    private PDSChecker() {
    }

    public static List<String> getListOfExistingPdsMembers(String manifestFilePath, String containerMapperFilePath) throws IOException, XMLStreamException {
        PackageManifest manifest = PackageManifest.from((String)manifestFilePath, (String)containerMapperFilePath);
        List<String> allTargetPdsMembers = manifest.getContainers().stream().filter(container -> !container.isDeleted()).filter(Container::isPds).flatMap(PDSChecker::getAllTargetPDSMembers).collect(Collectors.toList());
        return PDSChecker.getExistingTargetPdsMembers(allTargetPdsMembers);
    }

    private static Stream<String> getAllTargetPDSMembers(Container pdsContainer) {
        return pdsContainer.getResources().stream().flatMap(member -> PDSChecker.getTargetPdsDatasetsWithEnclosedMember(pdsContainer, member));
    }

    private static Stream<String> getTargetPdsDatasetsWithEnclosedMember(Container pdsContainer, Resource member) {
        return pdsContainer.getTargetContainers().stream().filter(targetContainer -> !targetContainer.equals(DUMMY)).map(targetContainer -> targetContainer + OPEN_PARENTHESIS + member.getName() + CLOSED_PARENTHESIS);
    }

    private static List<String> getExistingTargetPdsMembers(List<String> pdsMembers) throws ZFileException {
        ArrayList<String> existingPdsMembers = new ArrayList<String>();
        for (String pdsMember : pdsMembers) {
            if (!DatasetHelper.isDatasetExist(pdsMember)) continue;
            existingPdsMembers.add(pdsMember);
        }
        return existingPdsMembers;
    }
}

