/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.deployment;

import com.ibm.teamz.build.binder.jni.BinderInfo;
import com.ibm.urbancode.zos.common.util.AgentFilesHelper;
import com.ibm.urbancode.zos.common.util.FileHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RuntimeDeltaDeployHelper {
    private static final String ENCODING_IBM1047 = "IBM-1047";
    private static final String JAVA_LIBRARY_PATH = "java.library.path";
    private static final String HASH_VALUE_IS = "HASH VALUE IS ";

    public static boolean isVersionAndTargetMemberIdentical(HashMap<String, String> versionIdMap, HashMap<String, String> targetEnvIdMap, String sourcePdsMember) {
        if (versionIdMap.size() != targetEnvIdMap.size()) {
            System.out.println("        Number of id fields does not match. Continue to deploy " + sourcePdsMember);
            return false;
        }
        for (String name : versionIdMap.keySet()) {
            String sourceValue = versionIdMap.get(name);
            String targetValue = targetEnvIdMap.get(name);
            if (targetValue != null && targetValue.equals("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF")) {
                System.out.println("      Member does not exist in target inventory. Continue to deploy " + sourcePdsMember);
                return false;
            }
            if (targetValue == null || targetValue.equals(sourceValue)) continue;
            System.out.println("        " + name + " does  not match. version value : " + sourceValue + " <> target inventory value : " + targetValue + " . Continue to deploy " + sourcePdsMember);
            return false;
        }
        return true;
    }

    public static void deleteIdenticalFile(String identicalFilePath) {
        File identicalFile = new File(identicalFilePath);
        if (!identicalFile.delete()) {
            throw new IllegalArgumentException("Failed to delete identical file " + identicalFilePath + " for Runtime Delta Deploy");
        }
    }

    public static void addBinderProgramPathToJavaLibPath(String binderPath) {
        String bitMode = System.getProperty("com.ibm.vm.bitmode");
        String sharedLibName = "64".equals(bitMode) ? "iewbndd6.so" : "iewbnddx.so";
        String sharedLibPath = binderPath + File.separator + sharedLibName;
        if (FileHelper.isFileNotExist(sharedLibPath)) {
            throw new IllegalArgumentException("ERROR: Binder shared libraries not found in path " + binderPath + " to perform RUNTIME delta deployment. Path to binder shared libraries(iewbndd6.so/iewbnddx.so) should be provided in hidden input 'Binder API path' in plugin step.");
        }
        System.setProperty(JAVA_LIBRARY_PATH, System.getProperty(JAVA_LIBRARY_PATH) + File.pathSeparator + binderPath);
    }

    public static String getMappedTargetDataset(Map<String, Set<String>> dsToDeploySrc2TargetMap, String containerName) {
        if (!dsToDeploySrc2TargetMap.containsKey(containerName)) {
            throw new IllegalArgumentException("Failed to get Target Dataset Mapping for source container " + containerName);
        }
        ArrayList targets = new ArrayList(dsToDeploySrc2TargetMap.get(containerName));
        if (targets.size() > 1) {
            throw new IllegalArgumentException("Found multiple targets mapped for dataset " + containerName + ". Multiple target mapping is not supported for Runtime Delta Deploy.");
        }
        return (String)targets.get(0);
    }

    public static String getModuleDetailsUsingBinder(String targetPDS, String memberName, String tempCFilePath) throws UnsupportedEncodingException {
        byte[] tempCFilePathBytes;
        byte[] memberBytes;
        byte[] targetPdsBytes = targetPDS.getBytes(ENCODING_IBM1047);
        byte[] binderOutputBytes = new BinderInfo().getBinderInfo(targetPdsBytes, memberBytes = memberName.getBytes(ENCODING_IBM1047), tempCFilePathBytes = tempCFilePath.getBytes(ENCODING_IBM1047));
        String binderOutput = new String(binderOutputBytes);
        if (binderOutput.contains("error:")) {
            throw new RuntimeException("Failure while calling BinderInfo native program with error \n " + binderOutput + "\nContainer is " + targetPDS + " Resource is " + memberName);
        }
        return binderOutput;
    }

    public static String determineHashValueUsingHashcalRexx(String targetPDS, String memberName) throws IOException, InterruptedException {
        String command = AgentFilesHelper.getStartIspfScriptPath() + " HASHCAL " + targetPDS + " " + memberName + " DEPLOY";
        Process process = Runtime.getRuntime().exec(command);
        String outputXMLString = RuntimeDeltaDeployHelper.getProcessOutput(process.getInputStream());
        int exitValue = process.waitFor();
        if (exitValue > 0) {
            System.out.println(outputXMLString);
            throw new RuntimeException("HASHCAL program failed with rc " + exitValue);
        }
        return RuntimeDeltaDeployHelper.getHashValueFrom(outputXMLString);
    }

    private static String getProcessOutput(InputStream inputStream) throws IOException {
        StringBuilder outputXMLStringBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String outputLine;
            while ((outputLine = reader.readLine()) != null) {
                if (outputLine.trim().startsWith("Connection Protocol")) continue;
                outputXMLStringBuilder.append(outputLine).append('\n');
            }
        }
        return outputXMLStringBuilder.toString();
    }

    private static String getHashValueFrom(String outputXMLString) {
        int hashValConstStrLen = HASH_VALUE_IS.length();
        int hashValPosition = outputXMLString.indexOf(HASH_VALUE_IS);
        return outputXMLString.substring(hashValPosition + hashValConstStrLen + 1, hashValPosition + hashValConstStrLen + 41);
    }
}

