/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.rollback;

import com.ibm.urbancode.zos.xml.utils.common.ContainerType;
import com.ibm.urbancode.zos.xml.utils.common.XmlHelper;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackContainer;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackManifest;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackResource;
import com.urbancode.air.plugin.command.version.common.XmlIndentHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

class RollbackManifestGenerator {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String XML_VERSION = "1.0";
    private final XmlIndentHandler xmlIndentHandler = new XmlIndentHandler();
    private XMLStreamWriter xmlStreamWriter = null;

    private RollbackManifestGenerator() {
    }

    public static String generateInvertedActionsXml(String inputManifestPath) throws XMLStreamException, IOException {
        RollbackManifest rollbackManifest = RollbackManifest.from((String)inputManifestPath);
        return new RollbackManifestGenerator().createXML(rollbackManifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createXML(RollbackManifest rollbackManifest) throws XMLStreamException {
        StringWriter stringWriter = new StringWriter();
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        try {
            this.xmlStreamWriter = outputFactory.createXMLStreamWriter(stringWriter);
            this.writeXmlElements(rollbackManifest);
        }
        finally {
            if (this.xmlStreamWriter != null) {
                this.xmlStreamWriter.close();
            }
        }
        return stringWriter.toString();
    }

    private void writeXmlElements(RollbackManifest rollbackManifest) throws XMLStreamException {
        this.xmlStreamWriter.writeStartDocument(XmlHelper.getFileEncoding(), XML_VERSION);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        this.xmlStreamWriter.writeStartElement("manifest");
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        this.writeDeployContainers(rollbackManifest.getUpdatedContainers(), rollbackManifest.getDeletedContainers());
        if (!rollbackManifest.getCreatedContainers().isEmpty()) {
            this.writeDeletedContainers(rollbackManifest.getCreatedContainers());
        }
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        this.xmlStreamWriter.writeEndDocument();
    }

    private void writeDeployContainers(List<RollbackContainer> updatedContainers, List<RollbackContainer> deletedContainers) throws XMLStreamException {
        HashSet<String> writtenContainers = new HashSet<String>();
        for (RollbackContainer updatedContainer : updatedContainers) {
            this.writeContainerStartElement(updatedContainer);
            for (RollbackResource updatedContainerResource : updatedContainer.getResources()) {
                this.writeDeployContainerResource(updatedContainerResource);
            }
            Optional<RollbackContainer> deletedContainer = this.getDeletedContainerWithSameNameAndType(updatedContainer, deletedContainers);
            boolean isSameContainerPresentUnderDeletedTag = deletedContainer.isPresent();
            if (isSameContainerPresentUnderDeletedTag) {
                this.writeResourcesOfDeletedContainerUnderUpdatedContainer(deletedContainer.get());
            }
            this.writeEndElement();
            writtenContainers.add(updatedContainer.getName());
        }
        for (RollbackContainer deletedContainer : deletedContainers) {
            boolean isDeletedContainerAlreadyWritten = writtenContainers.contains(deletedContainer.getName());
            if (isDeletedContainerAlreadyWritten) continue;
            this.writeDeletedDeployContainer(deletedContainer);
        }
    }

    private void writeResourcesOfDeletedContainerUnderUpdatedContainer(RollbackContainer deletedContainer) throws XMLStreamException {
        for (RollbackResource deletedContainerResource : deletedContainer.getResources()) {
            this.writeDeployContainerResource(deletedContainerResource);
        }
    }

    private Optional<RollbackContainer> getDeletedContainerWithSameNameAndType(RollbackContainer updatedContainer, List<RollbackContainer> deletedContainers) {
        return deletedContainers.stream().filter(rollbackContainer -> !rollbackContainer.isMissing()).filter(rollbackContainer -> rollbackContainer.getName().equals(updatedContainer.getName())).filter(rollbackContainer -> rollbackContainer.getType().equals((Object)updatedContainer.getType())).findFirst();
    }

    private void writeDeletedDeployContainer(RollbackContainer deletedContainer) throws XMLStreamException {
        if (deletedContainer.isMissing()) {
            return;
        }
        this.writeContainerStartElement(deletedContainer);
        for (RollbackResource deployContainerResource : deletedContainer.getResources()) {
            this.writeDeployContainerResource(deployContainerResource);
        }
        this.writeEndElement();
    }

    private void writeDeployContainerResource(RollbackResource deployContainerResource) throws XMLStreamException {
        if (deployContainerResource.isMissing()) {
            return;
        }
        this.writeContainerResource(deployContainerResource);
    }

    private void writeDeletedContainers(List<RollbackContainer> containers) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement("deleted");
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        for (RollbackContainer deletedContainer : containers) {
            this.writeDeletedContainer(deletedContainer);
        }
        this.writeEndElement();
    }

    private void writeDeletedContainer(RollbackContainer deletedContainer) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement("container");
        this.xmlStreamWriter.writeAttribute("name", deletedContainer.getName());
        this.xmlStreamWriter.writeAttribute("type", this.getContainerType(deletedContainer.getType()));
        if (deletedContainer.isMissing()) {
            this.xmlStreamWriter.writeAttribute("missing", "true");
        }
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        for (RollbackResource deletedContainerResource : deletedContainer.getResources()) {
            this.writeContainerResource(deletedContainerResource);
        }
        this.writeEndElement();
    }

    private void writeContainerStartElement(RollbackContainer container) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement("container");
        this.xmlStreamWriter.writeAttribute("name", container.getName());
        this.xmlStreamWriter.writeAttribute("type", this.getContainerType(container.getType()));
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeContainerResource(RollbackResource resource) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getSelfClosingTagIndent());
        this.xmlStreamWriter.writeEmptyElement("resource");
        this.xmlStreamWriter.writeAttribute("name", resource.getName());
        this.xmlStreamWriter.writeAttribute("type", resource.getType());
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private String getContainerType(ContainerType type) {
        switch (type) {
            case PDS: {
                return "PDS";
            }
            case SEQUENTIAL: {
                return "sequential";
            }
            case DIRECTORY: {
                return "directory";
            }
        }
        throw new IllegalArgumentException("Unsupported Container Type found " + type);
    }

    private void writeEndElement() throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getEndingTagIndent());
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }
}

