/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.dataset.record;

import com.ibm.team.enterprise.deployment.dataset.record.DatasetRecord;
import com.ibm.team.enterprise.deployment.dataset.record.DeploymentRecord;
import com.ibm.team.enterprise.deployment.dataset.record.PdsDeleteRecordBuilder;
import com.ibm.team.enterprise.deployment.dataset.record.PdsUpdateRecordBuilder;
import com.ibm.team.enterprise.deployment.dataset.record.SeqDeleteRecordBuilder;
import com.ibm.team.enterprise.deployment.dataset.record.SeqUpdateRecordBuilder;
import com.ibm.urbancode.zos.xml.utils.deploy.Container;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.ibm.urbancode.zos.xml.utils.deploy.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class DeploymentRecordsGenerator {
    private DeploymentRecordsGenerator() {
    }

    public static List<DatasetRecord> generateRecordsFrom(PackageManifest packageManifest, Map<String, String> sourceTempDsnMap) {
        return packageManifest.getContainers().stream().filter(Container::isDataset).flatMap(container -> DeploymentRecordsGenerator.getDeploymentRecords(container, sourceTempDsnMap)).collect(Collectors.toList());
    }

    private static Stream<DeploymentRecord> getDeploymentRecords(Container container, Map<String, String> sourceTempDsnMap) {
        if (container.isDeleted()) {
            return DeploymentRecordsGenerator.getDeleteRecords(container);
        }
        return DeploymentRecordsGenerator.getUpdateRecord(container, sourceTempDsnMap);
    }

    private static Stream<DeploymentRecord> getDeleteRecords(Container container) {
        if (container.isSequential()) {
            return container.getTargetContainers().stream().map(DeploymentRecordsGenerator::getSeqDeleteRecord);
        }
        return container.getTargetContainers().stream().flatMap(targetContainer -> DeploymentRecordsGenerator.getPdsDeleteRecords(container.getResources(), targetContainer));
    }

    private static Stream<DeploymentRecord> getPdsDeleteRecords(List<Resource> resources, String targetDsn) {
        return resources.stream().map(resource -> DeploymentRecordsGenerator.getPdsMemberDeleteRecord(resource, targetDsn));
    }

    private static Stream<DeploymentRecord> getUpdateRecord(Container container, Map<String, String> sourceTempDsnMap) {
        String sourceDsn = sourceTempDsnMap.get(container.getSourceContainerName());
        if (container.isSequential()) {
            return container.getTargetContainers().stream().map(targetContainer -> DeploymentRecordsGenerator.getSeqUpdateRecord(sourceDsn, targetContainer));
        }
        return container.getTargetContainers().stream().map(targetContainer -> DeploymentRecordsGenerator.getPdsUpdateRecord(sourceDsn, targetContainer));
    }

    private static DeploymentRecord getSeqUpdateRecord(String sourceDataset, String targetDataset) {
        return new SeqUpdateRecordBuilder().withSourceDsn(sourceDataset).withTargetDsn(targetDataset).build();
    }

    private static DeploymentRecord getPdsUpdateRecord(String sourceDataset, String targetDataset) {
        return new PdsUpdateRecordBuilder().withSourceDsn(sourceDataset).withTargetDsn(targetDataset).build();
    }

    private static DeploymentRecord getSeqDeleteRecord(String targetDataset) {
        return new SeqDeleteRecordBuilder().withTargetDsn(targetDataset).build();
    }

    private static DeploymentRecord getPdsMemberDeleteRecord(Resource resource, String targetDsn) {
        return new PdsDeleteRecordBuilder().withTargetDsn(targetDsn).withMember(resource.getName()).build();
    }
}

