/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit.manifest;

import com.ibm.urbancode.zos.common.util.AgentInstalledProperties;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.common.util.PluginFilesHelper;
import com.ibm.urbancode.zos.rexx.RexxExecutor;
import com.urbancode.air.plugin.command.version.deployment.BackupManifestMvsGenerator;
import java.io.File;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;

public class MvsBackupTaker {
    public static final String SPACE = " ";
    public static final String DOUBLE_QUOTE = "\"";
    private static final String BACKUP_MANIFEST_MVS_XML = "BackupManifestMvs.xml";
    private final boolean isTraceOn;
    private final String tempDsnPrefix;
    private final String ispfGatewayBinPath;
    private static final AgentInstalledProperties agentInstalledProperties = new AgentInstalledProperties();

    public MvsBackupTaker(boolean isTraceOn, String tempDsnPrefix, String ispfGatewayPath) {
        this.isTraceOn = isTraceOn;
        this.tempDsnPrefix = tempDsnPrefix;
        this.ispfGatewayBinPath = ispfGatewayPath;
    }

    public void takeBackup(String componentVersionWorkingDir) throws Exception {
        this.deleteOldBackupZipFile(componentVersionWorkingDir);
        this.createBackupManifestMvsFile(componentVersionWorkingDir);
        RexxExecutor rexxExecutor = new RexxExecutor(this.tempDsnPrefix, this.ispfGatewayBinPath);
        String rexxArguments = this.getRexxArguments(componentVersionWorkingDir);
        rexxExecutor.execute(PluginFilesHelper.getBackupRexxFilePath(), rexxArguments);
    }

    private void createBackupManifestMvsFile(String componentVersionWorkingDir) throws IOException, XMLStreamException {
        String packageManifestDeployFilePath = componentVersionWorkingDir + File.separator + "packageManifest_deploy.xml";
        String containerMapperFilePath = componentVersionWorkingDir + File.separator + "containerMapper.xml";
        String xmlString = BackupManifestMvsGenerator.generate(packageManifestDeployFilePath, containerMapperFilePath);
        String backupManifestMvsFilePath = componentVersionWorkingDir + File.separator + BACKUP_MANIFEST_MVS_XML;
        FileHelper.writeStringToFile(xmlString, backupManifestMvsFilePath);
    }

    private void deleteOldBackupZipFile(String componentVersionWorkingDir) {
        FileHelper.deleteFile(componentVersionWorkingDir + File.separator + "backup.zip");
    }

    private String getRexxArguments(String componentVersionWorkingDir) {
        String backupManifestMvsFilePath = componentVersionWorkingDir + File.separator + BACKUP_MANIFEST_MVS_XML;
        return DOUBLE_QUOTE + backupManifestMvsFilePath + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + componentVersionWorkingDir + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + this.isTraceOn + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + agentInstalledProperties.getSysoutClass() + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + agentInstalledProperties.getTempUnit() + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + agentInstalledProperties.getTempVolser() + DOUBLE_QUOTE;
    }
}

