/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.rollback;

import com.ibm.jzos.ZFile;
import com.ibm.urbancode.zos.xml.utils.common.DeployedVersion;
import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.air.plugin.inputs.HfsMappingHelper;
import com.urbancode.air.plugin.inputs.InputsValidator;
import java.util.Properties;

class RollbackPackageInputs {
    public static final String RESOURCE_ID = "resourceId";
    public static final String ENVIRONMENT_ID = "environmentId";
    public static final String VERSION_ID = "versionId";
    public static final String COMPONENT_ID = "componentId";
    public static final String COMPONENT_NAME = "componentName";
    public static final String VERSION_NAME = "versionName";
    public static final String VERSION_TYPE = "versionType";
    public static final String DEPLOY_BASE_PATH = "deployBasePath";
    public static final String TEMP_DSN_PREFIX = "tempDsnPrefix";
    public static final String PREVENT_RISKY_ROLLBACK = "preventRiskyRollback";
    public static final String DRY_RUN_FOR_RISKY = "dryRunForRisky";
    public static final String PRINT_LOGS = "printLogs";
    public static final String CHECK_ACCESS = "checkAccess";
    public static final String DEL_BACK_UP_FILES = "delBackUpFiles";
    public static final String HFS_TARGET_DIR = "hfsTargetDir";
    public static final String ISPF_GATEWAY_PATH = "ispfGatewayPath";
    private final String resourceId;
    private final String environmentId;
    private final String versionId;
    private final String componentId;
    private final String componentName;
    private final String versionName;
    private final String versionType;
    private final String tempDsnPrefix;
    private final boolean isPreventRiskyRollbackEnabled;
    private final boolean isPrintLogsEnabled;
    private final boolean isDryRunEnabled;
    private final boolean isCheckAccessEnabled;
    private final boolean isDeleteBackupFilesEnabled;
    private final String hfsMapping;
    private final String ispfGatewayBinPath;
    private final DeployedVersion deployedVersion;

    public RollbackPackageInputs(Properties inputProperties) {
        this.resourceId = inputProperties.getProperty(RESOURCE_ID).trim();
        this.environmentId = inputProperties.getProperty(ENVIRONMENT_ID).trim();
        this.versionId = inputProperties.getProperty(VERSION_ID).trim();
        this.componentId = inputProperties.getProperty(COMPONENT_ID).trim();
        this.componentName = inputProperties.getProperty(COMPONENT_NAME).trim();
        this.versionName = inputProperties.getProperty(VERSION_NAME).trim();
        this.versionType = inputProperties.getProperty(VERSION_TYPE).trim();
        String passedTempDsnPrefix = inputProperties.getProperty(TEMP_DSN_PREFIX).trim();
        this.tempDsnPrefix = passedTempDsnPrefix.isEmpty() ? ZFile.getDefaultHLQ() : passedTempDsnPrefix;
        this.ispfGatewayBinPath = inputProperties.getProperty(ISPF_GATEWAY_PATH).trim();
        this.hfsMapping = HfsMappingHelper.determineMapping(inputProperties.getProperty(HFS_TARGET_DIR).trim());
        this.isPreventRiskyRollbackEnabled = Boolean.parseBoolean(inputProperties.getProperty(PREVENT_RISKY_ROLLBACK).trim());
        this.isDryRunEnabled = Boolean.parseBoolean(inputProperties.getProperty(DRY_RUN_FOR_RISKY).trim());
        this.isPrintLogsEnabled = Boolean.parseBoolean(inputProperties.getProperty(PRINT_LOGS).trim());
        this.isCheckAccessEnabled = Boolean.parseBoolean(inputProperties.getProperty(CHECK_ACCESS).trim());
        this.isDeleteBackupFilesEnabled = Boolean.parseBoolean(inputProperties.getProperty(DEL_BACK_UP_FILES).trim());
        this.deployedVersion = new DeployedVersion(inputProperties);
    }

    public static RollbackPackageInputs getValidatedInputs(Properties inputProperties) {
        RollbackPackageInputs pluginInputs = new RollbackPackageInputs(inputProperties);
        pluginInputs.validateInputs();
        return pluginInputs;
    }

    private void validateInputs() {
        InputsValidator.checkIfEmpty(this.environmentId, "Environment Id");
        InputsValidator.checkIfEmpty(this.versionId, "Version Id");
        InputsValidator.checkIfEmpty(this.componentId, "Component Id");
        InputsValidator.checkIfEmpty(this.ispfGatewayBinPath, "ISPF Gateway Path");
        this.validateVersionType();
    }

    private void validateVersionType() {
        InputsValidator.checkIfEmpty(this.versionType, "Version Type");
        if (this.versionTypeIsNotFull() && this.versionTypeIsNotIncremental()) {
            throw new InvalidInputException("Invalid version type - " + this.versionType + ". Version Type must be either " + "FULL" + " or " + "INCREMENTAL");
        }
        if (this.versionType.equalsIgnoreCase("FULL")) {
            throw new InvalidInputException("Rollback is not supported for full version " + this.versionName);
        }
    }

    private boolean versionTypeIsNotIncremental() {
        return !this.versionType.equalsIgnoreCase("INCREMENTAL");
    }

    private boolean versionTypeIsNotFull() {
        return !this.versionType.equalsIgnoreCase("FULL");
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getTempDsnPrefix() {
        return this.tempDsnPrefix;
    }

    public boolean isPreventRiskyRollbackEnabled() {
        return this.isPreventRiskyRollbackEnabled;
    }

    public boolean isPrintLogsEnabled() {
        return this.isPrintLogsEnabled;
    }

    public boolean isDryRunEnabled() {
        return this.isDryRunEnabled;
    }

    public boolean isCheckAccessEnabled() {
        return this.isCheckAccessEnabled;
    }

    public boolean isDeleteBackupFilesEnabled() {
        return this.isDeleteBackupFilesEnabled;
    }

    public String getHfsMapping() {
        return this.hfsMapping;
    }

    public String getIspfGatewayBinPath() {
        return this.ispfGatewayBinPath;
    }

    public DeployedVersion getDeployedVersion() {
        return this.deployedVersion;
    }
}

