/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.jes.passticket;

import com.ibm.eserver.zos.racf.IRRPassTicket;
import com.ibm.eserver.zos.racf.IRRPassTicketGenerationException;
import com.ibm.urbancode.zos.jes.Logger;
import java.io.File;

public class PassTicketGenerator {
    private static final String JAVA_LIBRARY_PATH = "java.library.path";
    private static final String SAF_RC_8_RACF_RC_8_RACF_RSN_16 = "SafRc=8, racfRc=8 racfRsn=16";

    public static String generate(String userid, String libPath, String applId) throws Exception {
        try {
            Logger.getDefault().writeLog("Generating passticket.");
            if (!libPath.isEmpty()) {
                PassTicketGenerator.addToJavaLibraryPath(libPath);
            }
            IRRPassTicket passTicket = new IRRPassTicket();
            return passTicket.generate(userid.toUpperCase(), applId);
        }
        catch (IRRPassTicketGenerationException e) {
            Logger.getDefault().writeError("Failed to generate passticket for user(" + userid + ") applid(" + applId + ")");
            if (SAF_RC_8_RACF_RC_8_RACF_RSN_16.equalsIgnoreCase(e.toString())) {
                Logger.getDefault().writeError("Not authorized to use passticket.");
            } else {
                Logger.getDefault().writeError("See the 'Return and reason codes' section of the R_GenSec chapter in z/OS Security Server RACF Callable Services book");
            }
            throw e;
        }
    }

    private static void addToJavaLibraryPath(String libPath) {
        String updatedPath = libPath + File.pathSeparator + System.getProperty(JAVA_LIBRARY_PATH);
        System.setProperty(JAVA_LIBRARY_PATH, updatedPath);
    }
}

