/* REXX */
/*%STUB CALLCMD*/
/*********************************************************************/
/* Copyright:    Licensed Materials - Property of IBM and/or HCL     */
/*                                                                   */
/*        Copyright IBM Corporation. All rights reserved             */
/*        Copyright HCL Technologies limited. All rights reserved    */
/*                                                                   */
/*        US Government Users Restricted Rights -                    */
/*        Use, duplication or disclosure restricted by               */
/*        GSA ADP Schedule Contract with IBM Corp.                   */
/*                                                                   */
/*********************************************************************/
parse arg actionDataset

CODE_8 = 8

say ""
say "   ******   Start of Process   ******   "
say ""
/* Read Action records into a stem variable */
drop actionRecords.
Address TSO "ALLOC F(ACTNDSN)  DA('"actionDataset"') SHR REUSE"
Address TSO "EXECIO * DISKR ACTNDSN (STEM actionRecords. FINIS)"
exec_RC = rc
x = Msg('off')
    Address TSO "FREE F(ACTNDSN)"
x = Msg('on')
if exec_RC <> 0 then do
    say " [Error] EXECIO failed for dataset" actionDataset "with rc" exec_RC
    call ExitProgram(exec_RC)
end

/* Main Process */
/* Reading Action dataset records one by one and process it */
/* Note : The offset starts from 2nd line as 1st line is header */
do offset = 1 to actionRecords.0
    parse upper var actionRecords.offset DSNtype ";" Action ";" SrceDSN ";" TargDSN ";" PDSmem .
    Select
        when ( Action == "UPDATE" & DSNtype == "PDS" ) then do
            call CreateDatasetIfDoesNotExist

            BUZMARG1 = TargDSN
            Address ISPEXEC 'GETMSG MSG(BUZD138) LONGMSG(BUZLNGER)'
            Say BUZLNGER
            call CopyPdsMembers
        end

        when ( Action == "UPDATE" & DSNtype == "SEQ" ) then do
            call CreateDatasetIfDoesNotExist

            BUZMARG1 = TargDSN
            Address ISPEXEC 'GETMSG MSG(BUZD140) LONGMSG(BUZLNGER)'
            Say BUZLNGER
            call CopySequentialDataset
        end

        when ( Action == "DELETE" & DSNtype == "PDS" ) then do
            say 'BUZER0942I: Deleting members from dataset' TargDSN
            call DeletePdsMembers
        end

        when ( Action == "DELETE" & DSNtype == "SEQ" ) then do
            say 'BUZER0942I: Deleting dataset' TargDSN
            call DeleteSequentialDataset
        end

      otherwise do
        say " [Error] Invalid Action record found -" actionRecords.offset
        Call ExitProgram(CODE_8)
      end
    end
end

   say ""
   say "   ******   End of Process   ******   "
   say ""

exit /* End of Program */

/**********************************************************************
*********          FUNCTIONS START FROM HERE                ***********
**********************************************************************/
DeleteSequentialDataset:
   /* Delete requested SEQENTIAL file */
   x = OUTTRAP('DELSEQMSG.')
      Address TSO "DELETE '"TargDSN"'"
      Del_rc = rc
   x = OUTTRAP('OFF')

   parse upper var DELSEQMSG.1 IDC_Code IDC_Msg
   select
     when IDC_Code == "IDC0550I" then
        nop
     when IDC_Code == "IDC3012I" then do /* When dataset not found */
        say 'BUZER0944I: Deletion of' TargDSN 'failed. Dataset does not exist.'
     end
     otherwise do
        /* Display SYSTEM error messages before exiting the program */
        do z = 1 to DELSEQMSG.0
           say DELSEQMSG.z
        end
        call ExitProgram(Del_rc)
     end
   end /* End of SELECT statement */

return /* End of Function DeleteSequentialDataset */

DeletePdsMembers:
  /* Deleting requested MEMBER from a PDS Data set.
     Sequence of actions performed in this function are :

                1) LMINIT
                2) LMOPEN
                3) LMMDEL
                4) LMCLOSE
                5) LMFREE
  */
   Address ISPEXEC "LMINIT DATAID(DOD) DATASET('"TargDSN"') ENQ(SHRW)"
    if rc <> 0 then do
        say "The LMINIT function failed for dataset" TargDSN "with return code :" rc
        Call ExitProgram(rc)
    end

   Address ISPEXEC "LMOPEN DATAID(&DOD) OPTION(OUTPUT)"
   Open_rc = rc
   If (Open_rc <> 0) then do
      say "The LMOPEN function failed for dataset" TargDSN "with return code :" Open_rc
      call freeDataset
      call ExitProgram(Open_rc)
   end

   /* Start reading Action records one by one from where its leftoff */
   do forever

      BUZMARG1 = PDSmem
      BUZMARG2 = TargDSN
      Address ISPEXEC 'GETMSG MSG(BUZD134) LONGMSG(BUZLNGER)'
      Say BUZLNGER

      Address ISPEXEC "LMMDEL DATAID(&DOD) MEMBER("PDSmem")"
      lmdel_RC = rc

      Select
        When (lmdel_RC == 0) Then
            Nop
        When (lmdel_RC == 8) Then
        Do
            Say "BUZER0909I: The deletion of the member" PDSmem "failed.",
                "The member did not exist in dataset" TargDSN
        End
        otherwise do
          say "The deletion of the member" PDSmem "failed with return code :" lmdel_RC
          call closeDataset
          call freeDataset
          call ExitProgram(lmdel_RC)
        end
      end /* End of SELECT statement */

      if ( offset == actionRecords.0 ) then leave

      offset = offset + 1

      parse upper var actionRecords.offset cDSNtype ";" cAction ";" cSrceDSN ";" cTargDSN ";" cPDSmem .

      if( DSNtype <> cDSNtype | Action <> cAction | TargDSN <> cTargDSN ) then do
          offset = offset - 1 ; leave
      end

      DSNtype =  cDSNtype ; Action  =  cAction
      TargDSN =  cTargDSN ; PDSmem  =  cPDSmem

   end /* End of DO Loop */

   call closeDataset
   call freeDataset

return /* End of Function DeletePdsMembers */

closeDataset:

   Address ISPEXEC "LMCLOSE DATAID(&DOD)"
   if rc <> 0 then do
      say "The LMCLOSE function failed with return code :" rc
      call ExitProgram(rc)
   end

return

freeDataset:

   Address ISPEXEC "LMFREE DATAID(&DOD)"
   if rc <> 0 then do
      say "The LMFREE function failed with return code :" rc
      call ExitProgram(rc)
   end

return

CopySequentialDataset:

   /* IEBGENER to Update Data  */
   Address TSO "ALLOC F(SYSPRINT) NEW REUSE"
   Address TSO "ALLOC F(SYSUT1)  DA('"SrceDSN"') SHR REUSE"
   Address TSO "ALLOC F(SYSUT2) DA('"TargDSN"') SHR REUSE"
   Address TSO "ALLOC F(SYSIN) DUMMY REUSE "
   Address ISPEXEC "ISPEXEC SELECT PGM(IEBGENER)"
   Copy_rc = rc

   Address TSO  "EXECIO * DISKR SYSPRINT (FINIS STEM sysmsgs."

   x = Msg('off')
       Address TSO "FREE F(SYSIN,SYSPRINT,SYSUT1,SYSUT2)"
   x = Msg('on')

   If Copy_rc <> 0 Then do
      /* Display SYSTEM message from IEBGENER in case of failure */
      Do xmit = 1 to sysmsgs.0
          Say Strip(sysmsgs.xmit)
      End
      call ExitProgram(Copy_rc)
   End

return

CopyPdsMembers:
 /* IEBCOPY to add/replace MEMBERS into LOAD/BINARY type PDS */
   Address TSO "ALLOC F(SYSPRINT) NEW REUSE"
   Address TSO "ALLOC F(INDD)  DA('"SrceDSN"') SHR REUSE"
   Address TSO "ALLOC F(OUTDD) DA('"TargDSN"') SHR REUSE"
   Address TSO "ALLOC F(SYSIN) NEW REUSE"

   Address TSO "ALLOC F(SYSUT4) NEW" ||,
                   " CYLINDERS UNIT(SYSALLDA) SPACE(5 10)"

 /**********************************************************
    From zOS 2.1 onwards we can use the COPYGROUP for alias
    or if data set is a PDSE we can use COPYGRP for alias
 ***********************************************************/
   DROP SYSLINE.

   SYSLINE.1 = " COPYGROUP OUTDD=OUTDD,INDD=((INDD,R))"
   Address TSO "EXECIO * DISKW SYSIN (STEM SYSLINE. FINIS)"
   Address ISPEXEC "ISPEXEC SELECT PGM(IEBCOPY)"
   Copy_rc = rc
   Address TSO "EXECIO * DISKR SYSPRINT (STEM sysinfo. FINIS)"

   x = Msg('off')
       Address TSO "FREE F(SYSIN,SYSUT4,OUTDD,INDD,SYSPRINT)"
   x = Msg('on')

   If Copy_rc <> 0 Then
   Do
      /* Display SYSTEM message from IEBCOPY in case of failure */
      Do xmit = 1 to sysinfo.0
          Say Strip(sysinfo.xmit)
      End
      call ExitProgram(Copy_rc)
   End
   /* Display output details from IEBCOPY */
   Do xmit = 1 to sysinfo.0
     parse var sysinfo.xmit sysw1 sysw2 sysw3 .
     if ( strip(sysw2) == "MEMBER" ) then
        Say "   ***   MEMBER = " left(sysw3,8) "  ***   "
   End

return /* End of Function CopyPdsMembers */

CreateDatasetIfDoesNotExist :
   Address ISPEXEC "DSINFO DATASET('"TargDSN"')"
   If (rc > 0) then do
      If (rc = 8) Then Do
         say "Dataset " TargDSN " does not exist. Allocating dataset.."
         call AllocateDataset
      End
      Else Do
         say "DSINFO failed on '"TargDSN"' Return Code : "rc
         call ExitProgram(rc)
      End
   End
return

AllocateDataset :
   Address ISPEXEC "DSINFO DATASET('"SrceDSN"')"
   If (rc > 0) then Do
      say "DSINFO failed on '"SrceDSN"' Return Code : "rc
      call ExitProgram(rc)
   End
   blksize = Strip(zdsblk)
   Address TSO "ALLOC DA('"Strip(TargDSN)"') " ,
               "LIKE('"Strip(SrceDSN)"') BLKSIZE("blksize")"
   If (rc > 0) then Do
      say "Problem allocating data set '"TargDSN"' Return Code : "rc
      call ExitProgram(rc)
   End
return

ExitProgram :
    Parse arg returnCode
    ZISPFRC = returnCode
    Address ISPEXEC "VPUT (ZISPFRC) SHARED"
Exit returnCode
