/* REXX */

parse arg workDir ",",
          actionDataset ",",
          sysoutValue ",",
          tempUnit ",",
          tempVolserValue .

/* Initialize sysout class and volser */
    If sysoutValue /= "" Then
        sysoutClass = 'SYSOUT('sysoutValue')'
    else
        sysoutClass = ''

    If tempVolserValue /= "" Then
        tempVolser  = 'VOLUME('tempVolserValue')'
    else
        tempVolser  = ''

    /* Read Action records into a stem variable */
    drop actionRecords.
    Address TSO "ALLOC F(ACTNDSN)  DA('"actionDataset"') SHR REUSE"
    Address TSO "EXECIO * DISKR ACTNDSN (STEM actionRecords. FINIS)"
    exec_RC = rc
    x = Msg('off')
        Address TSO "FREE F(ACTNDSN)"
    x = Msg('on')
    if exec_RC <> 0 then do
        say " [Error] EXECIO failed for dataset" actionDataset "with rc" exec_RC
        call ExitProgram(exec_RC)
    end

    Do i = 1 to actionRecords.0
       call ProcessActionRecord actionRecords.i
    end

exit /* Exit program */

ProcessActionRecord :
    parse arg binFile "," binFileSizeInBytes "," tempDsn .
    binFilePath = workDir"/"binFile
    say "XMIT Receiving" binFile "to" tempDsn
    call OcopyHfsBinaryToSequentialFile
    call CopyBinaryFileToTempDataset
return

OcopyHfsBinaryToSequentialFile :
    dsnType = "BASIC"
    select
        when (binFileSizeInBytes <= 56664) Then
            tracks = 1
        when (binFileSizeInBytes > 56664 & binFileSizeInBytes <= 1500000000) Then
            tracks = Format(binFileSizeInBytes/56664,,0)
        otherwise do
            tracks = Format(binFileSizeInBytes/56664,,0)
            dsnType = "LARGE"
        end
    end

    call FreeOcopyDDs

    Address TSO "ALLOC F(SYSPRINT) DUMMY"
    Address TSO "ALLOC F(SEQFILE) NEW" ||,
               " TRACKS UNIT("tempUnit") "tempVolser" DSORG(PS)" ||,
               " BLKSIZE(3120) LRECL(80) RECFM(F B)" ||,
               " SPACE("tracks" "tracks") DSNTYPE("dsnType")"
    Address TSO "ALLOC F(HFSFILE) PATH('"binFilePath"')"
    Address TSO "OCOPY INDD(HFSFILE) OUTDD(SEQFILE) BINARY"
return

FreeOcopyDDs :
    x = msg('off')
        Address TSO "FREE F(HFSFILE)"
        Address TSO "FREE F(SEQFILE)"
        Address TSO "FREE F(SYSPRINT)"
    x = msg('on')
return

CopyBinaryFileToTempDataset :
    x = PROMPT("ON")

        Address TSO "ALLOC F(LOGFILE) NEW",
              " CYLINDERS UNIT("tempUnit") "tempVolser" DSORG(PS)",
              " BLKSIZE(3120) LRECL(255) RECFM(V B) SPACE(1 1)"
        Address TSO "ALLOC F(SYSUT4) NEW",
               " CYLINDERS UNIT("tempUnit") "tempVolser" SPACE(5 10)"
        Address ISPEXEC "QBASELIB LOGFILE ID(LOGFILE)"

        y = OUTTRAP('STEM.')
            Queue " DATASET('"tempDsn"')" sysoutClass
            Address TSO "RECEIVE INFILE(SEQFILE) NONAMES LOGDS("LOGFILE")"
            if rc <> 0 Then Do
                Do xmit = 1 to stem.0
                    Say stem.xmit
                End
                call FreeAllReceiveCommandFiles
                Call ExitProgram(8)
            End
        y = OUTTRAP('OFF')

    x = PROMPT("OFF")

    call FreeAllReceiveCommandFiles
return

FreeAllReceiveCommandFiles :
    Address TSO "FREE F(HFSFILE)"
    Address TSO "FREE F(LOGFILE)"
    Address TSO "FREE F(SEQFILE)"
    Address TSO "FREE F(SYSPRINT)"
    Address TSO "FREE F(SYSUT4)"
return

ExitProgram :
    Parse arg exitRC
    ZISPFRC = exitRC
    Address ISPEXEC "VPUT (ZISPFRC) SHARED"
Exit exitRC