#pragma nomargins nosequence
/*
 * Licensed Materials - Property of IBM and/or HCL Corp.
 * UrbanCode Deploy
 * (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
 * (c) Copyright HCL Technologies Ltd. 2020. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <dynit.h>

#include "com_ibm_teamz_build_binder_jni_BinderInfo.h"

/********************************/
/* Binder's C/C++ Include Files */
/********************************/
#define _IEW_TARGET_RELEASE _IEW_CURRENT_
#define ZERO 0
#include <__iew_api.h>

char *CU_TYPE[0xFF];

JNIEXPORT jbyteArray JNICALL Java_com_ibm_teamz_build_binder_jni_BinderInfo_getBinderInfo
(JNIEnv *env, jobject obj, jbyteArray dsArray, jbyteArray memArray, jbyteArray tempfArray)
{
  // Working variables
  char *cStrOut;
  int len, p;
  jbyteArray cArray;
  char *path_name = "BUZTOOL";
  __dyn_t ip;
  char buf[150];
  int bs = 150;
  jbyte *arr;
  jsize arrLen;
  char *dsNameStr;
  char *memNameStr;
  char *fileNameStr;

  //
  cStrOut = malloc(bs);

  // Convert 1st jbyteArray 'dsName' to C string
  arrLen = (*env)->GetArrayLength(env, dsArray);
  arr = (*env)->GetByteArrayElements(env, dsArray, 0);
  dsNameStr = malloc(arrLen + 1);
  if (dsNameStr == NULL)
  {
    // Release Byte Array Elements after jbyteArray to String conv.
    (*env)->ReleaseByteArrayElements(env, dsArray, arr, 0);
    
    // Set Error message
    snprintf(buf, bs, "malloc1 error: Memory not allocated.");
    cStrOut = buf;
    len = strlen(cStrOut);
    cArray = (*env)->NewByteArray(env, len);
    (*env)->SetByteArrayRegion(env, cArray, 0, len, (jbyte *)cStrOut);

    // Free malloc variables
    free(cStrOut);

    return cArray;
  }
  memcpy(dsNameStr, arr, arrLen);
  p = (int)arrLen;
  dsNameStr[p] = '\0';

  // Convert 2nd jbyteArray 'member' to C string
  arrLen = (*env)->GetArrayLength(env, memArray);
  arr = (*env)->GetByteArrayElements(env, memArray, 0);
  memNameStr = malloc(arrLen + 1);
  if (memNameStr == NULL)
  {
    // Release Byte Array Elements after jbyteArray to String conv.
    (*env)->ReleaseByteArrayElements(env, memArray, arr, 0);

    // Set Error message
    snprintf(buf, bs, "malloc2 error: Memory not allocated.");
    cStrOut = buf;
    len = strlen(cStrOut);
    cArray = (*env)->NewByteArray(env, len);
    (*env)->SetByteArrayRegion(env, cArray, 0, len, (jbyte *)cStrOut);
    
    // Free malloc variables
    free(cStrOut);
    free(dsNameStr);

    return cArray;
  }
  memcpy(memNameStr, arr, arrLen);
  p = (int)arrLen;
  memNameStr[p] = '\0';

  // Convert 3rd jbyteArray 'temp File Path' to C string
  arrLen = (*env)->GetArrayLength(env, tempfArray);
  arr = (*env)->GetByteArrayElements(env, tempfArray, 0);
  fileNameStr = malloc(arrLen + 1);
  if (fileNameStr == NULL)
  {

    // Release Byte Array Elements after jbyteArray to String conv.
    (*env)->ReleaseByteArrayElements(env, tempfArray, arr, 0);

    // Set Error message
    snprintf(buf, bs, "malloc3 error: Memory not allocated.");
    cStrOut = buf;
    len = strlen(cStrOut);
    cArray = (*env)->NewByteArray(env, len);
    (*env)->SetByteArrayRegion(env, cArray, 0, len, (jbyte *)cStrOut);
    
    // Free malloc variables
    free(cStrOut);
    free(dsNameStr);
    free(memNameStr);
    
    return cArray;
  }
  memcpy(fileNameStr, arr, arrLen);
  p = (int)arrLen;
  fileNameStr[p] = '\0';


  // Release Byte Array Elements after jbyteArray to String conversion
  (*env)->ReleaseByteArrayElements(env, tempfArray, arr, 0);

  // Free DD
  dyninit(&ip);
  ip.__ddname = path_name;
  dynfree(&ip);

  // Alloc Dataset and Member to a DD name
  ip.__dsname = dsNameStr;
  ip.__member = memNameStr;
  ip.__status = __DISP_SHR;
  if (dynalloc(&ip) != ZERO)
  {

    // Set error message
    snprintf(buf, bs, "Dynalloc error: Error code %d, info code %d. Dataset %s and member %s",
             ip.__errcode, ip.__infocode, dsNameStr, memNameStr);
    cStrOut = buf;
    len = strlen(cStrOut);
    cArray = (*env)->NewByteArray(env, len);
    (*env)->SetByteArrayRegion(env, cArray, 0, len, (jbyte *)cStrOut);

    // Free DD
    dynfree(&ip);

    // Free malloc variables
    free(dsNameStr);
    free(memNameStr);
    free(fileNameStr);
    free(cStrOut);

    return cArray;
  }

  // Free malloc variables
  free(dsNameStr);
  free(memNameStr);

  int i;

  for (i = 0; i <= 0xFF; i++)
  {
    CU_TYPE[i] = "--invalid--";
  }

  CU_TYPE[0X00] = "LM";
  CU_TYPE[0X01] = "Gen'd by PUTD API V1";
  CU_TYPE[0X02] = "Gen'd by PUTD API V2+";
  CU_TYPE[0X10] = "PO1";
  CU_TYPE[0X11] = "OBJ";
  CU_TYPE[0X12] = "XOBJ";
  CU_TYPE[0X13] = "GOFF";
  CU_TYPE[0X14] = "Unknown";
  CU_TYPE[0X15] = "Workmod";
  CU_TYPE[0X16] = "Gen'd by binder";
  CU_TYPE[0X20] = "PO2";
  CU_TYPE[0X30] = "PO3";
  CU_TYPE[0X41] = "PO4, z/OS 1.3 compat";
  CU_TYPE[0X42] = "z/OS 1.5 compat";
  CU_TYPE[0X43] = "z/OS 1.7 compat";
  CU_TYPE[0X51] = "PO5, z/OS 1.8 compat";

  _IEWAPIContext *apiCnxt, *retCnxt; // APIContext
  _IEWList *files_list;
  _IEWList *exits_list;
  unsigned int rc, reason;

  // initialize api flags
  _IEWAPIFlags apiflags = {0, 0, 0, 0, 0, 0, 0, 0, 0};

  // files list variables
  char *files[] = {"PRINT "};
  char *files_val[] = {" "};
  files_val[0] = fileNameStr;
  free(fileNameStr);

  // exits list variables
  struct _exit_address
  {
    void *entry_point;
    void *user_data;
    void *severity_level;
  } exits_address;

  struct _exit_address exitsA;
  struct _exit_address *exitsPtr;
  char *exits[] = {"SAVE"};
  void *exits_val[1];

  // parms for __iew_openW()
  char *parms = "MAP=Y,XREF=Y,CASE=MIXED,TERM=Y,LIST=ALL";

  exitsA.entry_point = NULL;
  exitsA.user_data = NULL;
  exitsA.severity_level = 0;
  exitsPtr = &exitsA;
  exits_val[0] = exitsPtr;

  // create file list for __iew_openW()
  files_list = __iew_create_list(1, files, (void **)files_val);

  if (files_list == NULL)
  {
    snprintf(buf, bs, " create_list error: files list is null.");
    cStrOut = buf;
    len = strlen(cStrOut);
    cArray = (*env)->NewByteArray(env, len);
    (*env)->SetByteArrayRegion(env, cArray, 0, len, (jbyte *)cStrOut);
    free(cStrOut);
    return cArray;
  }

  // create exits list for __iew_openW()
  exits_list = __iew_create_list(1, exits, exits_val);
  if (exits_list == NULL)
  {
    snprintf(buf, bs, " create_list error: exits list is null.");
    cStrOut = buf;
    len = strlen(cStrOut);
    cArray = (*env)->NewByteArray(env, len);
    (*env)->SetByteArrayRegion(env, cArray, 0, len, (jbyte *)cStrOut);
    free(cStrOut);
    return cArray;
  }

  // open workmod session, load BINDER, create api context with
  // target release = <see above: #define _IEW_TARGET_RELEASE>, intent = access
  apiCnxt = __iew_openW(_IEW_TARGET_RELEASE, _IEW_ACCESS,
                        files_list, exits_list,
                        parms,
                        &rc, &reason);
  if (apiCnxt == NULL)
  {
    snprintf(buf, bs, " openW error: apiCnxt is null.");
    cStrOut = buf;
    len = strlen(cStrOut);
    cArray = (*env)->NewByteArray(env, len);
    (*env)->SetByteArrayRegion(env, cArray, 0, len, (jbyte *)cStrOut);
    free(cStrOut);
    return cArray;
  }

  // set api flags for __iew_includeName()
  apiflags.__imports = 1;
  apiflags.__aliases = 1;
  apiflags.__attrib = 1;

  // read in program object via __iew_includeName()
  rc = __iew_includeName(apiCnxt, path_name, "", apiflags);

  // Free DD
  dynfree(&ip);

  if (rc)
  {
    snprintf(buf, bs, " includeName error: apiCnxt is null. rc=%u, rs=<0X%.8X>.",
             rc, __iew_get_reason_code(apiCnxt));
    cStrOut = buf;
    len = strlen(cStrOut);
    cArray = (*env)->NewByteArray(env, len);
    (*env)->SetByteArrayRegion(env, cArray, 0, len, (jbyte *)cStrOut);
    free(cStrOut);
    return cArray;
  }

  int count;
  _IEWBinderIDEntry *binderEntry;

  while ((count = __iew_getD(apiCnxt, "B_IDRB", NULL, NULL, &binderEntry)) > 0)
  {
    if (binderEntry)
    {
      // Module Bound (slash /) Module text size
      snprintf(buf, bs, "%7s/%d",
               binderEntry->__idb_data_bound,
               binderEntry->__idb_module_size);
    }
  }

  // set api flags for __iew_closeW()
  apiflags.__protect = 1;

  // close workmod session, delete api context
  retCnxt = __iew_closeW(apiCnxt, apiflags, &rc, &reason);
  if (retCnxt)
  {
    snprintf(buf, bs, " closeW error: context is not NULL.");
  }
  // Return to call program with module data
  cStrOut = buf;
  len = strlen(cStrOut);
  cArray = (*env)->NewByteArray(env, len);
  (*env)->SetByteArrayRegion(env, cArray, 0, len, (jbyte *)cStrOut);
  free(cStrOut);
  return cArray;
}
