/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit.manifest;

import com.ibm.jzos.ZFileException;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.dataset.alloc.AllocGenericCommandBuilder;
import com.ibm.urbancode.zos.dataset.alloc.DatasetAllocator;
import com.ibm.urbancode.zos.xml.utils.deploy.Container;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import java.io.File;
import java.util.Map;

public final class CpTempDatasetCreator {
    private static final String SYS_ID_RECLN = "SYS.id.RECLN";
    private static final String SYS_ID_RECFM = "SYS.id.RECFM";
    private static final String SYS_ID_RECORG = "SYS.id.RECORG";
    private static final String SYS_ID_BLKSZ = "SYS.id.BLKSZ";
    private static final String SYS_ID_LIBTYPE = "SYS.id.LIBTYPE";
    private static final String TRACKS = "TRACKS";
    private static final String PDSE = "PDSE";
    private static final String LIBRARY = "LIBRARY";
    private static final String PDS = "PDS";
    private static final int BUFFER_TRACKS = 10;
    private static final int BUFFER_DIR_BLOCKS = 1;
    private static final int MEMBERS_PER_DIR_BLOCK = 6;
    private final PackageManifest packageManifest;
    private final String componentVersionWorkingDir;
    private final Map<String, String> sourceTempDsnMap;

    private CpTempDatasetCreator(PackageManifest packageManifest, String componentVersionWorkingDir, Map<String, String> sourceTempDsnMap) {
        this.packageManifest = packageManifest;
        this.componentVersionWorkingDir = componentVersionWorkingDir;
        this.sourceTempDsnMap = sourceTempDsnMap;
    }

    public static void create(PackageManifest packageManifest, String componentVersionWorkingDir, Map<String, String> sourceTempDsnMap) {
        CpTempDatasetCreator cpTempDatasetCreator = new CpTempDatasetCreator(packageManifest, componentVersionWorkingDir, sourceTempDsnMap);
        cpTempDatasetCreator.createDatasets();
    }

    private void createDatasets() {
        this.packageManifest.getContainers().stream().filter(container -> !container.isDeleted()).filter(Container::isDataset).map(container -> this.getDatasetAllocator((Container)container, this.componentVersionWorkingDir)).forEach(this::allocateDataset);
    }

    private DatasetAllocator getDatasetAllocator(Container container, String componentVersionWorkingDir) {
        Map containerPropertiesMap = container.getCustomerProperties();
        int directoryBlocks = this.getDirectoryBlocks(container, componentVersionWorkingDir);
        String dsnType = this.getDsnType(container);
        String spaceInTracks = this.getSpaceInTracks(container, componentVersionWorkingDir);
        String tempDataset = this.sourceTempDsnMap.get(container.getSourceContainerName());
        return new AllocGenericCommandBuilder(tempDataset).withDsOrg((String)containerPropertiesMap.get(SYS_ID_RECORG)).withRecordLength((String)containerPropertiesMap.get(SYS_ID_RECLN)).withBlockSize((String)containerPropertiesMap.get(SYS_ID_BLKSZ)).withSpace(spaceInTracks, spaceInTracks).withSpaceUnit(TRACKS, (String)containerPropertiesMap.get(SYS_ID_RECLN)).withRecordFormat((String)containerPropertiesMap.get(SYS_ID_RECFM)).withDatasetType(dsnType).withDirectoryBlocks(String.valueOf(directoryBlocks)).build();
    }

    private int getDirectoryBlocks(Container container, String componentVersionWorkingDir) {
        if (container.isSequential()) {
            return 0;
        }
        String sourceContainer = container.getSourceContainerName();
        String containerDir = componentVersionWorkingDir + File.separator + sourceContainer;
        int totalMembers = FileHelper.getNumberOfFiles(containerDir);
        return totalMembers / 6 + 1;
    }

    private String getDsnType(Container container) {
        if (container.isSequential()) {
            return "";
        }
        String libraryType = (String)container.getCustomerProperties().get(SYS_ID_LIBTYPE);
        if (libraryType.trim().equals(PDSE)) {
            return LIBRARY;
        }
        return PDS;
    }

    private String getSpaceInTracks(Container container, String componentVersionWorkingDir) {
        String containerDirectory = componentVersionWorkingDir + File.separator + container.getSourceContainerName();
        int spaceInTracks = FileHelper.getDirectorySizeInTracks(containerDirectory) + 10;
        return String.valueOf(spaceInTracks);
    }

    private void allocateDataset(DatasetAllocator datasetAllocator) {
        try {
            datasetAllocator.allocate();
        }
        catch (ZFileException e) {
            throw new RuntimeException(e);
        }
    }
}

