/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.deployment;

import com.ibm.urbancode.zos.xml.utils.common.ContainerType;
import com.ibm.urbancode.zos.xml.utils.common.XmlHelper;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackContainer;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackResource;
import com.urbancode.air.plugin.command.version.common.XmlIndentHandler;
import java.io.StringWriter;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class DeltaDeployedXml {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String XML_VERSION = "1.0";
    private static final String CREATED = "created";
    private static final String UPDATED = "updated";
    private static final String DELETED = "deleted";
    private static final String MANIFEST = "manifest";
    private static final String MANIFEST_REPORT = "MANIFEST_REPORT";
    private static final String CONTAINER = "container";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String MISSING = "missing";
    private static final String TRUE = "true";
    private static final String RESOURCE = "resource";
    private static final String PDS = "PDS";
    private static final String SEQUENTIAL = "sequential";
    private static final String DIRECTORY = "directory";
    private final XmlIndentHandler xmlIndentHandler = new XmlIndentHandler();
    private XMLStreamWriter xmlStreamWriter = null;
    private final List<RollbackContainer> createdContainers;
    private final List<RollbackContainer> updatedContainers;
    private final List<RollbackContainer> deletedContainers;

    private DeltaDeployedXml(List<RollbackContainer> createdContainers, List<RollbackContainer> updatedContainers, List<RollbackContainer> deletedContainers) {
        this.createdContainers = createdContainers;
        this.updatedContainers = updatedContainers;
        this.deletedContainers = deletedContainers;
    }

    public static String from(List<RollbackContainer> createdContainers, List<RollbackContainer> updatedContainers, List<RollbackContainer> deletedContainers) throws XMLStreamException {
        DeltaDeployedXml deltaDeployedXml = new DeltaDeployedXml(createdContainers, updatedContainers, deletedContainers);
        return deltaDeployedXml.create();
    }

    private String create() throws XMLStreamException {
        StringWriter stringWriter = new StringWriter();
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        try {
            this.xmlStreamWriter = outputFactory.createXMLStreamWriter(stringWriter);
            this.writeXmlElements();
        }
        finally {
            if (this.xmlStreamWriter != null) {
                this.xmlStreamWriter.close();
            }
        }
        return stringWriter.toString();
    }

    private void writeXmlElements() throws XMLStreamException {
        this.writeXmlHeaderTag();
        this.writeStartingManifestTag();
        this.writeCreatedContainers();
        this.writeUpdatedContainers();
        this.writeDeletedContainers();
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeEndDocument();
    }

    private void writeCreatedContainers() throws XMLStreamException {
        this.writeStartingTag(CREATED);
        for (RollbackContainer createdContainer : this.createdContainers) {
            this.writeContainerTag(createdContainer);
        }
        this.writeEndingTag();
    }

    private void writeUpdatedContainers() throws XMLStreamException {
        this.writeStartingTag(UPDATED);
        for (RollbackContainer updatedContainer : this.updatedContainers) {
            this.writeContainerTag(updatedContainer);
        }
        this.writeEndingTag();
    }

    private void writeDeletedContainers() throws XMLStreamException {
        this.writeStartingTag(DELETED);
        for (RollbackContainer deletedContainer : this.deletedContainers) {
            this.writeContainerTag(deletedContainer);
        }
        this.writeEndingTag();
    }

    private void writeXmlHeaderTag() throws XMLStreamException {
        this.xmlStreamWriter.writeStartDocument(XmlHelper.getFileEncoding(), XML_VERSION);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeStartingManifestTag() throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement(MANIFEST);
        this.xmlStreamWriter.writeAttribute(TYPE, MANIFEST_REPORT);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeContainerTag(RollbackContainer rollbackContainer) throws XMLStreamException {
        this.writeStartingContainerTag(rollbackContainer);
        for (RollbackResource rollbackResource : rollbackContainer.getResources()) {
            this.writeSelfClosingResourceTag(rollbackResource);
        }
        this.writeEndingTag();
    }

    private void writeStartingContainerTag(RollbackContainer rollbackContainer) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement(CONTAINER);
        this.xmlStreamWriter.writeAttribute(NAME, rollbackContainer.getName());
        this.xmlStreamWriter.writeAttribute(TYPE, this.getContainerType(rollbackContainer.getType()));
        if (rollbackContainer.isMissing()) {
            this.xmlStreamWriter.writeAttribute(MISSING, TRUE);
        }
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private String getContainerType(ContainerType type) {
        if (type == ContainerType.PDS) {
            return PDS;
        }
        if (type == ContainerType.SEQUENTIAL) {
            return SEQUENTIAL;
        }
        if (type == ContainerType.DIRECTORY) {
            return DIRECTORY;
        }
        throw new IllegalArgumentException("Unsupported container type found " + type);
    }

    private void writeSelfClosingResourceTag(RollbackResource rollbackResource) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getSelfClosingTagIndent());
        this.xmlStreamWriter.writeEmptyElement(RESOURCE);
        this.xmlStreamWriter.writeAttribute(NAME, rollbackResource.getName());
        this.xmlStreamWriter.writeAttribute(TYPE, rollbackResource.getType());
        if (rollbackResource.isMissing()) {
            this.xmlStreamWriter.writeAttribute(MISSING, TRUE);
        }
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeStartingTag(String elementName) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement(elementName);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeEndingTag() throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getEndingTagIndent());
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }
}

