/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit.manifest;

import com.ibm.team.enterprise.deployment.toolkit.manifest.ProcessExecutor;
import com.ibm.urbancode.zos.common.util.AgentInstalledProperties;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.common.util.PluginFilesHelper;
import com.ibm.urbancode.zos.dataset.util.TempDsnNameHelper;
import com.ibm.urbancode.zos.rexx.RexxExecutor;
import com.urbancode.air.plugin.command.version.deployment.DeployManifestMvsGenerator;
import java.io.File;

public class OldPackageFormatDeployer {
    private static final String SPACE = " ";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String DEPLOY_MANIFEST_MVS_XML = "DeployManifestMvs.xml";
    private final boolean isTraceOn;
    private final String tempDsnPrefix;
    private final String ispfGatewayBinPath;
    private static final AgentInstalledProperties agentInstalledProperties = new AgentInstalledProperties();

    public OldPackageFormatDeployer(boolean isTraceOn, String tempDsnPrefix, String ispfGatewayPath) {
        this.isTraceOn = isTraceOn;
        this.tempDsnPrefix = tempDsnPrefix;
        this.ispfGatewayBinPath = ispfGatewayPath;
    }

    public void deploy(String manifestDeployFilePath, String containerMapperFilePath, String componentVersionWorkingDir) throws Exception {
        String xmlString = DeployManifestMvsGenerator.generate(manifestDeployFilePath);
        String deployManifestMvsPath = componentVersionWorkingDir + File.separator + DEPLOY_MANIFEST_MVS_XML;
        FileHelper.writeStringToFile(xmlString, deployManifestMvsPath);
        String packageZipFilePath = componentVersionWorkingDir + File.separator + "package.zip";
        if (FileHelper.isFileExist(packageZipFilePath)) {
            ProcessExecutor.extractUsingPaxCommand(componentVersionWorkingDir, "package.zip");
        }
        this.executeRexxProgram(deployManifestMvsPath, containerMapperFilePath, componentVersionWorkingDir);
    }

    private void executeRexxProgram(String manifestFilePath, String containerMapperFilePath, String componentVersionWorkingDir) throws Exception {
        RexxExecutor rexxExecutor = new RexxExecutor(this.tempDsnPrefix, this.ispfGatewayBinPath);
        String rexxArguments = this.getRexxArguments(manifestFilePath, containerMapperFilePath, componentVersionWorkingDir);
        rexxExecutor.execute(PluginFilesHelper.getDeploymentV1RexxFilePath(), rexxArguments);
    }

    private String getRexxArguments(String manifestFilePath, String containerMapperFilePath, String componentVersionWorkingDir) {
        return DOUBLE_QUOTE + manifestFilePath + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + containerMapperFilePath + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + this.isTraceOn + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + TempDsnNameHelper.getReceiveDataset(this.tempDsnPrefix) + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + componentVersionWorkingDir + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + agentInstalledProperties.getSysoutClass() + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + agentInstalledProperties.getTempUnit() + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + agentInstalledProperties.getTempVolser() + DOUBLE_QUOTE;
    }
}

