/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.jcl.submit;

import com.urbancode.air.plugin.command.jcl.common.JmonInputs;
import com.urbancode.air.plugin.exceptions.MissingInputException;
import java.nio.file.Paths;
import java.util.Properties;

class SubmitJobInputs {
    public static final String PLUGIN_INPUT_PROPS = "PLUGIN_INPUT_PROPS";
    public static final String MVS_FILENAME = "mvsFilename";
    public static final String USS_FILENAME = "ussFilename";
    public static final String JCL_STRING = "jclString";
    public static final String JOB_CARD = "jobCard";
    public static final String EXPLICIT_TOKENS = "explicitTokens";
    public static final String EXPLICIT_TOKENS_FOREACH_JOB = "explicitTokensForeachJob";
    public static final String WAIT_FOR_JOB = "waitForJob";
    public static final String STOP_ON_FAIL = "stopOnFail";
    public static final String OUTPUT_PAGINATION = "outputPagination";
    private final String mvsFilename;
    private final String ussFilename;
    private final String jclString;
    private final String jobCard;
    private final String explicitTokens;
    private final String jclTokenGroups;
    private final boolean waitForJob;
    private final boolean stopOnFail;
    private final boolean outputPagination;
    private final String inputPropsFilePath;
    private final JmonInputs jmonInputs;

    private SubmitJobInputs(Properties inputProperties) {
        this.mvsFilename = inputProperties.getProperty(MVS_FILENAME).trim().toUpperCase();
        this.ussFilename = inputProperties.getProperty(USS_FILENAME).trim();
        this.jclString = inputProperties.getProperty(JCL_STRING).trim();
        this.jobCard = inputProperties.getProperty(JOB_CARD).trim();
        this.explicitTokens = inputProperties.getProperty(EXPLICIT_TOKENS).trim();
        this.jclTokenGroups = inputProperties.getProperty(EXPLICIT_TOKENS_FOREACH_JOB).trim();
        this.waitForJob = Boolean.parseBoolean(inputProperties.getProperty(WAIT_FOR_JOB).trim());
        this.stopOnFail = Boolean.parseBoolean(inputProperties.getProperty(STOP_ON_FAIL).trim());
        this.outputPagination = Boolean.parseBoolean(inputProperties.getProperty(OUTPUT_PAGINATION).trim());
        this.inputPropsFilePath = inputProperties.getProperty(PLUGIN_INPUT_PROPS).trim();
        this.jmonInputs = JmonInputs.getValidatedInputs(inputProperties);
    }

    public static SubmitJobInputs getValidatedInputs(Properties inputProperties) {
        SubmitJobInputs submitJobInputs = new SubmitJobInputs(inputProperties);
        submitJobInputs.validate();
        return submitJobInputs;
    }

    private void validate() {
        boolean isNoJclInputsPassed;
        boolean bl = isNoJclInputsPassed = this.mvsFilename.isEmpty() && this.ussFilename.isEmpty() && this.jclString.isEmpty();
        if (isNoJclInputsPassed) {
            throw new MissingInputException("At least one JCL input (JCL Dataset, JCL File or JCL) must be specified.");
        }
    }

    public String getMvsFilename() {
        return this.mvsFilename;
    }

    public String getUssFilename() {
        return this.ussFilename;
    }

    public String getJclString() {
        return this.jclString;
    }

    public String getJobCard() {
        return this.jobCard;
    }

    public String getExplicitTokens() {
        return this.explicitTokens;
    }

    public String getJclTokenGroups() {
        return this.jclTokenGroups;
    }

    public boolean isWaitForJob() {
        return this.waitForJob;
    }

    public boolean isStopOnFail() {
        return this.stopOnFail;
    }

    public boolean isOutputPaginationEnabled() {
        return this.outputPagination;
    }

    public String getStdOutFileDirectory() {
        return Paths.get(this.inputPropsFilePath, new String[0]).getParent().toString();
    }

    public JmonInputs getJmonInputs() {
        return this.jmonInputs;
    }
}

