/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.rollback;

import com.ibm.team.enterprise.deployment.toolkit.manifest.ProcessExecutor;
import com.ibm.urbancode.zos.common.util.AgentInstalledProperties;
import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.common.util.PluginFilesHelper;
import com.ibm.urbancode.zos.dataset.util.TempDsnNameHelper;
import com.ibm.urbancode.zos.rexx.RexxExecutor;
import java.io.File;

class RollbackRexxExecutor {
    public static final String SPACE = " ";
    public static final String DOUBLE_QUOTE = "\"";
    private final boolean isTraceOn;
    private final String tempDsnPrefix;
    private final String ispfGatewayBinPath;
    private static final AgentInstalledProperties agentInstalledProperties = new AgentInstalledProperties();

    public RollbackRexxExecutor(boolean isTraceOn, String tempDsnPrefix, String ispfGatewayPath) {
        this.isTraceOn = isTraceOn;
        this.tempDsnPrefix = tempDsnPrefix;
        this.ispfGatewayBinPath = ispfGatewayPath;
    }

    public void deployFromBackup(String rollbackManifestFilePath, String versionWorkDir) throws Exception {
        String backupZipFilePath = versionWorkDir + File.separator + "backup.zip";
        if (FileHelper.isFileExist(backupZipFilePath)) {
            ProcessExecutor.extractUsingPaxCommand(versionWorkDir, "backup.zip");
        }
        this.executeRexxProgram(rollbackManifestFilePath, versionWorkDir);
    }

    private void executeRexxProgram(String manifestFilePath, String versionWorkDir) throws Exception {
        RexxExecutor rexxExecutor = new RexxExecutor(this.tempDsnPrefix, this.ispfGatewayBinPath);
        String rexxArguments = this.getRexxArguments(manifestFilePath, versionWorkDir);
        rexxExecutor.execute(PluginFilesHelper.getRollbackRexxFilePath(), rexxArguments);
    }

    private String getRexxArguments(String manifestFilePath, String versionWorkDir) {
        return DOUBLE_QUOTE + manifestFilePath + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + this.isTraceOn + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + TempDsnNameHelper.getReceiveDataset(this.tempDsnPrefix) + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + versionWorkDir + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + agentInstalledProperties.getSysoutClass() + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + agentInstalledProperties.getTempUnit() + DOUBLE_QUOTE + SPACE + DOUBLE_QUOTE + agentInstalledProperties.getTempVolser() + DOUBLE_QUOTE;
    }
}

